/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.schema.Namespace;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class RuleImplNamespaceURIFormat
extends RuleImpl {
    private static final long serialVersionUID = 1L;
    private static final String XPATH_FXS = "/descendant::*[local-name()='FreieXMLStruktur' and @lib:NamespaceURI]";
    public static final String REG_EX_URI_FORMAT = "urn:de:bmu:eanv:[a-z0-9_,:=@;!'%/#\\(\\)\\+\\-\\.\\$\\*\\?]{1,}(:[0-9]{1,3}){2}";

    public RuleImplNamespaceURIFormat(RuleDef ruleDef) {
        super(ruleDef);
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        NodeList nl;
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        try {
            nl = XPathFassade.getInstance().evaluateNodeList(bmuDok.getDocument(), XPATH_FXS);
        }
        catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Pr\u00fcfen", e);
        }
        int index = 1;
        for (int i = 0; i < nl.getLength(); ++i) {
            Element nodeFxs = (Element)nl.item(i);
            String nsURI = nodeFxs.getAttributeNS(Namespace.TypenBibliothek.getUri(), "NamespaceURI");
            String id = nodeFxs.getAttributeNS(Namespace.TypenBibliothek.getUri(), "id");
            if (nsURI == null || nsURI.toLowerCase().matches(REG_EX_URI_FORMAT)) continue;
            ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, id));
        }
        return ruleResultList;
    }

    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        builder.append("XPath f\u00fcr die Ermittlung der freien XML-Strukturen: ");
        builder.append(XPATH_FXS);
        builder.append(", Regul\u00e4rer Ausdruck f\u00fcr die Pr\u00fcfung: ");
        builder.append(REG_EX_URI_FORMAT);
        return builder.toString();
    }
}

