/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.util.XmlUtils;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class RuleImplSchemaNoPrefix
extends RuleImpl {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(RuleImplSchemaNoPrefix.class);
    private static final String XPATH_NO_PREFIX = "//*[namespace-uri()='']";

    public RuleImplSchemaNoPrefix(RuleDef ruleDef) {
        super(ruleDef);
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        XPathFassade xpf = XPathFassade.getInstance();
        try {
            NodeList nodeList = xpf.evaluateNodeList(bmuDok.getDocument(), XPATH_NO_PREFIX);
            int index = 1;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                String path = XmlUtils.getNodePathShort(node);
                ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, path));
                LOGGER.debug((Object)("Element ohne Pr\u00e4fix gefunden: " + path));
            }
        }
        catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Pr\u00fcfen", e);
        }
        return ruleResultList;
    }

    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        builder.append("XPath f\u00fcr die Ermittlung der zu pr\u00fcfenden Inhalte: ");
        builder.append(XPATH_NO_PREFIX);
        return builder.toString();
    }
}

