/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.SignatureVerificationResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.xmlsec.XmlSecFassade;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class RuleImplSignatureKeyInfo
extends RuleImpl {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(RuleImplSignatureKeyInfo.class);
    private static final String TECHDOC = "Pr\u00fcft den Inhalt von KeyInfo (ds:Signature/ds:KeyInfo) in allen Signaturen im Dokument auf die Eintraege 'X509Certificate' und 'X509SubjectName',  diese muessen jeweils genau einmal pro Signatur vorhanden sein und das Zertifikat muss zu dem \u00f6ffentlichen Schl\u00fcssel im KeyValue passen.";
    private static final String XPATH_SIGNATURE = "/descendant::ds:Signature[@Id]";

    public RuleImplSignatureKeyInfo(RuleDef ruleDef) {
        super(ruleDef);
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        NodeList nl;
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        XPathFassade xpf = XPathFassade.getInstance();
        try {
            nl = xpf.evaluateNodeList(bmuDok.getDocument(), XPATH_SIGNATURE);
        }
        catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Pr\u00fcfen", e);
        }
        int index = 1;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node sigNode = nl.item(i);
            if (!(sigNode instanceof Element)) continue;
            Element sigElem = (Element)sigNode;
            String sigID = sigElem.getAttribute("Id");
            SignatureVerificationResult svr = bmuDok.getMessageType().getSignatureVerificationResult(sigID);
            if (!svr.isEnabled(this.getRuleDef()) || svr.isEIDAS()) continue;
            LOGGER.debug((Object)("Pr\u00fcfe X509Certificate in Signatur mit der ID: " + sigID));
            if (XmlSecFassade.getInstance().validateX509Certificate(sigElem)) continue;
            String msg = "X509Certificate passt nicht zur Signatur mit der ID: " + sigID;
            LOGGER.debug((Object)msg);
            ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, sigID));
        }
        return ruleResultList;
    }

    public static String getTechDoc() {
        return TECHDOC;
    }
}

