/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.SignatureVerificationResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class RuleImplSignatureXPath
extends RuleImpl {
    private static final long serialVersionUID = 1L;
    private static final String XPATH_SIGXPATH = "/descendant::dsf:XPath[@Filter='intersect']";

    public RuleImplSignatureXPath(RuleDef ruleDef) {
        super(ruleDef);
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        try {
            NodeList nl = XPathFassade.getInstance().evaluateNodeList(bmuDok.getDocument(), XPATH_SIGXPATH);
            int index = 1;
            for (int i = 0; i < nl.getLength(); ++i) {
                String xPath;
                Element xPathNode = (Element)nl.item(i);
                String sigID = XPathFassade.getInstance().evaluate(xPathNode, "ancestor::ds:Signature/@Id");
                SignatureVerificationResult svr = bmuDok.getMessageType().getSignatureVerificationResult(sigID);
                if (!svr.isEnabled(this.getRuleDef()) || (xPath = xPathNode.getTextContent()).startsWith("here()") || xPath.contains("LayerID")) continue;
                ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, sigID));
            }
        }
        catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Pr\u00fcfen", e);
        }
        return ruleResultList;
    }

    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        builder.append("XPath f\u00fcr die Ermittlung der zu pr\u00fcfenden Inhalte: ");
        builder.append(XPATH_SIGXPATH);
        builder.append(", die ermittelten XPath-Audr\u00fccke werden auf das Vorkommen von 'here()' bzw. 'LayerID' gepr\u00fcft. ");
        builder.append("Wenn beide Zeichenketten nicht gefunden werden, ist die Wahrscheinlichkeit gro\u00df, ");
        builder.append("dass es bei der Einbettung in andere BMU-Dokumente('ENSNDokument', 'Registerauszug') zu Problemen kommt.");
        return builder.toString();
    }
}

