/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.util;

import de.consist.bmu.rule.error.BMUException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collections;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;

public final class CertUtils {
    private static final Log LOGGER = LogFactory.getLog(CertUtils.class);

    private CertUtils() {
    }

    public static X509Certificate getX509Certificate(byte[] certData) throws CertificateException, NoSuchProviderException {
        if (certData == null || certData.length == 0) {
            throw new IllegalArgumentException("certData must not be null or empty");
        }
        X509Certificate x509Cert = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(certData);
        x509Cert = CertUtils.getX509Certificate(bais);
        return x509Cert;
    }

    public static X509Certificate getX509Certificate(InputStream inStream) throws CertificateException, NoSuchProviderException {
        if (inStream == null) {
            throw new IllegalArgumentException("inStream must not be null");
        }
        X509Certificate x509Cert = null;
        Certificate cert = CertificateFactory.getInstance("X.509", "BC").generateCertificate(inStream);
        if (cert instanceof X509Certificate) {
            x509Cert = (X509Certificate)cert;
        } else {
            LOGGER.warn((Object)"Certificate is not of type 'X509Certificate'.");
        }
        return x509Cert;
    }

    public static X509Certificate getX509CertificateFromBase64(String certBase64) throws CertificateException, NoSuchProviderException {
        if (certBase64 == null || certBase64.equals("")) {
            throw new IllegalArgumentException("certBase64 must not be null or empty");
        }
        return CertUtils.getX509Certificate(Base64.decodeBase64((String)certBase64));
    }

    private static String getCN(X500Principal x500Principal) {
        RDN[] rdn;
        String cn = null;
        String nameRFC1779 = x500Principal.getName("RFC1779");
        String nameRFC2253 = x500Principal.getName("RFC2253");
        LOGGER.debug((Object)("RFC1779 formatted distinguished name: " + nameRFC1779));
        LOGGER.debug((Object)("RFC2253 formatted distinguished name: " + nameRFC2253));
        X500Name x500Name = null;
        try {
            LOGGER.debug((Object)"trying RFC1779 formatted distinguished name");
            x500Name = new X500Name(nameRFC1779);
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Error initializing X500Name with RFC1779 formatted name", (Throwable)e);
        }
        if (x500Name == null || x500Name.getRDNs(BCStyle.CN).length == 0) {
            try {
                LOGGER.debug((Object)"trying RFC2253 formatted distinguished name");
                x500Name = new X500Name(nameRFC2253);
            }
            catch (Exception e1) {
                LOGGER.error((Object)"Error initializing X500Name with RFC2253 formatted name", (Throwable)e1);
                return null;
            }
        }
        if ((rdn = x500Name.getRDNs(BCStyle.CN)).length == 0) {
            LOGGER.error((Object)"No CN found in X.500 distinguished name");
            return null;
        }
        cn = rdn[0].getFirst().getValue().toString();
        LOGGER.debug((Object)("CN=" + cn));
        return cn;
    }

    public static String getSubjectCN(X509Certificate x509Cert) throws BMUException {
        if (x509Cert == null) {
            throw new IllegalArgumentException("x509Cert must not be null or empty");
        }
        X500Principal x500Principal = x509Cert.getSubjectX500Principal();
        String cn = CertUtils.getCN(x500Principal);
        LOGGER.debug((Object)("<getSubjectCN> cn=" + cn));
        return cn;
    }

    public static String getIssuerCN(X509Certificate x509Cert) throws BMUException {
        if (x509Cert == null) {
            throw new IllegalArgumentException("x509Cert must not be null or empty");
        }
        X500Principal x500Principal = x509Cert.getIssuerX500Principal();
        String cn = CertUtils.getCN(x500Principal);
        LOGGER.debug((Object)("<getIssuerCN> cn=" + cn));
        return cn;
    }

    public static String getOcspUrl(X509Certificate certificate) throws Exception {
        byte[] octetBytes = certificate.getExtensionValue(Extension.authorityInfoAccess.getId());
        DLSequence dlSequence = null;
        ASN1Encodable asn1Encodable = null;
        try {
            int i;
            ASN1Primitive fromExtensionValue = JcaX509ExtensionUtils.parseExtensionValue((byte[])octetBytes);
            if (!(fromExtensionValue instanceof DLSequence)) {
                return null;
            }
            dlSequence = (DLSequence)fromExtensionValue;
            for (i = 0; i < dlSequence.size() && !((asn1Encodable = dlSequence.getObjectAt(i)) instanceof DLSequence); ++i) {
            }
            if (!(asn1Encodable instanceof DLSequence)) {
                return null;
            }
            dlSequence = (DLSequence)asn1Encodable;
            for (i = 0; i < dlSequence.size() && !((asn1Encodable = dlSequence.getObjectAt(i)) instanceof DERTaggedObject); ++i) {
            }
            if (!(asn1Encodable instanceof DERTaggedObject)) {
                return null;
            }
            DERTaggedObject derTaggedObject = (DERTaggedObject)asn1Encodable;
            byte[] encoded = derTaggedObject.getEncoded();
            if (derTaggedObject.getTagNo() == 6) {
                byte len = encoded[1];
                return new String(encoded, 2, (int)len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void convertP12ToJks(File jksFile, File p12File, char[] pw) throws BMUException {
        try {
            KeyStore p12 = KeyStore.getInstance("PKCS12");
            p12.load(new FileInputStream(p12File), pw);
            KeyStore jks = KeyStore.getInstance("JKS");
            jks.load(null, null);
            for (String alias : Collections.list(p12.aliases())) {
                if (!p12.isKeyEntry(alias)) continue;
                Key key = p12.getKey(alias, pw);
                Certificate[] chain = p12.getCertificateChain(alias);
                jks.setKeyEntry(alias, key, pw, chain);
            }
            FileOutputStream out = new FileOutputStream(jksFile);
            jks.store(out, pw);
            out.close();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Fehler beim Umwandeln des KeyStore " + jksFile.getAbsolutePath()), (Throwable)e);
            throw new BMUException("Fehler beim Umwandeln des KeyStore " + jksFile.getAbsolutePath(), e);
        }
    }
}

