/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public abstract class OSUtil {
    public static final List<String> readCmdOutput(String command) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String line;
            StringTokenizer st = new StringTokenizer("cmd /c " + command);
            String[] cmdarray = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                cmdarray[i] = st.nextToken();
                ++i;
            }
            Process p = Runtime.getRuntime().exec(cmdarray);
            p.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (line == null || line.trim().isEmpty()) continue;
                result.add(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static final String readCmdOutput(String command, int lineNumber) {
        List<String> result = OSUtil.readCmdOutput(command);
        if (result.size() < lineNumber) {
            return null;
        }
        return result.get(lineNumber - 1);
    }

    public static final String getBiosSerial() {
        return OSUtil.readCmdOutput("WMIC BIOS GET SERIALNUMBER", 2);
    }

    public static final String getHardwareModel() {
        return OSUtil.readCmdOutput("WMIC COMPUTERSYSTEM GET MODEL", 2);
    }

    public static final String getHardwareManufacturer() {
        return OSUtil.readCmdOutput("WMIC COMPUTERSYSTEM GET MANUFACTURER", 2);
    }

    public static final String getNumberOfProcessors() {
        return OSUtil.readCmdOutput("WMIC COMPUTERSYSTEM GET NUMBEROFPROCESSORS", 2);
    }

    public static final String getNumberOfCores() {
        return OSUtil.readCmdOutput("WMIC CPU GET NUMBEROFCORES", 2);
    }

    public static final String getNumberOfLogicalProcessors() {
        return OSUtil.readCmdOutput("WMIC CPU GET NUMBEROFLOGICALPROCESSORS", 2);
    }

    public static final String getCPUName() {
        return OSUtil.readCmdOutput("WMIC CPU GET NAME", 2);
    }

    public static final String getMaxProcessMemorySize() {
        return OSUtil.readCmdOutput("WMIC OS GET MaxProcessMemorySize", 2);
    }

    public static void main(String[] args) {
        System.out.println("BIOS Serial: " + OSUtil.getBiosSerial());
        System.out.println("Hardware Model: " + OSUtil.getHardwareModel());
        System.out.println("Hardware Manufacturer: " + OSUtil.getHardwareManufacturer());
        System.out.println("CPU Name: " + OSUtil.getCPUName());
        System.out.println("Number of Processors: " + OSUtil.getNumberOfProcessors());
        System.out.println("Number of Cores: " + OSUtil.getNumberOfCores());
        System.out.println("Number of logical Processors: " + OSUtil.getNumberOfLogicalProcessors());
        System.out.println("Maximum number, in kilobytes, of memory that can be allocated to a process: " + OSUtil.getMaxProcessMemorySize());
    }
}

