/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.util;

import de.consist.bmu.rule.error.BMUException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class XmlUtils {
    private static final Log LOGGER = LogFactory.getLog(XmlUtils.class);

    private XmlUtils() {
    }

    public static void writeToFile(Document doc, String filename) throws BMUException {
        XmlUtils.writeToFile(doc, filename, null);
    }

    public static void writeToFile(Document doc, String filename, String encoding) throws BMUException {
        File f = new File(filename);
        try {
            FileOutputStream fos = new FileOutputStream(f);
            XmlUtils.writeToStream(doc, fos, encoding);
        }
        catch (Exception ex) {
            LOGGER.error((Object)("error writing to file: " + f.getAbsolutePath()), (Throwable)ex);
            throw new BMUException("error writing to file: " + f.getAbsolutePath(), ex);
        }
    }

    public static void writeToStream(Document doc, OutputStream outStream, String encoding) throws BMUException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        try {
            DOMSource source = new DOMSource(doc);
            Transformer transformer = tFactory.newTransformer();
            StreamResult result = null;
            if (encoding != null) {
                transformer.setOutputProperty("encoding", encoding);
                result = new StreamResult(new OutputStreamWriter(outStream, encoding));
            } else {
                result = new StreamResult(outStream);
            }
            transformer.transform(source, result);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"error writing to stream", (Throwable)ex);
            throw new BMUException("error writing to stream", ex);
        }
    }

    public static byte[] serialize(Document doc) throws BMUException {
        byte[] retVal = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XmlUtils.writeToStream(doc, bos, "UTF-8");
        retVal = bos.toByteArray();
        return retVal;
    }

    public static Document readFromFile(String filename) throws BMUException {
        return XmlUtils.readFromFile(filename, null);
    }

    public static Document readFromResource(String name, String encoding) throws BMUException {
        InputStream is = XmlUtils.class.getResourceAsStream(name);
        if (is == null) {
            LOGGER.error((Object)("error loading resource: " + name));
            throw new BMUException("error loading resource: " + name);
        }
        return XmlUtils.readFromStream(is);
    }

    public static Document readFromFile(String filename, String encoding) throws BMUException {
        Document doc = null;
        File f = new File(filename);
        if (f.exists()) {
            try {
                doc = XmlUtils.readFromStream(new FileInputStream(f));
            }
            catch (Exception ex) {
                LOGGER.error((Object)("error reading Document from file: " + f.getAbsolutePath()));
                throw new BMUException("error reading Document from file: " + f.getAbsolutePath(), ex);
            }
        } else {
            LOGGER.error((Object)("File not found: " + f.getAbsolutePath()));
            throw new BMUException("File not found: " + f.getAbsolutePath());
        }
        return doc;
    }

    @Deprecated
    public static Document readFromStream(InputStream in, String encoding) throws BMUException {
        return XmlUtils.readFromStream(in);
    }

    public static Document readFromStream(InputStream in) throws BMUException {
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(in);
            doc = db.parse(is);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"error reading Document from stream", (Throwable)ex);
            throw new BMUException("error reading Document from stream", ex);
        }
        return doc;
    }

    public static Document readFromSource(InputSource in) throws BMUException {
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(in);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"error reading Document from source", (Throwable)ex);
            throw new BMUException("error reading Document from source", ex);
        }
        return doc;
    }

    public static Document newDocument(boolean nsAware) throws BMUException {
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            dbf.setNamespaceAware(nsAware);
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.newDocument();
        }
        catch (Exception ex) {
            LOGGER.error((Object)"error creating Document", (Throwable)ex);
            throw new BMUException("error creating Document", ex);
        }
        return doc;
    }

    public static String getNodePathShort(Node node) throws BMUException {
        Object path = "";
        for (int depth = 2; node != null && depth > 0; --depth, node = node.getParentNode()) {
            path = "/" + node.getNodeName() + (String)path;
        }
        path = ".." + (String)path;
        return path;
    }

    public static Element getFirstChildElement(Element parent) {
        Element retVal = null;
        Node childNode = parent.getFirstChild();
        while (!(childNode instanceof Element)) {
            childNode = childNode.getNextSibling();
        }
        if (childNode instanceof Element) {
            retVal = (Element)childNode;
        }
        return retVal;
    }

    public static Element getChildElement(Element parent, String namespace, String localName) {
        NodeList namedElements = parent.getElementsByTagNameNS(namespace, localName);
        if (namedElements.getLength() < 1) {
            return null;
        }
        return (Element)namedElements.item(0);
    }

    public static String getAttributeValue(Element elem, String name) {
        Attr attr = elem.getAttributeNodeNS(null, name);
        return attr == null ? null : attr.getValue();
    }

    public static Element getNextSiblingElement(Node node) {
        Node sibling;
        for (sibling = node.getNextSibling(); sibling != null && sibling.getNodeType() != 1; sibling = sibling.getNextSibling()) {
        }
        return (Element)sibling;
    }

    public static String getFullXPath(Node endNode) {
        return XmlUtils.getFullXPath(null, endNode);
    }

    public static String getFullXPath(Node startNode, Node endNode) {
        if (endNode == null) {
            throw new IllegalArgumentException("Node must not be null");
        }
        Node parent = null;
        Stack<Node> hierarchy = new Stack<Node>();
        StringBuffer buffer = new StringBuffer();
        hierarchy.push(endNode);
        switch (endNode.getNodeType()) {
            case 2: {
                parent = ((Attr)endNode).getOwnerElement();
                break;
            }
            case 1: {
                parent = endNode.getParentNode();
                break;
            }
            case 9: {
                parent = endNode.getParentNode();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected Node type" + endNode.getNodeType());
            }
        }
        while (parent != null && parent.getNodeType() != 9 && !parent.equals(startNode)) {
            hierarchy.push(parent);
            parent = parent.getParentNode();
        }
        Object obj = null;
        while (!hierarchy.isEmpty()) {
            Object e = hierarchy.pop();
            obj = e;
            if (null == e) break;
            Node node = obj;
            boolean handled = false;
            if (node.getNodeType() == 1) {
                Element e2 = (Element)node;
                if (buffer.length() > 0) {
                    buffer.append("/");
                }
                buffer.append(node.getNodeName());
                if (node.hasAttributes()) {
                    if (e2.hasAttribute("id")) {
                        buffer.append("[@id='" + e2.getAttribute("id") + "']");
                        handled = true;
                    } else if (e2.hasAttribute("name")) {
                        buffer.append("[@name='" + e2.getAttribute("name") + "']");
                        handled = true;
                    }
                }
                if (handled) continue;
                int prev_siblings = 1;
                for (Node prev_sibling = node.getPreviousSibling(); null != prev_sibling; prev_sibling = prev_sibling.getPreviousSibling()) {
                    if (prev_sibling.getNodeType() != node.getNodeType() || !prev_sibling.getNodeName().equalsIgnoreCase(node.getNodeName())) continue;
                    ++prev_siblings;
                }
                buffer.append("[" + prev_siblings + "]");
                continue;
            }
            if (node.getNodeType() != 2) continue;
            buffer.append("/@");
            buffer.append(node.getNodeName());
        }
        return buffer.toString();
    }
}

