/*
 * Decompiled with CFR 0.152.
 */
package de.itu.bmu;

import de.itu.bmu.BMURegCharge;
import de.itu.bmu.BMURegChargeBGS;
import de.itu.xml.XPathFacade;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;

public abstract class BMURegChargeUNS
extends BMURegCharge {
    private static final Logger _logger = LogManager.getLogger(BMURegChargeBGS.class);
    private ChargeUNSType _chargeUNSType;
    private String _unsNummer;

    public BMURegChargeUNS(ChargeUNSType chargeType, Element charge, int index, Object parent) {
        super(BMURegCharge.ChargeType.UNSsolo, index, parent);
        this._chargeUNSType = chargeType;
        try {
            this._unsNummer = XPathFacade.getInstance().evaluate(charge, "descendant::lib:PaginierNr[parent::bgs:UNSNummer][1]");
        }
        catch (Exception e) {
            _logger.error("Fehler beim ermitteln der Daten", (Throwable)e);
        }
    }

    public ChargeUNSType getUNSType() {
        return this._chargeUNSType;
    }

    @Override
    public String getNummer() {
        return this._unsNummer;
    }

    @Override
    public String toString() {
        return String.valueOf((Object)this._chargeUNSType) + ": " + this._unsNummer;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BMURegChargeUNS)) {
            return false;
        }
        if (this._unsNummer == null) {
            return ((BMURegChargeUNS)obj)._unsNummer == null;
        }
        return this._unsNummer.equals(((BMURegChargeUNS)obj)._unsNummer);
    }

    public static enum ChargeUNSType {
        UNSDokument,
        UNSExzerpt;

    }
}

