/*
 * Decompiled with CFR 0.152.
 */
package de.itu.error;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ITUException
extends Exception {
    private static final long serialVersionUID = 1L;
    protected String _explanation = "";
    private Throwable _previous;

    public ITUException(String message) {
        super(message);
    }

    public ITUException(Throwable previous, String message) {
        super(message);
        this._previous = previous;
    }

    public ITUException(String message, Throwable previous) {
        super(message);
        this._previous = previous;
    }

    public ITUException(String message, String explanation) {
        super(message);
    }

    public ITUException(Throwable previous, String message, String explanation) {
        super(message);
        this._previous = previous;
        this.setExplanation(explanation);
    }

    public void setExplanation(String explanation) {
        this._explanation = explanation;
    }

    public String getExplanation() {
        return this._explanation;
    }

    public String getStackTraceS() {
        String result = null;
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        this.printStackTrace(out);
        result = sw.toString();
        return result;
    }

    public Throwable getPrevious() {
        return this._previous;
    }

    public boolean hasHistory() {
        return this._previous != null;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.out);
    }

    @Override
    public void printStackTrace(PrintStream ps) {
        this.printStackTrace(new PrintWriter(ps, true));
    }

    @Override
    public void printStackTrace(PrintWriter pw) {
        super.printStackTrace(pw);
        if (this._previous != null) {
            pw.println("Previous Exception:");
            this._previous.printStackTrace(pw);
        }
        pw.println();
    }
}

