/*
 * Decompiled with CFR 0.152.
 */
package de.itu.util;

import de.itu.util.LogUtils;
import java.util.HashMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CheckDigit {
    private static final char[] ASCII_CODE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '\u00c4', '\u00d6', '\u00dc', '#'};
    private static final int MODULO = 10;
    private static final int FACTOR_ODD = 1;
    private static final int FACTOR_EVEN = 5;
    private static final Logger _logger = LogManager.getLogger(CheckDigit.class);
    private static HashMap<Character, Integer> _oddMap = new HashMap();
    private static HashMap<Character, Integer> _evenMap = new HashMap();
    private static boolean _initialized = false;

    private static void init() {
        for (int i = 0; i < ASCII_CODE.length; ++i) {
            int sum;
            Character ch = Character.valueOf(ASCII_CODE[i]);
            char numVal = ASCII_CODE[i];
            int checksum = 0;
            for (sum = numVal * '\u0001'; sum != 0; sum /= 10) {
                checksum += sum % 10;
            }
            _logger.debug("<init> ODD ASCII: " + ch + ", numVal=" + numVal + ", checkSum=" + checksum);
            _oddMap.put(ch, checksum);
            checksum = 0;
            for (sum = numVal * 5; sum != 0; sum /= 10) {
                checksum += sum % 10;
            }
            _logger.debug("<init> EVEN ASCII: " + ch + ", numVal=" + numVal + ", checkSum=" + checksum);
            _evenMap.put(ch, checksum);
        }
        _initialized = true;
    }

    public static final int getCheckDigit(String source) {
        if (!_initialized) {
            CheckDigit.init();
        }
        int sum = 0;
        int factor = 1;
        for (int i = 0; i < source.length(); ++i) {
            Character ch = Character.valueOf(source.charAt(i));
            Integer val = null;
            if (factor == 1) {
                val = _oddMap.get(ch);
                factor = 5;
            } else {
                val = _evenMap.get(ch);
                factor = 1;
            }
            if (val != null) {
                int value = val;
                _logger.debug("<getCheckDigit> ch=" + ch + ", val=" + value);
                sum += value;
                continue;
            }
            _logger.debug("Ung\u00fcltiges Zeichen: " + ch);
            return -1;
        }
        return 9 - sum % 10;
    }

    public static void main(String[] argv) {
        LogUtils.initLogging(Level.INFO);
        String input = "C#4567890";
        _logger.info("input=" + input + ", checksum=" + CheckDigit.getCheckDigit(input));
    }
}

