/*
 * Decompiled with CFR 0.152.
 */
package de.itu.util;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;

public class ChecksumHelper {
    public static byte[] createChecksum(InputStream inStream) throws Exception {
        int numRead;
        byte[] buffer = new byte[1024];
        MessageDigest complete = MessageDigest.getInstance("SHA-512");
        do {
            if ((numRead = inStream.read(buffer)) <= 0) continue;
            complete.update(buffer, 0, numRead);
        } while (numRead != -1);
        return complete.digest();
    }

    public static String getChecksumFromFile(String filename) throws Exception {
        FileInputStream fis = new FileInputStream(filename);
        byte[] b = ChecksumHelper.createChecksum(fis);
        ((InputStream)fis).close();
        Object result = "";
        for (int i = 0; i < b.length; ++i) {
            result = (String)result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }

    public static String getChecksum(String source, String encoding) throws Exception {
        ByteArrayInputStream fis = new ByteArrayInputStream(source.getBytes(encoding));
        byte[] b = ChecksumHelper.createChecksum(fis);
        fis.close();
        Object result = "";
        for (int i = 0; i < b.length; ++i) {
            result = (String)result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }

    public static void main(String[] args) {
    }

    static enum MessageDigestAlgorithm {
        MD2("MD2"),
        MD5("MD5"),
        SHA1("SHA-1"),
        SHA256("SHA-256"),
        SHA384("SHA-384"),
        SHA512("SHA-512");

        private String _algorithm;

        private MessageDigestAlgorithm(String algorithm) {
            this._algorithm = algorithm;
        }

        String getAlgorithm() {
            return this._algorithm;
        }
    }
}

