/*
 * Decompiled with CFR 0.152.
 */
package de.itu.util;

import de.itu.util.ExecProcessor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExecHelper
implements Runnable {
    private static final Logger _logger = LogManager.getLogger(ExecHelper.class);
    private byte[] inBuffer = new byte[1024];
    private byte[] errBuffer = new byte[1024];
    private Process process;
    private InputStream pErrorStream;
    private InputStream pInputStream;
    private OutputStream pOutputStream;
    private PrintWriter outputWriter;
    private Thread processThread;
    private Thread inReadThread;
    private Thread errReadThread;
    private ExecProcessor handler;

    private ExecHelper(ExecProcessor ep, Process p) {
        this.handler = ep;
        this.process = p;
        this.pErrorStream = this.process.getErrorStream();
        this.pInputStream = this.process.getInputStream();
        this.pOutputStream = this.process.getOutputStream();
        this.outputWriter = new PrintWriter(this.pOutputStream, true);
        this.processThread = new Thread(this);
        this.inReadThread = new Thread(this);
        this.errReadThread = new Thread(this);
        this.processThread.start();
        this.inReadThread.start();
        this.errReadThread.start();
    }

    private void processEnded(int exitValue) {
        this.handler.processEnded(exitValue);
    }

    private void processNewInput(String input) {
        this.handler.processNewInput(input);
    }

    private void processNewError(String error) {
        this.handler.processNewError(error);
    }

    public static ExecHelper exec(ExecProcessor handler, String command) throws IOException {
        File workingDir = new File(System.getProperty("user.dir"));
        return ExecHelper.exec(handler, command, false, workingDir);
    }

    public static ExecHelper exec(ExecProcessor handler, String command, File workingDir) throws IOException {
        return ExecHelper.exec(handler, command, false, workingDir);
    }

    public static ExecHelper exec(ExecProcessor handler, String command, boolean useCmd) throws IOException {
        File workingDir = new File(System.getProperty("user.dir"));
        return ExecHelper.exec(handler, command, useCmd, workingDir);
    }

    public static ExecHelper exec(ExecProcessor handler, String command, boolean useCmd, File workingDir) throws IOException {
        Process p = null;
        try {
            p = useCmd ? Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", "start", "/B", "/WAIT", "\"ExecHelper\"", command}, null, workingDir) : Runtime.getRuntime().exec(command, null, workingDir);
        }
        catch (Exception ex) {
            _logger.error("Fehler beim Auf\u00fchren von 'cmd.exe /c " + command + "'", (Throwable)ex);
            throw new RuntimeException("Fehler beim Auf\u00fchren von 'cmd.exe /c " + command + "'", ex);
        }
        return new ExecHelper(handler, p);
    }

    public void print(String output) {
        this.outputWriter.print(output);
    }

    public void println(String output) {
        this.outputWriter.println(output);
    }

    @Override
    public void run() {
        if (this.processThread == Thread.currentThread()) {
            try {
                this.processEnded(this.process.waitFor());
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        } else if (this.inReadThread == Thread.currentThread()) {
            try {
                int i = 0;
                while (i > -1) {
                    this.processNewInput(new String(this.inBuffer, 0, i));
                    i = this.pInputStream.read(this.inBuffer);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else if (this.errReadThread == Thread.currentThread()) {
            try {
                int i = 0;
                while (i > -1) {
                    this.processNewError(new String(this.errBuffer, 0, i));
                    i = this.pErrorStream.read(this.errBuffer);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void destroy() {
        this.process.destroy();
    }
}

