/*
 * Decompiled with CFR 0.152.
 */
package de.itu.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ISO_3166 {
    private static final Logger LOGGER = LogManager.getLogger(ISO_3166.class);
    private static ISO_3166 theInstance = new ISO_3166();
    private Map<Integer, String> numAlphaMap = new HashMap<Integer, String>();
    private Map<String, String> alphaNumMap = new HashMap<String, String>();
    private Map<String, String> alphaNameMap = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISO_3166() {
        BufferedReader br = null;
        long start = System.currentTimeMillis();
        try {
            LOGGER.debug("<init> start...");
            InputStream is = ISO_3166.class.getResourceAsStream("/de/itu/res/iso-3166.csv");
            if (is != null) {
                br = new BufferedReader(new InputStreamReader(is));
                String line = "";
                while ((line = br.readLine()) != null) {
                    String[] tokens = line.split(",");
                    if (tokens.length != 3) continue;
                    this.numAlphaMap.put(Integer.valueOf(tokens[2]), tokens[1]);
                    this.alphaNumMap.put(tokens[1], tokens[2]);
                    this.alphaNameMap.put(tokens[1], tokens[0]);
                }
            } else {
                LOGGER.error("Resource-Datei f\u00fcr L\u00e4ndercodes kann nicht geladen werden: /de/itu/res/iso-3166.csv");
            }
        }
        catch (Exception e) {
            LOGGER.error("Fehler bei der Initialisierung der L\u00e4ndercodes", (Throwable)e);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                LOGGER.error("error closing BufferedReader", (Throwable)e);
            }
            LOGGER.debug("<init> done, duration: " + (System.currentTimeMillis() - start) + " ms)");
        }
    }

    public static String getLandKuerzel(String code) {
        if (code != null && code.length() > 0) {
            return ISO_3166.theInstance.numAlphaMap.get(Integer.valueOf(code));
        }
        return "";
    }

    public static String getLandCode(String kuerzel) {
        if (kuerzel != null && kuerzel.length() > 0) {
            return ISO_3166.theInstance.alphaNumMap.get(kuerzel);
        }
        return "";
    }

    public static String getLandName(String kuerzel) {
        if (kuerzel != null && kuerzel.length() > 0) {
            return ISO_3166.theInstance.alphaNameMap.get(kuerzel);
        }
        return "";
    }
}

