/*
 * Decompiled with CFR 0.152.
 */
package de.itu.util;

import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javax.crypto.interfaces.DHPublicKey;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class X509CertWrapper {
    private static final Logger _logger = LogManager.getLogger(X509CertWrapper.class);
    private X509Certificate _cert = null;
    private Map<String, String> _attrs = new Hashtable<String, String>(12);
    public static int KEY_USAGE_INDEX_SIGNATURE = 1;
    public static final String[] KEY_USAGE = new String[]{"digitalSignature", "nonRepudiation", "keyEncipherment", "dataEncipherment", "keyAgreement", "keyCertSign", "cRLSign", "encipherOnly", "decipherOnly"};

    public X509CertWrapper(X509Certificate cert) {
        this._cert = cert;
        if (this._cert != null) {
            this._attrs.put("Subject", this._cert.getSubjectX500Principal().getName());
            this._attrs.put("Issuer", this._cert.getIssuerX500Principal().getName());
            this._attrs.put("Valid Not Before", SimpleDateFormat.getDateInstance().format(this._cert.getNotBefore()));
            this._attrs.put("Valid Not After", SimpleDateFormat.getDateInstance().format(this._cert.getNotAfter()));
            this._attrs.put("Version", Integer.toString(this._cert.getVersion()));
            this._attrs.put("Serial Number", this._cert.getSerialNumber().toString());
            this._attrs.put("Signature Algorithm", this._cert.getSigAlgName());
            this._attrs.put("Public Key", X509CertWrapper.getPublicKeyAlgorithm(this._cert));
            this._attrs.put("Key Usage", X509CertWrapper.getKeyUsage(this._cert));
            this._attrs.put("Thumbprint (SHA1)", X509CertWrapper.getThumbprint(this._cert, "SHA1"));
            this._attrs.put("Thumbprint (MD5)", X509CertWrapper.getThumbprint(this._cert, "MD5"));
        }
    }

    public String[] getKeys() {
        Object[] keys = this._attrs.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        return keys;
    }

    public String getValue(String key) {
        return this._attrs.get(key);
    }

    public static String getKeyUsage(X509Certificate cert) {
        boolean[] ku = cert.getKeyUsage();
        StringBuffer buf = new StringBuffer();
        if (ku != null) {
            for (int i = 0; i < ku.length; ++i) {
                if (i >= KEY_USAGE.length || !ku[i]) continue;
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append(KEY_USAGE[i]);
            }
        }
        return buf.toString();
    }

    public static String getThumbprint(X509Certificate cert, String algorithm) {
        String retVal = "";
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            byte[] data = cert.getEncoded();
            byte[] digest = md.digest(data);
            retVal = X509CertWrapper.toHexString(digest);
        }
        catch (Exception ex) {
            _logger.error("error generating digest", (Throwable)ex);
        }
        return retVal;
    }

    public static String getPublicKeyAlgorithm(X509Certificate cert) {
        PublicKey publicKey = cert.getPublicKey();
        int keyLength = -1;
        if (publicKey instanceof RSAPublicKey) {
            keyLength = ((RSAPublicKey)publicKey).getModulus().bitLength();
        } else if (publicKey instanceof DSAPublicKey) {
            keyLength = ((DSAPublicKey)publicKey).getParams().getP().bitLength();
        } else if (publicKey instanceof DHPublicKey) {
            keyLength = ((DHPublicKey)publicKey).getParams().getP().bitLength();
        }
        return publicKey.getAlgorithm() + " (" + Integer.toString(keyLength) + ")";
    }

    public static String toHexString(byte[] b) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            buf.append(X509CertWrapper.toHexString(b[i]));
            buf.append(" ");
        }
        return buf.toString();
    }

    public static String toHexString(byte b) {
        int value = (b & 0x7F) + (b < 0 ? 128 : 0);
        Object ret = value < 16 ? "0" : "";
        ret = (String)ret + Integer.toHexString(value).toUpperCase();
        return ret;
    }

    public static boolean isKeyUsageSignature(X509Certificate cert) {
        boolean retVal = false;
        if (cert != null) {
            boolean[] keyUsage = cert.getKeyUsage();
            if (keyUsage != null && keyUsage.length > KEY_USAGE_INDEX_SIGNATURE) {
                retVal = keyUsage[KEY_USAGE_INDEX_SIGNATURE];
            }
        } else {
            _logger.warn("cert is null !");
        }
        return retVal;
    }
}

