/*
 * Decompiled with CFR 0.152.
 */
package de.itu.xml;

import de.itu.util.LogUtils;
import de.itu.xml.SchemaValidator;
import de.itu.xml.XmlException;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;

public class ITUTransformer {
    private static final Logger _logger = LogManager.getLogger(Logger.class);
    private static final String XSLT_RESOURCE_ROOT = "/de/itu/res/xslt/";
    private static ITUTransformer _theInstance = null;
    private File _xsltRootDir = new File(System.getProperty("user.dir"));
    private Map<String, Transformer> _transformerMap = new HashMap<String, Transformer>();
    private TransformerFactory _transformerFactory = TransformerFactory.newInstance();

    private ITUTransformer() {
    }

    public static ITUTransformer getInstance() {
        if (_theInstance == null) {
            _theInstance = new ITUTransformer();
        }
        return _theInstance;
    }

    public void setXsltRootDir(String rootDir) throws XmlException {
        File file = new File(rootDir);
        if (!file.exists() || !file.isDirectory()) {
            _logger.error("error setting xslt root dir " + rootDir);
            throw new XmlException("error setting xslt root dir " + rootDir);
        }
        this._xsltRootDir = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document transform(Document inputDoc, String xsltName, Map<String, Object> params) throws XmlException {
        Document doc = null;
        Transformer tf = this._transformerMap.get(xsltName);
        if (tf == null) {
            Source source = this.getTransformerSource(xsltName);
            if (source != null) {
                try {
                    tf = this._transformerFactory.newTransformer(source);
                    this._transformerMap.put(xsltName, tf);
                }
                catch (TransformerConfigurationException ex) {
                    _logger.error("Error creating transformer", (Throwable)ex);
                    throw new XmlException(ex, "Error creating transformer");
                }
            } else {
                _logger.error("error getting transformer source");
                throw new XmlException("Error getting transformer source");
            }
        }
        if (tf != null) {
            Transformer transformer = tf;
            synchronized (transformer) {
                tf.clearParameters();
                tf.reset();
                for (String key : params.keySet()) {
                    tf.setParameter(key, params.get(key));
                }
                try {
                    DOMResult dr = new DOMResult();
                    tf.transform(new DOMSource(inputDoc), dr);
                    doc = (Document)dr.getNode();
                }
                catch (TransformerException ex) {
                    _logger.error("Error transforming doc with xslt " + xsltName);
                    throw new XmlException(ex, "Error transforming doc with xslt " + xsltName);
                }
            }
        }
        _logger.error("schema is null!");
        throw new XmlException("schema is null!");
        return doc;
    }

    private Source getTransformerSource(String xsltName) {
        File xsltFile;
        StreamSource source = null;
        Object xsltFileName = xsltName;
        if (!((String)xsltFileName).endsWith(".xslt")) {
            xsltFileName = (String)xsltFileName + ".xslt";
        }
        if ((xsltFile = new File(this._xsltRootDir, (String)xsltFileName)).exists()) {
            source = new StreamSource(xsltFile);
            _logger.info("xslt loaded from filesystem: " + xsltFile.getAbsolutePath());
        } else {
            InputStream resourceStream = ITUTransformer.class.getResourceAsStream(XSLT_RESOURCE_ROOT + (String)xsltFileName);
            source = new StreamSource(resourceStream);
            _logger.info("xslt loaded from jar: " + (String)xsltFileName);
        }
        return source;
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        return docBuilder;
    }

    public static void main(String[] args) {
        String xmlFilePath = "e:/Projekte/Asys/BMU/v1.03/sinnvolle BMU-Dokumente/Entsorgungsnachweise/en_erz_ent_signiert_beh.xml";
        String xsltRootPath = "e:/ASYS5 e1/acs/extern/xslt/";
        String schemaRootPath = "e:/ASYS5 e1/acs/extern/xsd/";
        String xsltName = "import/BMU-XML/ABFKPF-ENSN.xslt";
        String schemaName = "ABFKPF-ENSN.xsd";
        LogUtils.initLogging(Level.INFO);
        File xmlFile = new File(xmlFilePath);
        try {
            ITUTransformer tf = ITUTransformer.getInstance();
            tf.setXsltRootDir(xsltRootPath);
            DocumentBuilder db = tf.getDocumentBuilder();
            Document doc = db.parse(xmlFile);
            HashMap<String, Object> params = new HashMap<String, Object>();
            Document resultDoc = tf.transform(doc, xsltName, params);
            SchemaValidator validator = SchemaValidator.getInstance(true);
            validator.setSchemaRootDir(schemaRootPath);
            boolean valid = validator.validate(resultDoc, new File(schemaRootPath, schemaName), null);
            _logger.info("transformation result is " + (valid ? "valid" : "not valid!"));
            File resultFile = File.createTempFile("_transformed", ".xml");
            Transformer tfOut = TransformerFactory.newInstance().newTransformer();
            DOMSource docSource = new DOMSource(resultDoc);
            StreamResult outStream = new StreamResult(resultFile);
            tfOut.transform(docSource, outStream);
        }
        catch (Exception ex) {
            _logger.error("error transforming " + xmlFilePath + " with xslt " + xsltName, (Throwable)ex);
        }
    }
}

