/*
 * Decompiled with CFR 0.152.
 */
package de.itu.xml;

import de.itu.xml.XalanAdapter;
import de.itu.xml.XmlException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Map;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XmlUtil {
    private static final Logger _logger = LogManager.getLogger(XmlUtil.class);
    private static DocumentBuilderFactory _dbFactory = null;
    private static TransformerFactory _tfFactory = null;
    private static Random random = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocumentBuilder getDocumentBuilder() throws XmlException {
        DocumentBuilder db = null;
        if (_dbFactory == null) {
            _dbFactory = DocumentBuilderFactory.newInstance();
            _dbFactory.setNamespaceAware(true);
        }
        DocumentBuilderFactory documentBuilderFactory = _dbFactory;
        synchronized (documentBuilderFactory) {
            try {
                db = _dbFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                _logger.error("Fehler beim Erzeugen des DocumentBuilder", (Throwable)e);
                throw new XmlException(e, "Fehler beim Erzeugen des DocumentBuilder");
            }
        }
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Transformer getTransformer() throws XmlException {
        Transformer tf = null;
        if (_tfFactory == null) {
            _tfFactory = TransformerFactory.newInstance();
        }
        TransformerFactory transformerFactory = _tfFactory;
        synchronized (transformerFactory) {
            try {
                tf = _tfFactory.newTransformer();
            }
            catch (TransformerConfigurationException e) {
                _logger.error("Fehler beim Erzeugen des Transformers", (Throwable)e);
                throw new XmlException(e, "Fehler beim Erzeugen des Transformers");
            }
        }
        return tf;
    }

    public static Document parse(File file) throws XmlException {
        Document doc = null;
        DocumentBuilder db = XmlUtil.getDocumentBuilder();
        try {
            doc = db.parse(file);
        }
        catch (Exception e) {
            _logger.error("Fehler beim Parsen der Datei: " + file.getAbsolutePath(), (Throwable)e);
            throw new XmlException(e, "Fehler beim Parsen der Datei: " + file.getAbsolutePath());
        }
        return doc;
    }

    public static Document parse(InputSource is) throws XmlException {
        Document doc = null;
        DocumentBuilder db = XmlUtil.getDocumentBuilder();
        try {
            doc = db.parse(is);
        }
        catch (Exception e) {
            _logger.error("Fehler beim Parsen der InputSource", (Throwable)e);
            throw new XmlException(e, "Fehler beim Parsen der InputSource");
        }
        return doc;
    }

    public static void save(Document doc, File file) throws XmlException {
        XmlUtil.save(doc, file, "UTF-8", false);
    }

    public static void save(Document doc, File file, boolean indent) throws XmlException {
        XmlUtil.save(doc, file, "UTF-8", indent);
    }

    public static void save(Document doc, File file, String encoding) throws XmlException {
        XmlUtil.save(doc, file, encoding, false);
    }

    public static void save(Document doc, File file, String encoding, boolean indent) throws XmlException {
        Transformer tf = XmlUtil.getTransformer();
        FileOutputStream fos = null;
        try {
            tf.setOutputProperty("indent", indent ? "yes" : "no");
            tf.setOutputProperty("encoding", encoding);
            fos = new FileOutputStream(file);
            tf.transform(new DOMSource(doc), new StreamResult(fos));
        }
        catch (Exception e) {
            _logger.error("Fehler beim Speichern der Datei: " + file.getAbsolutePath(), (Throwable)e);
            throw new XmlException(e, "Fehler beim Speichern der Datei: " + file.getAbsolutePath());
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    _logger.error("Fehler beim Schreiben der Datei: " + file.getAbsolutePath(), (Throwable)e);
                }
            }
        }
    }

    public static String generateID() {
        String allowedChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789";
        StringBuffer buf = new StringBuffer();
        int charCount = allowedChars.length();
        for (int count = 0; count < 15; ++count) {
            int index = 0;
            index = count == 0 ? random.nextInt(53) : random.nextInt(charCount);
            buf.append(allowedChars.charAt(index));
        }
        return buf.toString();
    }

    public static Document transform(Document inputDoc, InputStream xslStream, String xslName, Map<String, Object> params) throws XmlException {
        Document doc = null;
        XalanAdapter.MyTransformer t = XalanAdapter.getInstance().prepareTransformation(xslStream, xslName);
        if (params != null) {
            for (String key : params.keySet()) {
                Object objVal = params.get(key);
                _logger.debug(key + "=" + String.valueOf(objVal));
                t.setParameter(key, objVal);
            }
        }
        doc = t.transform(inputDoc);
        return doc;
    }

    public static Document transform(Document inputDoc, File xslFile, Map<String, Object> params) throws XmlException {
        Document doc = null;
        XalanAdapter.MyTransformer t = XalanAdapter.getInstance().prepareTransformation(xslFile.getAbsolutePath());
        if (params != null) {
            for (String key : params.keySet()) {
                Object objVal = params.get(key);
                _logger.debug(key + "=" + String.valueOf(objVal));
                t.setParameter(key, objVal);
            }
        }
        doc = t.transform(inputDoc);
        return doc;
    }

    public static String getDocAsString(Document doc) throws XmlException {
        String retVal = null;
        Transformer tf = XmlUtil.getTransformer();
        StreamResult sr = new StreamResult(new StringWriter());
        try {
            tf.transform(new DOMSource(doc), sr);
            retVal = sr.getWriter().toString();
        }
        catch (TransformerException e) {
            _logger.error("Transformation fehlgeschlagen", (Throwable)e);
            throw new XmlException(e, "Transformation fehlgeschlagen");
        }
        return retVal;
    }
}

