/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.jaxb;

import de.focus_shift.jollyday.core.util.ClassLoadingUtil;
import de.focus_shift.jollyday.jaxb.mapping.Configuration;
import de.focus_shift.jollyday.jaxb.mapping.ObjectFactory;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxbXMLMapper {
    private static final String PACKAGE = "de.focus_shift.jollyday.jaxb.mapping";
    private static final Logger LOG = LoggerFactory.getLogger(JaxbXMLMapper.class);
    private static final JAXBContext jaxbContext = new JAXBContextCreator().create();

    public Configuration unmarshallConfiguration(InputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("Stream is NULL. Cannot read XML.");
        }
        try {
            Unmarshaller um = jaxbContext.createUnmarshaller();
            JAXBElement jaxbElement = (JAXBElement)um.unmarshal(stream);
            return (Configuration)jaxbElement.getValue();
        }
        catch (JAXBException exception) {
            throw new IllegalStateException("Cannot parse holidays XML file.", exception);
        }
    }

    private static class JAXBContextCreator {
        private JAXBContextCreator() {
        }

        private JAXBContext create() {
            return JAXBContextCreator.createJAXBContext();
        }

        private static JAXBContext createJAXBContext() {
            JAXBContext ctx = null;
            try {
                ctx = JAXBContext.newInstance((String)JaxbXMLMapper.PACKAGE, (ClassLoader)ClassLoadingUtil.getClassloader());
            }
            catch (JAXBException e) {
                LOG.warn("Could not create JAXB context using the current classloader from ClassLoadingUtil. Falling back to ObjectFactory class classloader.");
            }
            if (ctx == null) {
                try {
                    ctx = JAXBContext.newInstance((String)JaxbXMLMapper.PACKAGE, (ClassLoader)ObjectFactory.class.getClassLoader());
                }
                catch (JAXBException exception) {
                    throw new IllegalStateException("Could not create JAXB context using ObjectFactory classloader.", exception);
                }
            }
            return ctx;
        }
    }
}

