/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.http;

import com.jamonapi.http.HttpMon;
import com.jamonapi.http.HttpMonFactory;
import com.jamonapi.http.HttpMonManage;
import com.jamonapi.http.JettyHttpMonFactory;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.HandlerWrapper;

public class JAMonJettyHandler
extends HandlerWrapper
implements HttpMonManage {
    private static final String PREFIX = "com.jamonapi.http.JAMonJettyHandler";
    private static final String DEFAULT_SUMMARY = "default, response.getContentCount().bytes, response.getStatus().value.httpStatus, response.getStatus().summary.httpStatus";
    private HttpMonFactory httpMonFactory = new JettyHttpMonFactory("com.jamonapi.http.JAMonJettyHandler");
    private String jamonSummaryLabels = "default";

    public JAMonJettyHandler() {
        this.setSummaryLabels(this.jamonSummaryLabels);
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Response baseResponse = response instanceof Response ? (Response)response : null;
        HttpMon httpMon = null;
        try {
            try {
                httpMon = this.httpMonFactory.start(baseRequest, baseResponse);
                super.handle(target, baseRequest, request, response);
            }
            catch (Throwable e) {
                httpMon.throwException(e);
                httpMon.stop();
            }
        }
        finally {
            httpMon.stop();
        }
    }

    @Override
    public void setSummaryLabels(String jamonSummaryLabels) {
        this.httpMonFactory.setSummaryLabels(jamonSummaryLabels, DEFAULT_SUMMARY);
    }

    @Override
    public String getSummaryLabels() {
        return this.httpMonFactory.getSummaryLabels();
    }

    @Override
    public void addSummaryLabel(String jamonSummaryLabel) {
        this.httpMonFactory.addSummaryLabel(jamonSummaryLabel);
    }

    @Override
    public boolean getIgnoreHttpParams() {
        return this.httpMonFactory.getIgnoreHttpParams();
    }

    @Override
    public void setIgnoreHttpParams(boolean ignoreHttpParams) {
        this.httpMonFactory.setIgnoreHttpParams(ignoreHttpParams);
    }

    @Override
    public void setEnabled(boolean enable) {
        this.httpMonFactory.setEnabled(enable);
    }

    @Override
    public int getSize() {
        return this.httpMonFactory.getSize();
    }

    @Override
    public boolean getEnabled() {
        return this.httpMonFactory.getEnabled();
    }

    @Override
    public void setSize(int size) {
        this.httpMonFactory.setSize(size);
    }
}

