<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
	xmlns:msg="uri:BMU_Waste_Interface/Message" 
	xmlns:zks="uri:BMU_Waste_Interface/ZKS"
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
	xmlns:b64="xalan://de.itu.util.Base64" 
	xmlns:crc32="xalan://de.itu.util.CRC32Helper" 
	xmlns:x509="xalan://de.itu.util.X509CertHelper"
	extension-element-prefixes="b64 crc32 x509" 
	exclude-result-prefixes="xsl lib msg ds b64 crc32 x509">
	<xsl:import href="ZKS-Library.xsl"/>
	<xsl:output method="html"/>
	<xsl:param name="positionsnummer"/>
	<xsl:param name="register" select="0"/>
	<xsl:param name="nameXML"/>
	<xsl:template match="/">
		<xsl:choose>
			<xsl:when test="msg:Nachricht">
				<xsl:for-each select="msg:Nachricht/msg:Nutzdaten">
					<xsl:apply-templates/>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="zks:Adressantwort">
		<html>
			<head>
				<title>Adressantwort</title>
				<!-- CSS - Datei   -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf"/>
				<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
					<tr>
						<th>
							<xsl:call-template name="Zeile0"/>
							<xsl:call-template name="Zeile1"/>
						</th>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="Zeile0">
		<table width="100%" border="0">
			<tr>
				<td>
					<font id="Nummer">
				Adressantwort
				</font>
				</td>
			</tr>
			<tr height="3%">
				<td/>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile1">
		<table width="100%" border="0">
			<tr height="10">
				<td>
				</td>
			</tr>
			<tr width="100%">
				<td id="Titel"> Anfrage UUID </td>
			</tr>
			<tr width="100%">
				<td id="Aktuell">
					<font id="Aktuell">
						<xsl:value-of select="zks:AnfrageUUID"/>
					</font>
				</td>
			</tr>
			<tr height="10">
				<td>
				</td>
			</tr>
			<xsl:choose>
				<xsl:when test="zks:Trefferanzahl">
					<tr width="100%">
						<td id="Titel"> Trefferanzahl </td>
					</tr>
					<tr width="100%">
						<td>
							<font id="Aktuell">
								<xsl:value-of select="zks:Trefferanzahl"/>
							</font>
						</td>
					</tr>
				</xsl:when>
				<xsl:otherwise>
					<tr align="left">
						<td id="Titel_gross"> Adress-Liste </td>
					</tr>
					<table border="2">
					<tr width="100%">
						<td width="20%" id="Text_normal">Behördliche Nummer</td>
						<td width="20%" id="Text_normal">Provider Nummer</td>
						<td width="10%" id="Text_normal">Default-Adresse</td>
						<td width="25%" id="Text_normal">Name und Adresse Betrieb</td>
						<td width="25%" id="Text_normal">Name und Adresse Firma</td>
					</tr>
					<xsl:for-each select="zks:Liste">
						<tr align="left">
		
							<td width="20%" id="Aktuell">
								<xsl:value-of select="concat(zks:BehoerdlicheNummer/lib:BehoerdlicheNr, zks:BehoerdlicheNummer/lib:Pruefziffer, ' (', zks:BehoerdlicheNummer/@lib:ATBRolle, ')')"/>
							</td>
							<td width="20%" id="Aktuell">
								<xsl:value-of select="concat(zks:ProviderNummer/lib:BehoerdlicheNr, zks:ProviderNummer/lib:Pruefziffer, ' (', zks:ProviderNummer/@lib:ATBRolle, ')')"/>
							</td>
							<td width="10%" id="Aktuell">
								<xsl:if test="zks:IndicatorIstDefaultadresse = 'true'">
									Ja
								</xsl:if>
								<xsl:if test="zks:IndicatorIstDefaultadresse = 'false'">
									Nein
								</xsl:if>
							</td>
							<td width="25%">
								<table border="0">
									<xsl:if test="zks:BetriebNameUndAdresse/lib:Name/lib:Name1">
										<tr width="100%">
											<td width="20%" id="Titel">Name 1 : </td>
											<td width="80%" id="Aktuell">
												<xsl:value-of select="zks:BetriebNameUndAdresse/lib:Name/lib:Name1"/>
											</td>
										</tr>
									</xsl:if>
									<xsl:if test="zks:BetriebNameUndAdresse/lib:Name/lib:Name2">
										<tr width="100%">
											<td width="20%" id="Titel">Name 2 : </td>
											<td width="80%" id="Aktuell">
												<xsl:value-of select="zks:BetriebNameUndAdresse/lib:Name/lib:Name2"/>
											</td>
										</tr>
									</xsl:if>
									<xsl:if test="zks:BetriebNameUndAdresse/lib:Name/lib:Name3">
										<tr width="100%">
											<td width="20%" id="Titel">Name 3 : </td>
											<td width="80%" id="Aktuell">
												<xsl:value-of select="zks:BetriebNameUndAdresse/lib:Name/lib:Name3"/>
											</td>
										</tr>
									</xsl:if>
									<xsl:if test="zks:BetriebNameUndAdresse/lib:Name/lib:Name4">
										<tr width="100%">
											<td width="20%" id="Titel">Name 4 : </td>
											<td width="80%" id="Aktuell">
												<xsl:value-of select="zks:BetriebNameUndAdresse/lib:Name/lib:Name4"/>
											</td>
										</tr>
									</xsl:if>
									<tr width="100%"/>
									<xsl:choose>
										<xsl:when test="zks:BetriebNameUndAdresse/lib:Adresse">
											<xsl:if test="zks:BetriebNameUndAdresse/lib:Adresse/lib:Strasse_1">
												<tr width="100%">
													<td width="20%" id="Titel">Strasse 1 : </td>
													<td width="80%" id="Aktuell">
														<xsl:value-of select="zks:BetriebNameUndAdresse/lib:Adresse/lib:Strasse_1"/>
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="zks:BetriebNameUndAdresse/lib:Adresse/lib:Strasse_2">
												<tr width="100%">
													<td width="20%" id="Titel">Strasse 2 : </td>
													<td width="80%" id="Aktuell">
														<xsl:value-of select="zks:BetriebNameUndAdresse/lib:Adresse/lib:Strasse_2"/>
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="zks:BetriebNameUndAdresse/lib:Adresse/lib:Hausnummer">
												<tr width="100%">
													<td width="20%" id="Titel">Hausnummer : </td>
													<td width="80%" id="Aktuell">
														<xsl:value-of select="zks:BetriebNameUndAdresse/lib:Adresse/lib:Hausnummer"/>
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="zks:BetriebNameUndAdresse/lib:Adresse/lib:Postleitzahl">
												<tr width="100%">
													<td width="20%" id="Titel">Postleitzahl : </td>
													<td width="80%" id="Aktuell">
														<xsl:value-of select="zks:BetriebNameUndAdresse/lib:Adresse/lib:Postleitzahl"/>
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="zks:BetriebNameUndAdresse/lib:Adresse/lib:Ort_1">
												<tr width="100%">
													<td width="20%" id="Titel">Ort 1 : </td>
													<td width="80%" id="Aktuell">
														<xsl:value-of select="zks:BetriebNameUndAdresse/lib:Adresse/lib:Ort_1"/>
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="zks:BetriebNameUndAdresse/lib:Adresse/lib:Ort_2">
												<tr width="100%">
													<td width="20%" id="Titel">Ort 2 : </td>
													<td width="80%" id="Aktuell">
														<xsl:value-of select="zks:BetriebNameUndAdresse/lib:Adresse/lib:Ort_2"/>
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="zks:BetriebNameUndAdresse/lib:Adresse/lib:Staat">
												<tr width="100%">
													<td width="20%" id="Titel">Staat : </td>
													<td width="80%" id="Aktuell">
														<xsl:value-of select="zks:BetriebNameUndAdresse/lib:Adresse/lib:Staat"/>
													</td>
												</tr>
											</xsl:if>
										</xsl:when>
										<xsl:when test="zks:FirmaNameUndAdresse/lib:Postfach">
											<xsl:if test="zks:BetriebNameUndAdresse/lib:Postfach/lib:Postfach">
												<tr width="100%">
													<td width="20%" id="Titel">Postfach : </td>
													<td width="80%" id="Aktuell">
														<xsl:value-of select="zks:BetriebNameUndAdresse/lib:Postfach/lib:Postfach"/>
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="zks:BetriebNameUndAdresse/lib:Postfach/lib:Postleitzahl">
												<tr width="100%">
													<td width="20%" id="Titel">Postleitzahl : </td>
													<td width="80%" id="Aktuell">
														<xsl:value-of select="zks:BetriebNameUndAdresse/lib:Postfach/lib:Postleitzahl"/>
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="zks:BetriebNameUndAdresse/lib:Postfach/lib:Ort_1">
												<tr width="100%">
													<td width="20%" id="Titel">Ort 1 : </td>
													<td width="80%" id="Aktuell">
														<xsl:value-of select="zks:BetriebNameUndAdresse/lib:Postfach/lib:Ort_1"/>
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="zks:BetriebNameUndAdresse/lib:Postfach/lib:Ort_2">
												<tr width="100%">
													<td width="20%" id="Titel">Ort 2 : </td>
													<td width="80%" id="Aktuell">
														<xsl:value-of select="zks:BetriebNameUndAdresse/lib:Postfach/lib:Ort_2"/>
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="zks:BetriebNameUndAdresse/lib:Postfach/lib:Staat">
												<tr width="100%">
													<td width="20%" id="Titel">Staat : </td>
													<td width="80%" id="Aktuell">
														<xsl:value-of select="zks:BetriebNameUndAdresse/lib:Postfach/lib:Staat"/>
													</td>
												</tr>
											</xsl:if>
										</xsl:when>
									</xsl:choose>
								</table>				
							</td>			
							<td width="25%">
								<table border="0">
									<xsl:if test="zks:FirmaNameUndAdresse/lib:Name/lib:Name1">
										<tr width="100%">
											<td width="20%" id="Titel">Name 1 : </td>
											<td width="80%" id="Aktuell">
												<xsl:value-of select="zks:FirmaNameUndAdresse/lib:Name/lib:Name1"/>
											</td>
										</tr>
									</xsl:if>
									<xsl:if test="zks:FirmaNameUndAdresse/lib:Name/lib:Name2">
										<tr width="100%">
											<td width="20%" id="Titel">Name 2 : </td>
											<td width="80%" id="Aktuell">
												<xsl:value-of select="zks:FirmaNameUndAdresse/lib:Name/lib:Name2"/>
											</td>
										</tr>
									</xsl:if>
									<xsl:if test="zks:FirmaNameUndAdresse/lib:Name/lib:Name3">
										<tr width="100%">
											<td width="20%" id="Titel">Name 3 : </td>
											<td width="80%" id="Aktuell">
												<xsl:value-of select="zks:FirmaNameUndAdresse/lib:Name/lib:Name3"/>
											</td>
										</tr>
									</xsl:if>
									<xsl:if test="zks:FirmaNameUndAdresse/lib:Name/lib:Name4">
										<tr width="100%">
											<td width="20%" id="Titel">Name 4 : </td>
											<td width="80%" id="Aktuell">
												<xsl:value-of select="zks:FirmaNameUndAdresse/lib:Name/lib:Name4"/>
											</td>
										</tr>
									</xsl:if>
									<tr width="100%"/>
									<xsl:choose>
										<xsl:when test="zks:FirmaNameUndAdresse/lib:Adresse">
											<xsl:if test="zks:FirmaNameUndAdresse/lib:Adresse/lib:Strasse_1">
												<tr width="100%">
													<td width="20%" id="Titel">Strasse 1 : </td>
													<td width="80%" id="Aktuell">
														<xsl:value-of select="zks:FirmaNameUndAdresse/lib:Adresse/lib:Strasse_1"/>
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="zks:FirmaNameUndAdresse/lib:Adresse/lib:Strasse_2">
												<tr width="100%">
													<td width="20%" id="Titel">Strasse 2 : </td>
													<td width="80%" id="Aktuell">
														<xsl:value-of select="zks:FirmaNameUndAdresse/lib:Adresse/lib:Strasse_2"/>
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="zks:FirmaNameUndAdresse/lib:Adresse/lib:Hausnummer">
												<tr width="100%">
													<td width="20%" id="Titel">Hausnummer : </td>
													<td width="80%" id="Aktuell">
														<xsl:value-of select="zks:FirmaNameUndAdresse/lib:Adresse/lib:Hausnummer"/>
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="zks:FirmaNameUndAdresse/lib:Adresse/lib:Postleitzahl">
												<tr width="100%">
													<td width="20%" id="Titel">Postleitzahl : </td>
													<td width="80%" id="Aktuell">
														<xsl:value-of select="zks:FirmaNameUndAdresse/lib:Adresse/lib:Postleitzahl"/>
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="zks:FirmaNameUndAdresse/lib:Adresse/lib:Ort_1">
												<tr width="100%">
													<td width="20%" id="Titel">Ort 1 : </td>
													<td width="80%" id="Aktuell">
														<xsl:value-of select="zks:FirmaNameUndAdresse/lib:Adresse/lib:Ort_1"/>
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="zks:FirmaNameUndAdresse/lib:Adresse/lib:Ort_2">
												<tr width="100%">
													<td width="20%" id="Titel">Ort 2 : </td>
													<td width="80%" id="Aktuell">
														<xsl:value-of select="zks:FirmaNameUndAdresse/lib:Adresse/lib:Ort_2"/>
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="zks:FirmaNameUndAdresse/lib:Adresse/lib:Staat">
												<tr width="100%">
													<td width="20%" id="Titel">Staat : </td>
													<td width="80%" id="Aktuell">
														<xsl:value-of select="zks:FirmaNameUndAdresse/lib:Adresse/lib:Staat"/>
													</td>
												</tr>
											</xsl:if>
										</xsl:when>
										<xsl:when test="zks:FirmaNameUndAdresse/lib:Postfach">
											<xsl:if test="zks:FirmaNameUndAdresse/lib:Postfach/lib:Postfach">
												<tr width="100%">
													<td width="20%" id="Titel">Postfach : </td>
													<td width="80%" id="Aktuell">
														<xsl:value-of select="zks:FirmaNameUndAdresse/lib:Postfach/lib:Postfach"/>
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="zks:FirmaNameUndAdresse/lib:Postfach/lib:Postleitzahl">
												<tr width="100%">
													<td width="20%" id="Titel">Postleitzahl : </td>
													<td width="80%" id="Aktuell">
														<xsl:value-of select="zks:FirmaNameUndAdresse/lib:Postfach/lib:Postleitzahl"/>
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="zks:FirmaNameUndAdresse/lib:Postfach/lib:Ort_1">
												<tr width="100%">
													<td width="20%" id="Titel">Ort 1 : </td>
													<td width="80%" id="Aktuell">
														<xsl:value-of select="zks:FirmaNameUndAdresse/lib:Postfach/lib:Ort_1"/>
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="zks:FirmaNameUndAdresse/lib:Postfach/lib:Ort_2">
												<tr width="100%">
													<td width="20%" id="Titel">Ort 2 : </td>
													<td width="80%" id="Aktuell">
														<xsl:value-of select="zks:FirmaNameUndAdresse/lib:Postfach/lib:Ort_2"/>
													</td>
												</tr>
											</xsl:if>
											<xsl:if test="zks:FirmaNameUndAdresse/lib:Postfach/lib:Staat">
												<tr width="100%">
													<td width="20%" id="Titel">Staat : </td>
													<td width="80%" id="Aktuell">
														<xsl:value-of select="zks:FirmaNameUndAdresse/lib:Postfach/lib:Staat"/>
													</td>
												</tr>
											</xsl:if>
										</xsl:when>
									</xsl:choose>
								</table>				
							</td>
						</tr>
					</xsl:for-each>
					</table>
				</xsl:otherwise>
			</xsl:choose>
			<table width="100%">
				<tr width="100%">
					<td width="50%" id="Titel">Unterschrift (Signatur)</td>
					<td width="50%" id="Titel">2. Unterschrift (2. Signatur)</td>
				</tr>
				<tr width="100%">
					<td width="50%">
						<xsl:call-template name="Sig1NameNoLayer"/>
					</td>
					<td width="50%">
						<xsl:call-template name="Sig2NameNoLayer"/>
					</td>
				</tr>
			</table>
		</table>
	</xsl:template>
</xsl:stylesheet>
