<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
	xmlns:en="uri:BMU_Waste_Interface/EN" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
	xmlns:b64="xalan://de.itu.base64.Base64" 
	exclude-result-prefixes="xsl lib en ds b64 ">
	<xsl:import href="ZKS-Library.xsl"/>
	<xsl:output method="html"/>
	<!-- bei neuladen übergebene Parameter -->
	<xsl:param name="positionsnummer" select="1"/>
	<xsl:param name="layerName" select="'ENSNErzLayer'"/>
	<xsl:param name="layerID" select="'ERZ-01-e6f6d730-0dbe-45b7-857c-0b7474c9ee07'"/>
	<xsl:template match="/">
		<html>
			<head>
				<title>Entsorgungsnachweis/Sammelentsorgungsnachweis</title>
				<!-- CSS - Datei -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf"/>
				<xsl:call-template name="AnhangGebEN"/>
			</body>
		</html>
	</xsl:template>

	<xsl:template name="AnhangGebEN">
		<xsl:for-each select="//*[(starts-with(local-name(), 'ENSN')) and (contains(local-name(), 'Layer'))]">
			<xsl:if test="position()=$positionsnummer">
				<xsl:if test="count(en:Gebuehr/en:Dateianhang)>0">
					<table width="100%" cellspacing="15" cellpadding="15">
						<tr>
							<td>
								<font id="Nummer2">Im signierten Gebührenbereich angehängt wurden:</font>
								<br/>
								<br/>
								<ul>
									<xsl:for-each select="en:Gebuehr/en:Dateianhang">
										<font id="Aktuell">
											<li>
												<xsl:value-of select="@lib:dateiname"/>
											</li>
										</font>
									</xsl:for-each>
								</ul>
							</td>
						</tr>
					</table>
				</xsl:if>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
