<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
	xmlns:en="uri:BMU_Waste_Interface/EN" 
	xmlns:da="uri:BMU_Waste_Interface/DA" 
	xmlns:dalib="uri:BMU_Waste_Interface/DATypen" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
	xmlns:xades="http://uri.etsi.org/01903/v1.3.2#"
	xmlns:dyn="http://exslt.org/dynamic"
	xmlns:b64="xalan://de.itu.util.Base64" 
	xmlns:crc32="xalan://de.itu.util.CRC32Helper" 
	xmlns:x509="xalan://de.itu.util.X509CertHelper" 
	extension-element-prefixes="dyn b64 crc32 x509" 
	exclude-result-prefixes="xsl dyn lib ds en b64 crc32 x509">
	<xsl:import href="ZKS-Library.xsl"/>
	<xsl:output method="html"/>
	<!-- bei neuladen übergebene Parameter -->
	<xsl:param name="positionsnummer" select="1"/>
	<xsl:param name="layerName" select="'ENSNErzLayer'"/>
	<xsl:param name="layerID" select="'ERZ-01-e6f6d730-0dbe-45b7-857c-0b7474c9ee07'"/>
	<xsl:template match="/">
		<html>
			<head>
				<title>Entsorgungsnachweis/Sammelentsorgungsnachweis</title>
				<!-- CSS - Datei -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf"/>
				<xsl:call-template name="DADa"/>
				<xsl:call-template name="showSigLayer"/>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="DADa">
		<xsl:for-each select="//*[(starts-with(local-name(), 'ENSN')) and (contains(local-name(), 'Layer'))]">
			<xsl:if test="position()=$positionsnummer">
				<!-- EB ja / nein -->
				<xsl:choose>
					<xsl:when test="string-length(en:VE/en:DADokument)=0">
						<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
							<tr>
								<td>
									<font id="Nummer">
							  			In dieser Sicht ist keine Deklarationsanalyse vorhanden.
						  			</font>
									<br/>
									<font id="Nummer2">
							  			Eine Deklarationsanalyse befindet sich in der Sicht:
							  		</font>
									<font id="FormPosition">
										<!--xsl:call-template name="DA_Position">
					            			</xsl:call-template-->
										<xsl:call-template name="CHILD_POSITION">
											<xsl:with-param name="DocTyp" select="'ENSN'"/>
											<xsl:with-param name="ChildTyp" select="'en:VE/en:DADokument'"/>
				            			</xsl:call-template>
									</font>
								</td>
							</tr>
						</table>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="DA">
	            			</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="DA">
		<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
			<table id="tabelle" width="100%">
				<br/>
				<tr>
					<td>
						<font id="Ueberschrift2">
				  			Deklarationsanalysen befinden sich in den Sichten:
				  		</font>
						<font id="Aktuell_nu">
							<!--xsl:call-template name="DA_Position">
								</xsl:call-template-->
							<xsl:call-template name="CHILD_POSITION">
								<xsl:with-param name="DocTyp" select="'ENSN'"/>
								<xsl:with-param name="ChildTyp" select="'en:VE/en:DADokument'"/>
							</xsl:call-template>
						</font>
					</td>
				</tr>
					<tr>
						<td>
							<font id="Ueberschrift2">
								Ausgewählte Sicht:
							</font>
							<font id="Aktuell_nu">
								<xsl:value-of select="concat(local-name(),': ',@lib:LayerID)"/>								
							</font>
						</td>
					</tr>
			</table>
			<tr>
				<td/>
			</tr>
			<br/>
			<tr>
				<td>
					<div id="Nummer" align="right">Deklarationsanalyse</div>
					<table id="tabelle" width="100%">
						<xsl:call-template name="ESNKopfNummern"/>
						<tr>
							<td>
								<table width="100%">
									<colgroup>
										<col width="39%"/>
										<col width="22%"/>
										<col width="39%"/>
									</colgroup>
									<tr>
										<td>
											<font id="Nummer2">Vor-Nr. (Angabe in DA) </font>
											<font id="Aktuell">
												<xsl:value-of select="en:VE/en:DADokument/en:VorlaeufigeENNr"/>
											</font>
										</td>
										<td/>
										<td>
											<font id="Nummer2">Nr. (Angabe in DA) </font>
											<font id="Aktuell">
												<xsl:value-of select="en:VE/en:DADokument/en:Nachweisnummer/lib:NachweisNr"/>
											</font>
											&#173;
											<font id="Aktuell">
												<xsl:value-of select="en:VE/en:DADokument/en:Nachweisnummer/lib:Pruefziffer"/>
											</font>
										</td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td>
								<font id="Nummer">
									Deklarationsanalyse zum EN / SN
								</font>
								<font id="Ueberschrift2">
									(<xsl:value-of select="concat(local-name(),': ',@lib:LayerID)"/>)								
								</font>
							</td>
						</tr>
						<tr height="20">
							<th/>
						</tr>
						<tr>
							<td>
								<table>
									<tr>
										<td width="5%"/>
										<td>
											<table id="Tabelle_indikator">
												<tr>
													<td>
														<xsl:call-template name="getBooleanValue">
															<xsl:with-param name="TagName" select="'en:VE/en:DADokument/en:DA/en:IndicatorErsterstellung'"/>
														</xsl:call-template>
													</td>
												</tr>
											</table>
										</td>
										<td id="Nummer" width="20%">Ersterstellung</td>
										<td width="20%"/>
										<td>
											<table id="Tabelle_indikator">
												<tr>
													<td>
														<xsl:call-template name="getBooleanValue">
															<xsl:with-param name="TagName" select="'en:VE/en:DADokument/en:DA/en:IndicatorErsterstellung'"/>
															<xsl:with-param name="invers" select="true()"/>
														</xsl:call-template>
													</td>
												</tr>
											</table>
										</td>
										<td id="Nummer" width="20%">Änderung/Ergänzung</td>
										<td width="30%"/>
									</tr>
								</table>
							</td>
						</tr>
						<tr height="10">
							<th/>
						</tr>
					</table>
				</td>
			</tr>
		</table>

		<xsl:choose>
			<xsl:when test="string-length(en:VE/en:DADokument/en:DA/en:Deklarationsanalyse)>0">
				<!-- hier die strukturierte da-->
				<table>
					<tr height="10">
						<th/>
					</tr>
				</table>
				<xsl:for-each select="en:VE/en:DADokument/en:DA/en:Deklarationsanalyse/*">
					<table>
						<tr>
							<td id="Nummer">Strukturierte Deklarationsanalyse</td>
						</tr>
					</table>
					<xsl:call-template name="DA_Labor"/>
					<xsl:call-template name="DA_Probe1"/>
					<xsl:call-template name="DA_Probe2"/>
					<xsl:call-template name="DA_Probe3"/>
					<xsl:call-template name="DA_Organ"/>
					<xsl:call-template name="DA_Analyse"/>
				</xsl:for-each>
				<xsl:for-each select="en:VE/en:DADokument">
					<xsl:call-template name="DA_Anhang"/>
					<xsl:call-template name="DA_Unterschrift"/>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<table>
					<tr height="10">
						<th/>
					</tr>
				</table>
				<table width="100%" id="tabelle">
					<tr>
						<td id="Ueberschrift2">Weitere Angaben</td>
					</tr>
					<tr>
						<td id="Text_normal">Anzugeben sind die den Abfall bestimmenden Parameter und Konzentrationswerte, Art der Probennahme, Probennahmen-Protokolle und Analyseverfahren, soweit diese für den Nachweis der ordnungsgemäßen Entsorgung erforderlich sind.</td>
					</tr>
				</table>
				<table>
					<tr height="5">
						<th/>
					</tr>
				</table>
				<xsl:for-each select="en:VE/en:DADokument">
					<xsl:call-template name="DA_Anhang"/>
					<xsl:call-template name="DA_Unterschrift"/>
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DA_Labor">
		<xsl:for-each select="da:Labor">
			<table id="tabelle_nicht_unten" width="100%">
				<tr>
					<td id="Ueberschrift2">Labor</td>
				</tr>
				<tr height="5">
					<td id="Ueberschrift2"/>
				</tr>
				<tr>
					<td id="titel">Probenbezeichnung</td>
				</tr>
				<tr>
					<td>
						<!-- Probenbezeichnung -->
						<font id="Aktuell">
							<xsl:value-of select="da:Probenbezeichnung"/>
						</font>
					</td>
				</tr>
			</table>
			<table id="tabelle_nicht_oben" width="100%">
				<tr>
					<td id="titel" width="30%">Probennummer</td>
					<td id="titel" width="30%">Analysendatum</td>
					<td id="titel" width="40%"></td>
				</tr>
				<tr>
					<td width="30%">
						<font id="Aktuell">
							<xsl:value-of select="da:Probennummer"/>
						</font>
					</td>
					<td width="30%">
						<font id="Aktuell">
							<xsl:call-template name="formatDate">
								<xsl:with-param name="date">
									<xsl:value-of select="da:Analysendatum"/>
								</xsl:with-param>
							</xsl:call-template>
						</font>
					</td>
					<td id="titel" width="40%"></td>
				</tr>
			</table>
			<xsl:call-template name="NameUndAdresse">
				<xsl:with-param name="prefix" select="da:NameUndAdresse"/>
				<xsl:with-param name="table_width" select="40"/>
			</xsl:call-template>
			<xsl:call-template name="Ansprechpartner">
				<xsl:with-param name="prefix" select="da:Ansprechpartner"/>
				<xsl:with-param name="table_width" select="40"/>
			</xsl:call-template>
			<table id="tabelle_oben" width="100%">
				<tr height="5">
					<td id="Ueberschrift2"/>
				</tr>
			</table>
		</xsl:for-each>

		<table id="tabelle_oben" width="100%">
			<tr height="5">
				<td id="Ueberschrift2"/>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="DA_Probe1">
		<xsl:for-each select="da:Probenahme/da:Probenahmestelle">
			<table id="tabelle_nicht_unten" width="100%">
				<tr>
					<td id="Ueberschrift2">Probenahme - Probenahmestelle</td>
				</tr>
				<tr height="5">
					<td id="Ueberschrift2"/>
				</tr>
				<tr>
					<td id="titel">Anlass</td>
				</tr>
				<tr>
					<td>
						<font id="Aktuell">
							<xsl:value-of select="da:Anlass"/>
						</font>
					</td>
				</tr>
				<tr>
					<td id="titel">Probenahmeort</td>
				</tr>
				<tr>
					<td>
						<font id="Aktuell">
							<xsl:value-of select="da:Probenahmeort"/>
						</font>
					</td>
				</tr>
				<tr>
					<td id="titel">Entnahmestelle und Lagerungsart</td>
				</tr>
				<tr>
					<td>
						<font id="Aktuell">
							<xsl:value-of select="da:Entnahmestelle"/>
						</font>
					</td>
				</tr>
			</table>
			<table id="tabelle_nicht_oben" width="100%">
				<tr>
					<td id="titel" width="20%">Lagerung seit</td>
					<td id="titel" width="20%">Lagerung Menge</td>
					<td id="titel" width="60%"></td>
				</tr>
				<tr>
					<td width="20%">
						<font id="Aktuell">
							<xsl:call-template name="formatDate">
								<xsl:with-param name="date">
									<xsl:value-of select="da:LagerSeit"/>
								</xsl:with-param>
							</xsl:call-template>
						</font>
					</td>
					<td width="20%">
						<font id="Aktuell">
							<xsl:value-of select="da:LagerMenge"/>
						</font>
						&#173;
						<font id="Aktuell">
							<xsl:value-of select="da:LagerMenge/@da:Einheit"/>
						</font>
					</td>
					<td id="titel" width="60%"></td>
				</tr>
				<tr height="5">
					<td id="Ueberschrift2"/>
				</tr>
			</table>
		</xsl:for-each>
		<table>
			<tr height="5">
				<th/>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="DA_Probe2">
		<xsl:for-each select="da:Probenahme/da:Abfallbeschreibung">
			<table id="tabelle_nicht_unten" width="100%">
				<tr>
					<td id="Ueberschrift2">Probenahme - Abfallbeschreibung</td>
				</tr>
				<tr height="5">
					<td id="Ueberschrift2"/>
				</tr>
				<tr>
					<td id="titel">Abfallbeschreibung, stoffliche Komponenten</td>
				</tr>
				<tr>
					<td>
						<font id="Aktuell">
							<xsl:value-of select="da:StoKomp"/>
						</font>
					</td>
				</tr>
				<tr>
					<td id="titel">Abfallherkunft</td>
				</tr>
				<tr>
					<td>
						<font id="Aktuell">
							<xsl:value-of select="da:Abfallherkunft"/>
						</font>
					</td>
				</tr>
				<tr>
					<td id="titel">Körnung nach DIN 4022</td>
				</tr>
				<tr>
					<td>
						<font id="Aktuell">
							<xsl:value-of select="da:K4022"/>
						</font>
					</td>
				</tr>
			</table>
			<table id="tabelle_nicht_oben_unten" width="100%">
				<tr>
					<td id="titel" width="30%">Größtkorn in mm (mit Anteil > 5 Vol %)</td>
					<td id="titel" width="30%">Homogenität</td>
					<td id="titel" width="40%"></td>
				</tr>
				<tr>
					<td width="30%">
						<font id="Aktuell">
							<xsl:value-of select="da:GrKorn"/>
						</font>
					</td>
					<td width="30%">
						<font id="Aktuell">
							<xsl:value-of select="da:Homogen"/>
						</font>
					</td>
					<td id="titel" width="40%"></td>
				</tr>
			</table>
			<table id="tabelle_nicht_oben_unten" width="100%">
				<tr>
					<td id="titel">Farbe</td>
				</tr>
				<tr>
					<td>
						<font id="Aktuell">
							<xsl:value-of select="da:Farbe"/>
						</font>
					</td>
				</tr>
				<tr>
					<td id="titel">Geruch</td>
				</tr>
				<tr>
					<td>
						<font id="Aktuell">
							<xsl:value-of select="da:Geruch"/>
						</font>
					</td>
				</tr>
			</table>
			<table id="tabelle_nicht_oben_unten" width="100%">
				<tr>
					<td id="titel" width="30%">Konsistenz</td>
					<td id="titel" width="30%">Festigkeit</td>
					<td id="titel" width="30%">Feuchte</td>
					<td id="titel" width="10%"></td>
				</tr>
				<tr>
					<td width="30%">
						<font id="Aktuell">
							<xsl:value-of select="da:Konsistenz"/>
						</font>
					</td>
					<td width="30%">
						<font id="Aktuell">
							<xsl:value-of select="da:Festigkeit"/>
						</font>
					</td>
					<td width="30%">
						<font id="Aktuell">
							<xsl:value-of select="da:Feuchte"/>
						</font>
					</td>
					<td id="titel" width="10%"></td>
				</tr>
			</table>
			<table id="tabelle_nicht_oben_unten" width="100%">
				<tr>
					<td id="Ueberschrift2">Technologische Bestandteile</td>
				</tr>
				<tr>
					<td id="titel" width="20%">Bestandteil</td>
					<td id="titel" width="20%">Anteil in Vol %</td>
					<td id="titel" width="60%"></td>
				</tr>
				
				<xsl:for-each select="da:techBest/da:Auswahl">
					<tr>
						<td width="20%">
							<font id="Aktuell">
								<xsl:value-of select="."/>
							</font>
						</td>
						<td width="20%">
							<font id="Aktuell">
								<xsl:value-of select="./following-sibling::da:Anteil[1]"/>
							</font>
						</td>
						<td id="titel" width="60%"></td>
					</tr>
				</xsl:for-each>
			</table>
			<table id="tabelle_nicht_oben" width="100%">
				<tr>
					<td id="titel">Sonstige technologischen Bestandteile / Anmerkungen (freie Eingabe) </td>
				</tr>
				<tr>
					<td>
						<font id="Aktuell">
							<xsl:value-of select="da:techBest/da:Sonstiges"/>
						</font>
					</td>
				</tr>

				<tr height="5">
					<td id="Ueberschrift2"/>
				</tr>
			</table>
			<table width="100%">
				<tr height="5">
					<td id="Ueberschrift2"/>
				</tr>
			</table>
	
		</xsl:for-each>

	</xsl:template>

	<xsl:template name="DA_Probe3">
		<xsl:for-each select="da:Probenahme/da:Entnahmevorgang">
			<table id="tabelle_nicht_unten" width="100%">
				<tr>
					<td id="Ueberschrift2">Probenahme - Entnahmevorgang</td>
				</tr>
				<tr height="5">
					<td id="Ueberschrift2"/>
				</tr>
				<tr>
					<td id="titel">Probenahmedatum</td>
				</tr>
				<tr>
					<td>
						<font id="Aktuell">
							<xsl:call-template name="formatDate">
								<xsl:with-param name="date">
									<xsl:value-of select="da:Probenahmedatum"/>
								</xsl:with-param>
							</xsl:call-template>
						</font>
					</td>
				</tr>
			</table>
			<table id="tabelle_nicht_oben_unten" width="100%">
				<tr>
					<td>
						<table>
							<tr>
								<td width="2%"/>
								<td>
									<table id="Tabelle_indikator">
										<tr>
											<td>
												<font id="Aktuell">
													<xsl:if test="da:EigenFremd='true'">X</xsl:if>
												</font>
											</td>
										</tr>
									</table>
								</td>
								<td id="titel" width="20%">Eigenbeprobung</td>
								<td width="10%"/>
								<td>
									<table id="Tabelle_indikator">
										<tr>
											<td>
												<font id="Aktuell">
													<xsl:if test="da:EigenFremd='false'">X</xsl:if>
												</font>
											</td>
										</tr>
									</table>
								</td>
								<td id="titel" width="20%">Fremdbeprobung</td>
								<td width="30%"/>
							</tr>
						</table>
					</td>
				</tr>
			</table>
			<table id="tabelle_nicht_oben_unten" width="100%">
				<tr>
					<td id="titel">Entnahmegerät</td>
				</tr>
				<tr>
					<td>
						<font id="Aktuell">
							<xsl:choose>
								<xsl:when test="count(da:Entnahmegeraet/da:Auswahl)>0">
									<xsl:value-of select="da:Entnahmegeraet/da:Auswahl"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="da:Entnahmegeraet/da:Sonstiges"/>
								</xsl:otherwise>
							</xsl:choose>
						</font>
					</td>
				</tr>
			</table>
			<table id="tabelle_nicht_oben_unten" width="100%">
				<tr>
					<td id="titel" width="25%">Nicht beprobte Körnung </td>
					<td id="titel" width="25%">Anteil am Abfall in Vol %</td>
					<td id="titel" width="25%">Einzeilprobenvolumen in l</td>
					<td id="titel" width="25%">Einzelprobenanzahl</td>
				</tr>
				<tr>
					<td width="25%">
						<font id="Aktuell">
							<xsl:value-of select="da:nBepAnt/da:nBepKorn"/>
						</font>
					</td>
					<td width="25%">
						<font id="Aktuell">
							<xsl:value-of select="da:nBepAnt/da:AnteiAbf"/>
						</font>
					</td>
					<td width="25%">
						<font id="Aktuell">
							<xsl:value-of select="da:EzPrvol"/>
						</font>
					</td>
					<td width="25%">
						<font id="Aktuell">
							<xsl:value-of select="da:EzPrAnz"/>
						</font>
					</td>
				</tr>
			</table>
			<table id="tabelle_nicht_oben_unten" width="100%">
				<tr>
					<td id="titel">Probengefäss</td>
				</tr>
				<tr>
					<td>
						<font id="Aktuell">
							<xsl:choose>
								<xsl:when test="count(da:Probengefaess/da:Auswahl)>0">
									<xsl:value-of select="da:Probengefaess/da:Auswahl"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="da:Probengefaess/da:Sonstiges"/>
								</xsl:otherwise>
							</xsl:choose>
						</font>
					</td>
				</tr>
				<tr>
					<td id="titel">Bemerkungen</td>
				</tr>
				<tr>
					<td>
						<font id="Aktuell">
							<xsl:value-of select="da:Bemerkungen"/>
						</font>
					</td>
				</tr>
			</table>
		</xsl:for-each>
		<table id="tabelle_nicht_oben" width="100%">
			<tr>
				<td>
					<table>
						<tr>
							<td width="2%"/>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<font id="Aktuell">
												<xsl:if test="da:Probenahme/da:TransKuehl='true'">X</xsl:if>
											</font>
										</td>
									</tr>
								</table>
							</td>
							<td id="titel" width="20%">Transport gekühlt</td>
							<td width="10%"/>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<font id="Aktuell">
												<xsl:if test="da:Probenahme/da:LagerKuehl='true'">X</xsl:if>
											</font>
										</td>
									</tr>
								</table>
							</td>
							<td id="titel" width="20%">Lagerung gekühlt</td>
							<td width="30%"/>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		<table>
			<tr height="5">
				<td id="Ueberschrift2"/>
			</tr>
		</table>

	</xsl:template>

	<xsl:template name="DA_Organ">
		<xsl:for-each select="da:Organoleptik/da:Eluat">
			<table id="tabelle_nicht_unten" width="100%">
				<tr>
					<td id="Ueberschrift2">Organoleptik - Eluat</td>
				</tr>
				<tr height="5">
					<td id="Ueberschrift2"/>
				</tr>
				<tr>
					<td id="titel">Farbe</td>
				</tr>
				<tr>
					<td>
						<font id="Aktuell">
							<xsl:value-of select="da:Farbe"/>
						</font>
					</td>
				</tr>
				<tr>
					<td id="titel">Geruch</td>
				</tr>
				<tr>
					<td>
						<font id="Aktuell">
							<xsl:value-of select="da:Geruch"/>
						</font>
					</td>
				</tr>
				<tr>
					<td id="titel">Aussehen</td>
				</tr>
				<tr>
					<td>
						<font id="Aktuell">
							<xsl:value-of select="da:Aussehen"/>
						</font>
					</td>
				</tr>
				<tr height="5">
					<td id="Ueberschrift2"/>
				</tr>
			</table>
		</xsl:for-each>
		<xsl:for-each select="da:Organoleptik/da:Abfall">
			<table id="tabelle_nicht_unten" width="100%">
				<tr>
					<td id="Ueberschrift2">Organoleptik - Abfall</td>
				</tr>
				<tr height="5">
					<td id="Ueberschrift2"/>
				</tr>
				<tr>
					<td id="titel">Farbe</td>
				</tr>
				<tr>
					<td>
						<font id="Aktuell">
							<xsl:value-of select="da:Farbe"/>
						</font>
					</td>
				</tr>
				<tr>
					<td id="titel">Geruch</td>
				</tr>
				<tr>
					<td>
						<font id="Aktuell">
							<xsl:value-of select="da:Geruch"/>
						</font>
					</td>
				</tr>
				<tr>
					<td id="titel">Aussehen</td>
				</tr>
				<tr>
					<td>
						<font id="Aktuell">
							<xsl:value-of select="da:Aussehen"/>
						</font>
					</td>
				</tr>
				<tr>
					<td id="titel">Konsistenz</td>
				</tr>
				<tr>
					<td>
						<font id="Aktuell">
							<xsl:value-of select="da:Konsistenz"/>
						</font>
					</td>
				</tr>
				<tr>
					<td id="Ueberschrift2">Reaktivität</td>
				</tr>
			</table>
			<table id="tabelle_nicht_oben_unten" width="100%">
				<tr>
					<td id="titel" width="25%">Brennverhalten / selbstentzündlich</td>
					<td id="titel" width="25%">Reaktion mit Wasser</td>
					<td id="titel" width="25%">Reaktion mit Basen</td>
					<td id="titel" width="25%">Reaktion mit Säuren</td>
				</tr>
				<tr>
					<td width="25%">
						<font id="Aktuell">
							<xsl:value-of select="da:Reaktivitaet/da:BV"/>
						</font>
					</td>
					<td width="25%">
						<font id="Aktuell">
							<xsl:value-of select="da:Reaktivitaet/da:ReWas"/>
						</font>
					</td>
					<td width="25%">
						<font id="Aktuell">
							<xsl:value-of select="da:Reaktivitaet/da:ReBas"/>
						</font>
					</td>
					<td width="25%">
						<font id="Aktuell">
							<xsl:value-of select="da:Reaktivitaet/da:ReSr"/>
						</font>
					</td>
				</tr>
			</table>
			<table id="tabelle_nicht_oben" width="100%">
				<tr>
					<td id="titel">Gefahrstoffe</td>
				</tr>
				<tr>
					<td>
						<font id="Aktuell">
							<xsl:value-of select="da:Reaktivitaet/da:Gefahrstoffe"/>
						</font>
					</td>
				</tr>
			</table>
			<table>
				<tr height="5">
					<td id="Ueberschrift2"/>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="DA_Analyse">
		<table width="100%">
			<tr>
				<td id="Nummer2">Analysenparameter</td>
			</tr>
			<tr height="5">
				<td id="Ueberschrift2"/>
			</tr>
		</table>

		<xsl:for-each select="da:Analysenparameter">
			<table id="tabelle_nicht_unten" width="100%">
				<tr>
					<td id="titel">Name des Parameters laut Labor zur späteren Plausibilitätskontrolle</td>
				</tr>
				<tr>
					<td>
						<font id="Aktuell">
							<xsl:value-of select="da:ParameterName"/>
						</font>
					</td>
				</tr>
				<tr>
					<td id="titel">Verbale Bezeichnung des Analysenverfahrens laut Labor zur späteren Plausibilitätskontrolle</td>
				</tr>
				<tr>
					<td>
						<font id="Aktuell">
							<xsl:value-of select="da:AnaVerfVerbal"/>
						</font>
					</td>
				</tr>
			</table>
			<table id="tabelle_nicht_oben_unten" width="100%">
				<tr>
					<td>
						<table>
							<tr>
								<td width="2%"/>
								<td>
									<table id="Tabelle_indikator">
										<tr>
											<td>
												<font id="Aktuell">
													<xsl:if test="count(da:MasseBez) > 0">X</xsl:if>
												</font>
											</td>
										</tr>
									</table>
								</td>
								<td id="titel" width="20%">Parameter für massebezogene Untersuchung</td>
								<td width="5%"/>
								<td>
									<table id="Tabelle_indikator">
										<tr>
											<td>
												<font id="Aktuell">
													<xsl:if test="count(da:VolBez) > 0">X</xsl:if>
												</font>
											</td>
										</tr>
									</table>
								</td>
								<td id="titel" width="20%">Parameter für volumenbezogene Untersuchung</td>
								<td width="35%"/>
							</tr>
						</table>
					</td>
				</tr>
			</table>
			<table id="tabelle_nicht_oben_unten" width="100%">
				<tr>
					<td id="titel">Methode</td>
				</tr>
				<tr>
					<td>
						<font id="Aktuell">
							<xsl:choose>
								<xsl:when test="count(da:MasseBez) > 0">
									<xsl:value-of select="da:MasseBez/@dalib:MethodeMass"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="da:VolBez/@dalib:MethodeVol"/>
								</xsl:otherwise> 
							</xsl:choose>
						</font>
					</td>
				</tr>
			</table>
			<table id="tabelle_nicht_oben_unten" width="100%">
				<tr>
					<td id="titel" width="20%">Gruppenkürzel</td>
					<td id="titel" width="20%">Parameterkürzel</td>
					<td id="titel" width="30%">Verfahren</td>
					<td id="titel" width="30%">Qualität</td>
				</tr>
				<xsl:choose>
					<xsl:when test="count(da:MasseBez) > 0">
						<tr>
							<xsl:for-each select="da:MasseBez/*">
								<td width="20%">
									<font id="Aktuell">
										<xsl:value-of select="local-name()"/>
									</font>
								</td>
							</xsl:for-each>
							<xsl:for-each select="da:MasseBez/*/*">
								<td width="20%">
									<font id="Aktuell">
										<xsl:value-of select="local-name()"/>
									</font>
								</td>
								<td width="30%">
									<font id="Aktuell">
										<xsl:value-of select="@Verfahren"/>
									</font>
								</td>
								<td width="30%">
									<font id="Aktuell">
										<xsl:value-of select="dalib:MessGrenz/@dalib:Qualitaet"/>
									</font>
								</td>
							</xsl:for-each>
						</tr>
					</xsl:when>
					<xsl:otherwise>
						<tr>
							<xsl:for-each select="da:VolBez/*">
								<td width="20%">
									<font id="Aktuell">
										<xsl:value-of select="local-name()"/>
									</font>
								</td>
							</xsl:for-each>
							<xsl:for-each select="da:VolBez/*/*">
								<td width="20%">
									<font id="Aktuell">
										<xsl:value-of select="local-name()"/>
									</font>
								</td>
								<td width="30%">
									<font id="Aktuell">
										<xsl:value-of select="@Verfahren"/>
									</font>
								</td>
								<td width="30%">
									<font id="Aktuell">
										<xsl:value-of select="dalib:MessGrenz/@dalib:Qualitaet"/>
									</font>
								</td>
							</xsl:for-each>
						</tr>
					</xsl:otherwise>
				</xsl:choose>
			</table>
			<table id="tabelle_nicht_oben_unten" width="100%">
				<tr>
					<td id="titel" width="10%">Vorzeichen</td>
					<td id="titel" width="10%">Wert</td>
					<td id="titel" width="10%">Einheit</td>
					<td id="titel" width="15%">Bereich von</td>
					<td id="titel" width="15%">Bereich bis</td>
				</tr>
				<xsl:choose>
					<xsl:when test="count(da:MasseBez) > 0">
						<tr>
							<td width="10%">
								<font id="Aktuell">
									<xsl:value-of select="da:MasseBez/*/*/dalib:MessGrenz/@dalib:Vorzeichen"/>
								</font>
							</td>
							<td width="10%">
								<font id="Aktuell">
									<xsl:value-of select="da:MasseBez/*/*/dalib:MessGrenz"/>
								</font>
							</td>
							<td width="10%">
								<font id="Aktuell">
									<xsl:value-of select="da:MasseBez/*/*/@Einheit"/>
								</font>
							</td>
							<td width="15%">
								<font id="Aktuell">
									<xsl:value-of select="da:MasseBez/*/*/dalib:Bereich[1]"/>
								</font>
							</td>
							<td width="15%">
								<font id="Aktuell">
									<xsl:value-of select="da:MasseBez/*/*/dalib:Bereich[2]"/>
								</font>
							</td>
						</tr>
					</xsl:when>
					<xsl:otherwise>
						<tr>
							<td width="10%">
								<font id="Aktuell">
									<xsl:value-of select="da:VolBez/*/*/dalib:MessGrenz/@dalib:Vorzeichen"/>
								</font>
							</td>
							<td width="10%">
								<font id="Aktuell">
									<xsl:value-of select="da:VolBez/*/*/dalib:MessGrenz"/>
								</font>
							</td>
							<td width="10%">
								<font id="Aktuell">
									<xsl:value-of select="da:VolBez/*/*/@Einheit"/>
								</font>
							</td>
							<td width="15%">
								<font id="Aktuell">
									<xsl:value-of select="da:VolBez/*/*/dalib:Bereich[1]"/>
								</font>
							</td>
							<td width="15%">
								<font id="Aktuell">
									<xsl:value-of select="da:VolBez/*/*/dalib:Bereich[2]"/>
								</font>
							</td>
						</tr>
					</xsl:otherwise>
				</xsl:choose>
			</table>
			<table id="tabelle_oben" width="100%">
			<tr height="5">
				<td id="Ueberschrift2"/>
			</tr>
			</table>
		</xsl:for-each>
		<table>
			<tr height="5">
				<td id="Ueberschrift2"/>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="DA_Unterschrift">
		<table width="100%" id="tabelle">
			<tr>
				<td width="50%" id="Titel">Rechtsverbindliche Unterschrift (1. Signatur)</td>
				<td width="50%" id="Titel">Rechtsverbindliche Unterschrift (2. Signatur)</td>
			</tr>
			<tr>
				<td width="50%" id="Aktuell">
					<xsl:if test="count(ds:Signature/ds:KeyInfo/ds:X509Data/ds:X509Certificate) > 0">
						<xsl:value-of select="x509:extractCommonName(b64:decode(ds:Signature[1]/ds:KeyInfo/ds:X509Data/ds:X509Certificate))"/>
						<xsl:variable name="SIG_DATE">
							<xsl:call-template name="formatDate">
								<xsl:with-param name="date" select="ds:Signature[1]/ds:Object/xades:QualifyingProperties/xades:SignedProperties/xades:SignedSignatureProperties/xades:SigningTime"/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:value-of select="concat(' (', $SIG_DATE, ')')"/>
					</xsl:if>
				</td>
				<td width="50%" id="Aktuell">
					<xsl:if test="count(ds:Signature/ds:KeyInfo/ds:X509Data/ds:X509Certificate) > 1">
						<xsl:value-of select="x509:extractCommonName(b64:decode(ds:Signature[2]/ds:KeyInfo/ds:X509Data/ds:X509Certificate))"/>
						<xsl:variable name="SIG_DATE2">
							<xsl:call-template name="formatDate">
								<xsl:with-param name="date" select="ds:Signature[2]/ds:Object/xades:QualifyingProperties/xades:SignedProperties/xades:SignedSignatureProperties/xades:SigningTime"/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:value-of select="concat(' (', $SIG_DATE2, ')')"/>
					</xsl:if>
				</td>
			</tr>
		</table>
		<table>
			<tr height="5">
				<td id="Ueberschrift2"/>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="DA_Anhang">
		<table width="100%" border="0">
			<tr align="left">
				<td id="Text_normal "> Dateianhang: </td>
			</tr>
			<xsl:if test="count(en:DA/en:Dateianhang) > 0">
				<table width="100%" border="0">
				<tr>
					<td>
						<br/>
						<ul>
							<xsl:for-each select="en:DA/en:Dateianhang">
								<font id="Aktuell">
									<li>
										<xsl:value-of select="@lib:dateiname"/>
									</li>
								</font>
							</xsl:for-each>
						</ul>
					</td>
				</tr>
				</table>
				<!--xsl:call-template name="ListAnhang"/-->
			</xsl:if>
		</table>
		<table>
			<tr height="5">
				<td id="Ueberschrift2"/>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="DA_Position">
		<xsl:variable name="CNTLAYER">
			<xsl:value-of select="count(//*[(starts-with(local-name(), 'ENSN')) and (contains(local-name(), 'Layer'))])"></xsl:value-of>
		</xsl:variable>
		<xsl:for-each select="//*[(starts-with(local-name(), 'ENSN')) and (contains(local-name(), 'Layer'))]">
			<xsl:if test="en:VE/en:DADokument">
				<xsl:value-of select="concat(local-name(),@lib:LayerID)"/>
				<!--xsl:choose>
					<xsl:when test="$CNTLAYER - position() + 1 > 9">
						<xsl:value-of select="concat($CNTLAYER - position() + 1,'. ',local-name())"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('0', $CNTLAYER - position() + 1,'. ',local-name())"/>
					</xsl:otherwise>
				</xsl:choose--> 
				<xsl:if test="position() != last()"> / </xsl:if>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

</xsl:stylesheet>
