<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:dyn="http://exslt.org/dynamic" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
	xmlns:en="uri:BMU_Waste_Interface/EN" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#"
	xmlns:entst="uri:EntsorgerStammdaten/EntStamm"
	xmlns:eslib="uri:EntsorgerStammdaten/EntStammTypBibliothek"
	xmlns:util="xalan://de.itu.util.TransformUtils" 
	extension-element-prefixes="dyn util"
	exclude-result-prefixes="xsl dyn lib ds en util">
	<xsl:import href="ZKS-Library_fx.xsl"/>
	<xsl:output method="html"/>
	<!-- bei neuladen übergebene Parameter -->
	<xsl:param name="positionsnummer" select="1"/>
	<xsl:param name="CURRENT_DATE" select="'2023-04-13'"/>	
	<xsl:variable name="MAX_ZEICHEN_MEMO" select="2400"/>

	<!--xsl:key name="KeyAbfSchl" use="entst:Abfallschluessel" match="entst:Abfall"/-->
	<!-- ###################################################################### -->
	<!-- Hier eine Map für die ausgegebenen Abfallschlüssel einrichten bzw. leer initialisieren. -->
	<!-- Siehe weiter unten im Template 'Abfall'. -->
	<!-- ###################################################################### -->

	<xsl:template match="/">
		<xsl:for-each select="//entst:Entsorger">
			<xsl:if test="position()=$positionsnummer">
				<html>
					<head>
						<title>Entsorger</title>
						<!-- CSS - Datei -->
						<xsl:call-template name="Style"/>
					</head>
					<body>
						<xsl:call-template name="Kopf"/>
						<xsl:call-template name="ZeileMain"/>
					</body>
				</html>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="ZeileMain">
		<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
			<tr>
				<td/>
			</tr>
			<tr>
				<td>
					<xsl:call-template name="Betrieb"/>
					<xsl:call-template name="FkbZuBetrieb"/>
					<xsl:call-template name="EndeBetrieb"/>
					<xsl:call-template name="Abfall"/>
				</td>
			</tr>
		</table>
		<p style="page-break-after:always">
			<br style="height:0; line-height:0"/>
		</p>
	</xsl:template>

	<xsl:template name="Betrieb">
		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td>
					<font id="Titel">Entsorgerbetriebsstätte</font>
				</td>
			</tr>
		</table>
		<table width="100%" id="tabelle_nicht_oben_unten">
			<!--colgroup>
				<col width="20%"/>
				<col width="40%"/>
				<col width="40%"/>
			</colgroup-->
			<tr>
				<td id="Titel_klein">Entsorgernummer</td>
				<!--td id="Titel_klein">Arbeitsstättennummer</td-->
				<!--td id="Titel_klein">Registriernummer im Heimatland</td-->
			</tr>
			<tr>
				<td id="Aktuell">
					<xsl:value-of select="entst:EntsorgerBetrieb/entst:BehoerdlicheNummer/eslib:BehoerdlicheNr"/>
					&#173;
					<xsl:value-of select="entst:EntsorgerBetrieb/entst:BehoerdlicheNummer/eslib:Pruefziffer"/>
				</td>
				<!--td id="Aktuell">
					<xsl:value-of select="entst:EntsorgerBetrieb/entst:ArbeitsstaettenNummer"/>
				</td>
				<td id="Aktuell">
					<xsl:value-of select="entst:EntsorgerBetrieb/entst:RegistriernummerHeimatland"/>
				</td-->
			</tr>
		</table>
		
		<xsl:call-template name="NameUndAdresseBtr">
			<xsl:with-param name="prefix" select="'entst:EntsorgerBetrieb/entst:'"/>
			<xsl:with-param name="prefixLib" select="'eslib:'"/>
			<xsl:with-param name="withPostfach" select="false()"/>
		</xsl:call-template>
		
		<xsl:call-template name="KontaktBtr">
			<xsl:with-param name="prefix" select="'entst:EntsorgerBetrieb/entst:Kontaktdaten/eslib:'"/>
		</xsl:call-template>

	</xsl:template>
	
	<xsl:template name="Abfall">
		<xsl:variable name="CNT_ABF" select="count(//entst:EntsorgerBetrieb/entst:Teilanlagen/entst:Abfallgruppen/entst:Abfall)"/>
			
		<table id="Tabelle_unten" width="100%">
			<tr>
				<td>
				</td>
			</tr>
		</table>
		
		<xsl:choose>
			<xsl:when test="$CNT_ABF>0">
				
				<table id="Tabelle_nicht_oben_unten" width="100%">
					<tr>
						<td id="Titel">Aktuell zugelassene Abfallschlüssel</td>
					</tr>
				</table>
			
				<!-- ############################################## -->
				<!-- ACHTUNG: Nur eine Krücke, weil ich nicht an das aktuelle Datum herankomme. NICHT für den produktiven Einsatz verwenden! (ef, 13.04.2023) -->
				<xsl:variable name="TODAY" select="number(concat(substring($CURRENT_DATE, 1, 4), substring($CURRENT_DATE, 6, 2), substring($CURRENT_DATE, 9, 2)))"/>
				<!-- ############################################## -->
				<xsl:variable name="SCHLUESSEL_MAP" select="util:resetSchluesselMap()"/>
				
				<!-- In dieser For-each-Schleife wird jeder Abfallschlüssel nur einmal aufgerufen. Dient also der Gruppierung nach Abfallschlüsseln. (Gefunden als Beispiel im XSLT-Buch v. Doug Tidwell) -->
				<!-- Hierzu gehört auch das Key-Element vor dem ersten Template -->
				<xsl:for-each select="//entst:Abfall">
					<xsl:sort select="entst:Abfallschluessel" data-type="number" order="ascending"/>
					
					<xsl:variable name="CURRENT_ABFSCHL" select="./entst:Abfallschluessel"/>
					<!-- Mit der vorletzten Bedingung werden sowohl Abfallschlüssel mit Gestrichen='false' als auch mit fehlendem Gestrichen-Element gezählt. -->
					<!-- Mit der letzten Bedingung werden sowohl Abfallschlüssel mit Input='true' als auch mit fehlenden Input-Element gezählt. -->
					<xsl:variable name="CUR_ABFSCHL_NOTGESTR_INPUT" select="count(self::node()[entst:Abfallschluessel=$CURRENT_ABFSCHL and not(entst:Gestrichen='true') and not(entst:Input='false')])"/>
					<xsl:variable name="CUR_ABFSCHL_NOTGESTR" select="count(self::node()[entst:Abfallschluessel=$CURRENT_ABFSCHL and not(entst:Gestrichen='true')])"/>
					<xsl:variable name="CUR_ABFSCHL_INPUT" select="count(self::node()[entst:Abfallschluessel=$CURRENT_ABFSCHL and not(entst:Input='false')])"/>
					
					<!--table id="Tabelle_nicht_oben_unten" width="100%">
						<colgroup>
							<col width="10%"/>
							<col width="10%"/>
							<col width="40%"/>
							<col width="10%"/>
							<col width="10%"/>
							<col width="10%"/>
							<col width="10%"/>
						</colgroup>
						<tr>
							<td>
								<xsl:value-of select="position()"/>
							</td>
							<td>
								<xsl:value-of select="$CURRENT_ABFSCHL"/>
							</td>
							<td id="Titel_klein">Abfälle (Summe/!gestr./Input/!gestr.&amp;Input)</td>
							<td>
								<xsl:value-of select="$CNT_ABF"/>
							</td>
							<td>
								<xsl:value-of select="$CUR_ABFSCHL_NOTGESTR"/>
							</td>
							<td>
								<xsl:value-of select="$CUR_ABFSCHL_INPUT"/>
							</td>
							<td>
								<xsl:value-of select="$CUR_ABFSCHL_NOTGESTR_INPUT"/>
							</td>
						</tr>
					</table-->
					
					<!--Ist der Abfallschlüssel nicht gestrichen und nicht explizit kein Inputabfall? Dann ist der Abfall zugelassen.  --> 
					<xsl:if test="($CUR_ABFSCHL_NOTGESTR_INPUT &gt; 0)">
						
						<!-- Wieviele der nicht gestrichenen Inputabfälle haben ein Startdatum der Zulassung in der Gruppe? -->
						<xsl:variable name="CNT_ABFGR_ZULAB" select="count(self::node()[entst:Abfallschluessel=$CURRENT_ABFSCHL and not(entst:Gestrichen='true') and not(entst:Input='false')]/../entst:DatumZulassungAb)"/>
						<!-- Wieviele der nicht gestrichenen Inputabfälle haben kein Startdatum der Zulassung in der Gruppe? -->
						<xsl:variable name="CNT_ABFGR_ZULAB_NULL" select="($CUR_ABFSCHL_NOTGESTR_INPUT - $CNT_ABFGR_ZULAB)"/>
						<!-- Wieviele der nicht gestrichenen Inputabfälle haben ein Startdatum der Zulassung, das nicht in der Zukunft liegt? -->
						<xsl:variable name="ABFGR_ZULAB_OK" select="count(self::node()[entst:Abfallschluessel=$CURRENT_ABFSCHL and not(entst:Gestrichen='true') and not(entst:Input='false')]/../entst:DatumZulassungAb[$TODAY - (number(concat(substring(., 1,4), substring(., 6,2), substring(., 9,2)))) > 0])"/>
						
						<!--table id="Tabelle_nicht_oben_unten" width="100%">
							<colgroup>
								<col width="10%"/>
								<col width="10%"/>
								<col width="40%"/>
								<col width="10%"/>
								<col width="10%"/>
								<col width="10%"/>
								<col width="10%"/>
							</colgroup>
							<tr>
								<td>
									<xsl:value-of select="position()"/>
								</td>
								<td>
									<xsl:value-of select="$CURRENT_ABFSCHL"/>
								</td>
								<td id="Titel_klein">Abfallgruppe Zugelassen von (mit/null/ok/null+ok)</td>
								<td>
									<xsl:value-of select="$CNT_ABFGR_ZULAB"/>
								</td>
								<td>
									<xsl:value-of select="$CNT_ABFGR_ZULAB_NULL"/>
								</td>
								<td>
									<xsl:value-of select="$ABFGR_ZULAB_OK"/>
								</td>
								<td>
									<xsl:value-of select="$ABFGR_ZULAB_OK + $CNT_ABFGR_ZULAB_NULL"/>
								</td>
							</tr>
						</table-->
						
						<!--Gibt es zum Abfallschlüssel kein Datum des Zulassungsbeginns der Abfallgruppe oder
							 liegt das Datum des Zulassungsbeginns nicht in der Zukunft? Dann ist die Abfallgruppe zugelassen. -->
						<xsl:if test="($CNT_ABFGR_ZULAB_NULL &gt; 0) or ($ABFGR_ZULAB_OK &gt; 0)">
							
							<!-- Wieviele der nicht gestrichenen Inputabfälle haben ein Enddatum der Zulassung in der Gruppe? -->
							<xsl:variable name="CNT_ABFGR_ZULBIS" select="count(self::node()[entst:Abfallschluessel=$CURRENT_ABFSCHL and not(entst:Gestrichen='true') and not(entst:Input='false')]/../entst:DatumZulassungBis)"/>
							<!-- Wieviele der nicht gestrichenen Inputabfälle haben kein Enddatum der Zulassung in der Gruppe? -->
							<xsl:variable name="CNT_ABFGR_ZULBIS_NULL" select="($CUR_ABFSCHL_NOTGESTR_INPUT - $CNT_ABFGR_ZULBIS)"/>
							<!-- Wieviele der nicht gestrichenen Inputabfälle haben ein Enddatum der Zulassung, das nicht in der Vergangenheit liegt? -->
							<xsl:variable name="ABFGR_ZULBIS_OK" select="count(self::node()[entst:Abfallschluessel=$CURRENT_ABFSCHL and not(entst:Gestrichen='true') and not(entst:Input='false')]/../entst:DatumZulassungBis[  (number(concat(substring(., 1,4), substring(., 6,2), substring(., 9,2))) - $TODAY) > 0])"/>

							<!--table id="Tabelle_nicht_oben_unten" width="100%">
								<colgroup>
									<col width="10%"/>
									<col width="10%"/>
									<col width="40%"/>
									<col width="10%"/>
									<col width="10%"/>
									<col width="10%"/>
									<col width="10%"/>
								</colgroup>
								<tr>
									<td>
										<xsl:value-of select="position()"/>
									</td>
									<td>
										<xsl:value-of select="$CURRENT_ABFSCHL"/>
									</td>
									<td id="Titel_klein">Abfallgruppe Zugelassen bis (mit/null/ok/null+ok)</td>
									<td>
										<xsl:value-of select="$CNT_ABFGR_ZULBIS"/>
									</td>
									<td>
										<xsl:value-of select="$CNT_ABFGR_ZULBIS_NULL"/>
									</td>
									<td>
										<xsl:value-of select="$ABFGR_ZULBIS_OK"/>
									</td>
									<td>
										<xsl:value-of select="$ABFGR_ZULBIS_OK + $CNT_ABFGR_ZULBIS_NULL"/>
									</td>
								</tr>
							</table-->
							
							<!--Gibt es zum Abfallschlüssel kein Datum des Zulassungsendes der Abfallgruppe oder
								 liegt das Datum des Zulassungsendes nicht in der Vergangenheit? Dann ist die Abfallgruppe zugelassen. -->
							<xsl:if test="($CNT_ABFGR_ZULBIS_NULL &gt; 0) or ($ABFGR_ZULBIS_OK &gt; 0)">
								
								<!-- Wieviele der nicht gestrichenen Inputabfälle haben ein Datum des Genehmigungsbeginns der Teilanlage? -->
								<xsl:variable name="CNT_TA_GENVON" select="count(self::node()[entst:Abfallschluessel=$CURRENT_ABFSCHL and not(entst:Gestrichen='true') and not(entst:Input='false')]/../../entst:GenehmigtVon)"/>
								<!-- Wieviele der nicht gestrichenen Inputabfälle haben kein Datum des Genehmigungsbeginns der Teilanlage? -->
								<xsl:variable name="CNT_TA_GENVON_NULL" select="($CUR_ABFSCHL_NOTGESTR_INPUT - $CNT_TA_GENVON)"/>
								<!-- Wieviele der nicht gestrichenen Inputabfälle haben ein Datum des Genehmigungsbeginns, das nicht in der Zukunft liegt? -->
								<xsl:variable name="TA_GENVON_OK" select="count(self::node()[entst:Abfallschluessel=$CURRENT_ABFSCHL and not(entst:Gestrichen='true') and not(entst:Input='false')]/../../entst:GenehmigtVon[$TODAY - (number(concat(substring(., 1,4), substring(., 6,2), substring(., 9,2)))) > 0])"/>
								
								<!--table id="Tabelle_nicht_oben_unten" width="100%">
									<colgroup>
										<col width="10%"/>
										<col width="10%"/>
										<col width="40%"/>
										<col width="10%"/>
										<col width="10%"/>
										<col width="10%"/>
										<col width="10%"/>
									</colgroup>
									<tr>
										<td>
											<xsl:value-of select="position()"/>
										</td>
										<td>
											<xsl:value-of select="$CURRENT_ABFSCHL"/>
										</td>
										<td id="Titel_klein">Teilanlage Genehmigung von (mit/null/ok/null+ok)</td>
										<td>
											<xsl:value-of select="$CNT_TA_GENVON"/>
										</td>
										<td>
											<xsl:value-of select="$CNT_TA_GENVON_NULL"/>
										</td>
										<td>
											<xsl:value-of select="$TA_GENVON_OK"/>
										</td>
										<td>
											<xsl:value-of select="$TA_GENVON_OK + $CNT_TA_GENVON_NULL"/>
										</td>
									</tr>
								</table-->
								
								<!--Gibt es zum Abfallschlüssel kein Datum des Genehmigungsbeginns der Teilanlage oder
									 liegt das Datum des Genehmigungsbeginns nicht in der Zukunft? Dann ist die Teilanlage zugelassen. -->
								<xsl:if test="($CNT_TA_GENVON_NULL &gt; 0) or ($TA_GENVON_OK &gt; 0)">
								
									<!-- Wieviele der nicht gestrichenen Inputabfälle haben ein Datum des Genehmigungsendes der Teilanlage? -->
									<xsl:variable name="CNT_TA_GENBIS" select="count(self::node()[entst:Abfallschluessel=$CURRENT_ABFSCHL and not(entst:Gestrichen='true') and not(entst:Input='false')]/../../entst:GenehmigtBis)"/>
									<!-- Wieviele der nicht gestrichenen Inputabfälle haben kein Datum des Genehmigungsendes der Teilanlage? -->
									<xsl:variable name="CNT_TA_GENBIS_NULL" select="($CUR_ABFSCHL_NOTGESTR_INPUT - $CNT_TA_GENBIS)"/>
									<!-- Wieviele der nicht gestrichenen Inputabfälle haben ein Datum des Genehmigungsendes, das nicht in der Vergangenheit liegt? -->
									<xsl:variable name="TA_GENBIS_OK" select="count(self::node()[entst:Abfallschluessel=$CURRENT_ABFSCHL and not(entst:Gestrichen='true') and not(entst:Input='false')]/../../entst:GenehmigtBis[(number(concat(substring(., 1,4), substring(., 6,2), substring(., 9,2))) - $TODAY) > 0])"/>
									
									<!--table id="Tabelle_nicht_oben_unten" width="100%">
										<colgroup>
											<col width="10%"/>
											<col width="10%"/>
											<col width="40%"/>
											<col width="10%"/>
											<col width="10%"/>
											<col width="10%"/>
											<col width="10%"/>
										</colgroup>
										<tr>
											<td>
												<xsl:value-of select="position()"/>
											</td>
											<td>
												<xsl:value-of select="$CURRENT_ABFSCHL"/>
											</td>
											<td id="Titel_klein">Teilanlage Genehmigung bis (mit/null/ok/null+ok)</td>
											<td>
												<xsl:value-of select="$CNT_TA_GENBIS"/>
											</td>
											<td>
												<xsl:value-of select="$CNT_TA_GENBIS_NULL"/>
											</td>
											<td>
												<xsl:value-of select="$TA_GENBIS_OK"/>
											</td>
											<td>
												<xsl:value-of select="$TA_GENBIS_OK + $CNT_TA_GENBIS_NULL"/>
											</td>
										</tr>
									</table-->
									
									<!--Gibt es zum Abfallschlüssel kein Datum des Genehmigungsendes der Teilanlage oder
										 liegt das Datum des Genehmigungsendes nicht in der Vergangenheit? Dann ist die Teilanlage zugelassen. -->
									<xsl:if test="($CNT_TA_GENBIS_NULL &gt; 0) or ($TA_GENBIS_OK &gt; 0)">
										
										<!-- Wieviele der nicht gestrichenen Inputabfälle haben ein Datum des Betriebsbeginns der Teilanlage? -->
										<xsl:variable name="CNT_TA_BTRVON" select="count(self::node()[entst:Abfallschluessel=$CURRENT_ABFSCHL and not(entst:Gestrichen='true') and not(entst:Input='false')]/../../entst:ZulGenRechtsgrund/entst:Betriebsbeginn)"/>
										<!-- Wieviele der nicht gestrichenen Inputabfälle haben kein Datum des Betriebsbeginns der Teilanlage? -->
										<xsl:variable name="CNT_TA_BTRVON_NULL" select="($CUR_ABFSCHL_NOTGESTR_INPUT - $CNT_TA_BTRVON)"/>
										<!-- Wieviele der nicht gestrichenen Inputabfälle haben ein Datum des Betriebsbeginns, das nicht in der Zukunft liegt? -->
										<xsl:variable name="TA_BTRVON_OK" select="count(self::node()[entst:Abfallschluessel=$CURRENT_ABFSCHL and not(entst:Gestrichen='true') and not(entst:Input='false')]/../../entst:ZulGenRechtsgrund/entst:Betriebsbeginn[$TODAY - (number(concat(substring(., 1,4), substring(., 6,2), substring(., 9,2)))) > 0])"/>
								
										<!--table id="Tabelle_nicht_oben_unten" width="100%">
											<colgroup>
												<col width="10%"/>
												<col width="10%"/>
												<col width="40%"/>
												<col width="10%"/>
												<col width="10%"/>
												<col width="10%"/>
												<col width="10%"/>
											</colgroup>
											<tr>
												<td>
													<xsl:value-of select="position()"/>
												</td>
												<td>
													<xsl:value-of select="$CURRENT_ABFSCHL"/>
												</td>
												<td id="Titel_klein">Teilanlage Betriebsbeginn (mit/null/ok/null+ok)</td>
												<td>
													<xsl:value-of select="$CNT_TA_BTRVON"/>
												</td>
												<td>
													<xsl:value-of select="$CNT_TA_BTRVON_NULL"/>
												</td>
												<td>
													<xsl:value-of select="$TA_BTRVON_OK"/>
												</td>
												<td>
													<xsl:value-of select="$TA_BTRVON_OK + $CNT_TA_BTRVON_NULL"/>
												</td>
											</tr>
										</table-->
										
										<!--Gibt es zum Abfallschlüssel kein Datum des Betriebsbeginns der Teilanlage oder
											 liegt das Datum des Betriebsbeginns nicht in der Zukunft? Dann ist die Teilanlage in Betrieb. -->
										<xsl:if test="($CNT_TA_BTRVON_NULL &gt; 0) or ($TA_BTRVON_OK &gt; 0)">
										
											<!-- Wieviele der nicht gestrichenen Inputabfälle haben ein Datum des Betriebsendes der Teilanlage? -->
											<xsl:variable name="CNT_TA_BTRBIS" select="count(self::node()[entst:Abfallschluessel=$CURRENT_ABFSCHL and not(entst:Gestrichen='true') and not(entst:Input='false')]/../../entst:ZulGenRechtsgrund/entst:Betriebsende)"/>
											<!-- Wieviele der nicht gestrichenen Inputabfälle haben kein Datum des Betriebsendes der Teilanlage? -->
											<xsl:variable name="CNT_TA_BTRBIS_NULL" select="($CUR_ABFSCHL_NOTGESTR_INPUT - $CNT_TA_BTRBIS)"/>
											<!-- Wieviele der nicht gestrichenen Inputabfälle haben ein Datum des Betriebsendes, das nicht in der Vergangenheit liegt? -->
											<xsl:variable name="TA_BTRBIS_OK" select="count(self::node()[entst:Abfallschluessel=$CURRENT_ABFSCHL and not(entst:Gestrichen='true') and not(entst:Input='false')]/../../entst:ZulGenRechtsgrund/entst:Betriebsende[(number(concat(substring(., 1,4), substring(., 6,2), substring(., 9,2))) - $TODAY) > 0])"/>
											
											<!--table id="Tabelle_nicht_oben_unten" width="100%">
												<colgroup>
													<col width="10%"/>
													<col width="10%"/>
													<col width="40%"/>
													<col width="10%"/>
													<col width="10%"/>
													<col width="10%"/>
													<col width="10%"/>
												</colgroup>
												<tr>
													<td>
														<xsl:value-of select="position()"/>
													</td>
													<td>
														<xsl:value-of select="$CURRENT_ABFSCHL"/>
													</td>
													<td id="Titel_klein">Teilanlage Betriebsende (mit/null/ok/null+ok)</td>
													<td>
														<xsl:value-of select="$CNT_TA_BTRBIS"/>
													</td>
													<td>
														<xsl:value-of select="$CNT_TA_BTRBIS_NULL"/>
													</td>
													<td>
														<xsl:value-of select="$TA_BTRBIS_OK"/>
													</td>
													<td>
														<xsl:value-of select="$TA_BTRBIS_OK + $CNT_TA_BTRBIS_NULL"/>
													</td>
												</tr>
											</table-->
											<xsl:variable name="ABF_VORHANDEN" select="util:checkSchluesselInMap($CURRENT_ABFSCHL)"/>
											
											<!--Gibt es zum Abfallschlüssel kein Datum des Betriebsendes der Teilanlage oder
												 liegt das Datum des Betriebsendes nicht in der Vergangenheit? Dann ist die Teilanlage in Betrieb. -->
											<xsl:if test="(($CNT_TA_BTRBIS_NULL &gt; 0) or ($TA_BTRBIS_OK &gt; 0)) and not ($ABF_VORHANDEN)">
											
												<!--xsl:if test="position() &gt; 1">
													<xsl:call-template name="TableOneDashLine"/>
												</xsl:if-->
												<!-- ############################################################################ -->
												<!-- Hier den Abfallschlüssel in eine Map schreiben und Rückgabe prüfen -->
												<!-- Wenn Rückgabe = 0 -> Abfallschlüssel ist neu -> ausgeben -->
												<!-- Wenn Rückgabe != 0 -> Abfallschlüssel wurde schon einmal ausgegeben -> nicht ausgeben -->
												<!-- Nachfolgende Zeile mit Test umschreiben, um den Rückgabewert zu prüfen. -->
												<!-- ############################################################################ -->
												
												<xsl:if test="true()">
													<table width="100%" id="tabelle_nicht_oben_unten">
														<colgroup>
															<col width="15%"/>
															<col width="85%"/>
														</colgroup>
														<tr>
															<td id="Titel_klein">Abfallschlüssel</td>
															<td id="Aktuell">
																<xsl:value-of select="entst:Abfallschluessel"/>
															</td>
														</tr>
													</table>
												</xsl:if>
											</xsl:if>
										</xsl:if>
									</xsl:if>
								</xsl:if>
							</xsl:if>
						</xsl:if>
					</xsl:if>
				</xsl:for-each>

				<!--xsl:call-template name="TableOneDashLine"/>
				<table id="Tabelle_nicht_oben_unten" width="100%">
					<tr>
						<td id="Titel_klein">Die hier aufgelisteten Abfallschlüssel sind für mindestens eine Teilanlage des Entsorgers</td>
					</tr>
					<tr>
						<td id="Titel_klein">- als zugelassener Abfall eingetragen,</td>
					</tr>
					<tr>
						<td id="Titel_klein">- dabei nicht als gestrichen markiert,</td>
					</tr>
					<tr>
						<td id="Titel_klein">- dabei als Input-Abfall markiert,</td>
					</tr>
					<tr>
						<td id="Titel_klein">- dabei mit einem Startdatum der Zulassung nicht in der Zukunft und einem Enddatum der Zulassung nicht in der Vergangenheit versehen,</td>
					</tr>
					<tr>
						<td id="Titel_klein">- dabei mit einem Startdatum der Genehmigung der Teilanlage nicht in der Zukunft und einem Enddatum der Zulassung nicht in der Vergangangheit versehen und</td>
					</tr>
					<tr>
						<td id="Titel_klein">- dabei mit einem Startdatum des Betriebs der Teilanlage nicht in der Zukunft und einem Enddatum des Betriebs nicht in der Vergangenheit versehen.</td>
					</tr>
					<tr>
						<td id="Titel_klein">Wenn eine der vorstehenden Angaben zum Abfall unbekannt ist, wird dies als positiver Fall gewertet und der Abfall daher nicht ausgeschlossen.</td>
					</tr>
				</table-->
			</xsl:when>
			<xsl:otherwise>
				<table id="Tabelle_nicht_oben_unten" width="100%">
					<tr>
						<td id="Titel_klein">Zu diesem Entsorger liegen keine Informationen über zugelassenen Abfallschlüssel vor.</td>
					</tr>
				</table>
			</xsl:otherwise>
		</xsl:choose>

		<table id="Tabelle_oben" width="100%">
			<tr>
				<td>
				</td>
			</tr>
		</table>

	</xsl:template>

	<xsl:template name="EndeBetrieb">
		<!-- Tabelle mit unterer Linie versehen -->
		<table id="Tabelle_oben" width="100%">
			<tr>
				<td>
				</td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="FkbZuBetrieb">
		<xsl:for-each select="entst:FKB">
			<xsl:call-template name="Fkb_short">
				<xsl:with-param name="prefix" select="'entst:'"/>
				<xsl:with-param name="prefixLib" select="'eslib:'"/>
			</xsl:call-template>
			<table id="Tabelle_oben" width="100%">
				<tr>
					<td>
					</td>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
