<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
 	xmlns:msg="uri:BMU_Waste_Interface/Message" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
	xmlns:zks="uri:BMU_Waste_Interface/ZKS" 
	xmlns:b64="xalan://de.itu.util.Base64" 
	xmlns:crc32="xalan://de.itu.util.CRC32Helper" 
	xmlns:x509="xalan://de.itu.util.X509CertHelper" 
	extension-element-prefixes="b64 crc32 x509" 
	exclude-result-prefixes="xsl lib ds zks b64 crc32 x509">
	<xsl:import href="ZKS-Library.xsl"/>
	<xsl:output method="html"/>
	<xsl:param name="positionsnummer"/>
	<xsl:template match="/">
		<xsl:choose>
			<xsl:when test="msg:Nachricht">
				<xsl:for-each select="msg:Nachricht/msg:Nutzdaten">
					<xsl:apply-templates/>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="zks:Registrierungsquittung">
		<html>
			<head>
				<title>Registrierungsquittung</title>
				<!-- CSS - Datei   -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf"/>
				<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
					<tr>
						<th>
							<xsl:for-each select="//zks:Registrierungsquittung">
								<xsl:call-template name="Zeile0"/>
								<xsl:call-template name="Zeile1"/>
								<xsl:call-template name="Zeile2"/>
								<xsl:call-template name="Zeile3"/>
								<xsl:call-template name="Zeile4"/>
								<xsl:call-template name="Zeile5"/>
								<xsl:call-template name="Zeile6"/>
								<xsl:call-template name="Zeile7"/>
								<xsl:call-template name="AnhangZKS"/>
							</xsl:for-each>
						</th>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>

	<xsl:template name="Zeile0">
		<table width="100%" border="0">
			<tr>
				<td>
					<font id="Nummer">
						Registrierungsquittung 
					</font>
				</td>
			</tr>
			<tr height="3%">
				<td>
			</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile1">
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr>
				<td id="Titel"> Antrag UUID </td>
				<td id="Titel"> Lfd Nr. </td>
			</tr>
			<tr>
				<td>
					<font id="Aktuell">
						<xsl:value-of select="zks:AntragUUID"/>
					</font>
				</td>
				<td>
					<font id="Aktuell">
						<xsl:value-of select="zks:LfdNrAntrag"/>
					</font>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile2">
		<xsl:for-each select="zks:Behoerde">
			<table id="tabelle_nicht_unten" width="100%" border="0">
				<tr align="left">
					<td id="Text_normal ">Beh&#246;rde</td>
				</tr>
				<tr height="10">
					<td/>
				</tr>
				<tr width="100%">
					<td width="20%" id="Titel"> Beh&#246;rdliche Nummer </td>
					<td width="80%"/>
				</tr>
				<tr width="100%">
					<td width="20%">
						<font id="Aktuell">
							<xsl:value-of select="zks:BehoerdlicheNummer"/>
							<xsl:value-of select="zks:Pruefziffer"/>
						</font>
					</td>
				</tr>
			</table>
			<xsl:call-template name="NameUndAdresse">
				<xsl:with-param name="prefix" select="zks:NameUndAdresse"/>
				<xsl:with-param name="table_width" select="40"/>
			</xsl:call-template>
			<xsl:call-template name="Ansprechpartner">
				<xsl:with-param name="prefix" select="zks:Ansprechpartner"/>
				<xsl:with-param name="table_width" select="40"/>
			</xsl:call-template>
		</xsl:for-each>
		<table id="tabelle_nicht_oben_unten" width="100%">
			<tr width="100%">
				<td width="30%" id="Text_normal">Unterschrift (fortgeschrittene Signatur)</td>
			</tr>
			<tr width="100%">
				<td width="100%">
					<xsl:call-template name="Sig1NameNoLayer"/>
				</td>
			</tr>
		</table>
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr align="left">
				<td id="Text_normal ">Entscheidung zur unten beschriebenen Änderung</td>
			</tr>
			<tr height="10">
				<td/>
			</tr>
			<tr>
				<td width="15%" id="Titel">Die Änderungen sollen durchgeführt werden</td>
				<!--td width="85%" id="Titel">BGS Limit</td-->
			</tr>
			<tr>
				<td width="15%">
					<font id="Aktuell">
						<xsl:if test="zks:Quittung/zks:IndicatorEntscheidung = 'true'">
							Ja
						</xsl:if>
						<xsl:if test="zks:Quittung/zks:IndicatorEntscheidung = 'false'">
							Nein
						</xsl:if>
					</font>
				</td>
				<!--td width="85%">
					<font id="Aktuell">
						<xsl:value-of select="zks:Quittung/zks:BGSNrLimit"/>
					</font>
				</td-->
			</tr>
		</table>
		<table id="tabelle_nicht_oben_unten" width="100%" border="0">
			<tr>
				<td width="100%" id="Titel">Bemerkungen</td>
			</tr>
			<tr>
				<td width="100%">
					<font id="Aktuell">
						<xsl:value-of select="zks:Quittung/zks:Bemerkung"/>
					</font>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile3">
		<table id="tabelle_oben" width="100%" border="0">
			<tr height="10">
				<td/>
			</tr>
			<tr align="left">
				<td id="Text_normal"> Antragsteller </td>
			</tr>
		</table>
		<xsl:for-each select="zks:Antragsteller">
			<table id="tabelle_nicht_unten" width="100%" border="0">
				<!--tr align="left">
					<td id="Text_normal "> Antragsteller </td>
				</tr>
				<tr height="10">
					<td/>
				</tr-->
				<tr width="100%">
					<td width="25%" id="Titel"> Beh&#246;rdliche Nummer </td>
				</tr>
				<tr width="100%">
					<td width="25%">
						<font id="Aktuell">
							<xsl:value-of select="zks:BehoerdlicheNummer"/>
							<xsl:value-of select="zks:Pruefziffer"/>
							&#173;
							<xsl:value-of select="@lib:ATBRolle"/>
						</font>
					</td>
				</tr>
			</table>
			<xsl:call-template name="NameUndAdresse">
				<xsl:with-param name="prefix" select="zks:NameUndAdresse"/>
				<xsl:with-param name="table_width" select="40"/>
			</xsl:call-template>
			<xsl:call-template name="Ansprechpartner">
				<xsl:with-param name="prefix" select="zks:Ansprechpartner"/>
				<xsl:with-param name="table_width" select="40"/>
			</xsl:call-template>
			<table id="tabelle_nicht_oben_unten" width="100%">
				<tr width="100%">
					<td width="33%" id="Titel">Loginname</td>
					<td width="67%" id="Titel">Passwort</td>
				</tr>
				<tr width="100%">
					<td width="33%">
						<font id="Aktuell">
							<xsl:value-of select="zks:LoginName"/>
						</font>
					</td>
					<td width="67%">
						<font id="Aktuell">
							<xsl:value-of select="zks:LoginPasswd"/>
						</font>
					</td>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="Zeile4">
		<table id="tabelle_oben" width="100%" border="0">
			<tr height="10">
				<td/>
			</tr>
			<tr align="left">
				<td id="Text_normal"> Beantragte Änderungen </td>
			</tr>
		</table>
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<!--tr align="left">
				<td id="Text_normal "> Antragsobjekte </td>
			</tr>
			<tr height="10">
				<td/>
			</tr-->
			<tr width="100%">
				<td width="50%" id="Titel">&#196;nderung</td>
				<td width="35%" id="Titel">&#196;nderungsart</td>
				<td width="15%" id="Titel">als Standardpostfach</td>
			</tr>
			<xsl:for-each select="zks:Quittung/zks:Antragsobjekt">
				<tr align="left">
					<td width="50%" id="Aktuell">
						<xsl:variable name="OBJEKT">
							<xsl:choose>
								<xsl:when test="zks:Objekt = 'ZKSPF'">
									<xsl:value-of select="'Empfang von Nachweisdokumenten über Postfach mit beigefügtem Zertifikat'"/>
								</xsl:when>
								<xsl:when test="zks:Objekt = 'LeANV'">
									<xsl:value-of select="'Empfang von Nachweisdokumenten über Länder-eANV'"/>
								</xsl:when>
								<xsl:when test="zks:Objekt = 'BehNr'">
									<xsl:value-of select="'Behördliche Nummmer'"/>
								</xsl:when>
								<xsl:when test="zks:Objekt = 'BtrDat'">
									<xsl:value-of select="'Angaben zu Hauptsitz, Betriebsstätte und Ansprechpartner'"/>
								</xsl:when>
								<xsl:when test="zks:Objekt = 'PassWd'">
									<xsl:value-of select="'Angaben zum Konto'"/>
								</xsl:when>
								<xsl:when test="zks:Objekt = 'Provider'">
									<xsl:value-of select="'Provider'"/>
								</xsl:when>
							</xsl:choose>
							<xsl:if test="string-length(zks:Objekt/@lib:ATBRolle) > 0">
								<xsl:value-of select="' ('"/>
								<xsl:value-of select="zks:Objekt/@lib:ATBRolle"/>
								<xsl:value-of select="')'"/>
							</xsl:if>
						</xsl:variable>
						<xsl:value-of select="$OBJEKT"/>
						<!--xsl:value-of select="zks:Objekt"/>
						<xsl:if test="string-length(zks:Objekt/@lib:ATBRolle) > 0">
							<xsl:value-of select="' ('"/>
							<xsl:value-of select="zks:Objekt/@lib:ATBRolle"/>
							<xsl:value-of select="')'"/>
						</xsl:if-->
					</td>
					<td width="35%" id="Aktuell">
						<xsl:variable name="AENDERUNG">
							<xsl:choose>
								<xsl:when test="@zks:Aenderung = 'I'">
									<xsl:choose>
										<xsl:when test="zks:Objekt = 'ZKSPF' or zks:Objekt = 'LeANV'">
											<xsl:value-of select="'soll genutzt werden'"/>
										</xsl:when>
										<xsl:when test="zks:Objekt = 'BehNr'">
											<xsl:value-of select="'Beantragung einer Betriebsnummer'"/>
										</xsl:when>
										<xsl:when test="zks:Objekt = 'BtrDat'">
											<xsl:value-of select="'Neuregistrierung der Betriebsstätte'"/>
										</xsl:when>
										<xsl:when test="zks:Objekt = 'PassWd'">
											<xsl:value-of select="'Einrichtung eines neuen Kontos'"/>
										</xsl:when>
										<xsl:when test="zks:Objekt = 'Provider'">
											<xsl:value-of select="@zks:Aenderung"/>
										</xsl:when>
									</xsl:choose>
								</xsl:when>
								<xsl:when test="@zks:Aenderung = 'U'">
									<xsl:choose>
										<xsl:when test="zks:Objekt = 'ZKSPF' or zks:Objekt = 'LeANV'">
											<xsl:value-of select="'Änderung der Eigenschaft Standardpostfach'"/>
										</xsl:when>
										<xsl:when test="zks:Objekt = 'BehNr'">
											<xsl:value-of select="'nicht zulässige Änderung'"/>
										</xsl:when>
										<xsl:when test="zks:Objekt = 'BtrDat'">
											<xsl:value-of select="'Änderungen der Angaben'"/>
										</xsl:when>
										<xsl:when test="zks:Objekt = 'PassWd'">
											<xsl:value-of select="'Vergabe einen neuen Passwortes'"/>
										</xsl:when>
										<xsl:when test="zks:Objekt = 'Provider'">
											<xsl:value-of select="@zks:Aenderung"/>
										</xsl:when>
									</xsl:choose>
								</xsl:when>
								<xsl:when test="@zks:Aenderung = 'D'">
									<xsl:choose>
										<xsl:when test="zks:Objekt = 'ZKSPF' or zks:Objekt = 'LeANV'">
											<xsl:value-of select="'soll nicht mehr genutzt werden'"/>
										</xsl:when>
										<xsl:when test="zks:Objekt = 'BehNr'">
											<xsl:value-of select="'Löschung der Registrierung des Betriebes'"/>
										</xsl:when>
										<xsl:when test="zks:Objekt = 'BtrDat'">
											<xsl:value-of select="'Löschung der Registrierung des Betriebes'"/>
										</xsl:when>
										<xsl:when test="zks:Objekt = 'PassWd'">
											<xsl:value-of select="'Löschung des Kontos'"/>
										</xsl:when>
										<xsl:when test="zks:Objekt = 'Provider'">
											<xsl:value-of select="@zks:Aenderung"/>
										</xsl:when>
									</xsl:choose>
								</xsl:when>
							</xsl:choose>
						</xsl:variable>
						<xsl:value-of select="$AENDERUNG"/>
					</td>
					<td width="15%" id="Aktuell">
						<xsl:if test="zks:IndicatorDefault = 'true'">
							Ja
						</xsl:if>
						<xsl:if test="zks:IndicatorDefault = 'false'">
							Nein
						</xsl:if>
					</td>
				</tr>
			</xsl:for-each>
		</table>
	</xsl:template>
	<xsl:template name="Zeile5">
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr align="left">
				<td id="Text_normal "> Firma</td>
			</tr>
			<tr height="10">
				<td/>
			</tr>
		</table>
		<xsl:call-template name="NameUndAdresse">
			<xsl:with-param name="prefix" select="zks:Quittung/zks:FirmaBetreiberKoerperschaft"/>
			<xsl:with-param name="table_width" select="40"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="Zeile6">
		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr align="left">
				<td id="Text_normal "> Betrieb </td>
			</tr>
			<tr height="10">
				<td/>
			</tr>
			<tr width="100%">
				<td width="100%" id="Titel"> Beh&#246;rdliche Nummer </td>
			</tr>
			<tr width="100%">
				<td width="100%">
					<font id="Aktuell">
						<xsl:value-of select="zks:Quittung/zks:BehoerdlicheNummerBtr/lib:BehoerdlicheNr"/>
						<xsl:value-of select="zks:Quittung/zks:BehoerdlicheNummerBtr/lib:Pruefziffer"/>
						&#173;
						<xsl:value-of select="zks:Quittung/zks:BehoerdlicheNummerBtr/@lib:ATBRolle"/>
					</font>
				</td>
			</tr>
		</table>
		<xsl:call-template name="NameUndAdresse">
			<xsl:with-param name="prefix" select="zks:Quittung/zks:Betrieb"/>
			<xsl:with-param name="table_width" select="40"/>
		</xsl:call-template>
		<xsl:call-template name="Ansprechpartner">
			<xsl:with-param name="prefix" select="zks:Quittung/zks:Ansprechpartner"/>
			<xsl:with-param name="table_width" select="40"/>
		</xsl:call-template>

		<table id="tabelle_nicht_unten" width="100%" border="0">
			<tr height="10">
				<td/>
			</tr>
			<tr width="100%">
				<td width="100%" id="Titel"> Kontoinhabernummer </td>
			</tr>
			<tr width="100%">
				<td width="100%">
					<font id="Aktuell">
						<xsl:value-of select="zks:Quittung/zks:ProviderNummer/lib:BehoerdlicheNr"/>
						<xsl:value-of select="zks:Quittung/zks:ProviderNummer/lib:Pruefziffer"/>
						&#173;
						<xsl:value-of select="zks:Quittung/zks:ProviderNummer/@lib:ATBRolle"/>
					</font>
				</td>
			</tr>
		</table>
		<table id="tabelle_nicht_oben_unten" width="100%">
			<tr width="100%">
				<td width="33%" id="Titel">Loginname</td>
				<td width="67%" id="Titel">Passwort</td>
			</tr>
			<tr width="100%">
				<td width="33%">
					<font id="Aktuell">
						<xsl:value-of select="zks:Quittung/zks:LoginName"/>
					</font>
				</td>
				<td width="67%">
					<font id="Aktuell">
						<xsl:value-of select="zks:Quittung/zks:LoginPasswd"/>
					</font>
				</td>
			</tr>
		</table>
		<table id="tabelle_oben" width="100%">
			<tr width="100%">
				<td width="100%">
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="Zeile7">
	</xsl:template>
	<xsl:template name="AnhangZKS">
		<xsl:choose>
			<xsl:when test="//zks:Quittung/zks:Dateianhang">
				<table width="100%" cellspacing="15" cellpadding="15">
					<tr>
						<td>
							<font id="Nummer2">Folgende Dokumente wurden angehängt:</font>
							<br/>
							<br/>
							<ul>
								<xsl:for-each select="//zks:Quittung/zks:Dateianhang">
									<font id="Text_normal">
										<li>
											<xsl:value-of select="@lib:dateiname"/>
										</li>
									</font>
								</xsl:for-each>
							</ul>
						</td>
					</tr>
				</table>
			</xsl:when>
			<xsl:otherwise>
				<table width="100%" cellspacing="15" cellpadding="15">
					<tr>
						<td>
							<font id="Nummer2">Das Dokument hat keine Anhänge.</font>
						</td>
					</tr>
				</table>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
