<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:dyn="http://exslt.org/dynamic"
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:math="http://exslt.org/math"
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
	xmlns:en="uri:BMU_Waste_Interface/EN" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#"
	xmlns:xalan="http://xml.apache.org/xalan"
	extension-element-prefixes="dyn math" 
	exclude-result-prefixes="xsl dyn math lib en ds">
	<xsl:import href="ZKS-Library.xsl"/>
	<xsl:output method="html"/>
	<!-- bei neuladen übergebene Parameter -->
	<xsl:param name="positionsnummer" select="1"/>
	<xsl:param name="layerName" select="'ENSNErzLayer'"/>
	<xsl:param name="layerID" select="'ERZ-01-e6f6d730-0dbe-45b7-857c-0b7474c9ee07'"/>
	<xsl:template match="/">
		<html>
			<head>
				<title>Entsorgungsnachweis/Sammelentsorgungsnachweis</title>
				<!-- CSS - Datei -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf"/>
				<xsl:call-template name="VE"/>
				<xsl:call-template name="showSigLayer"/>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="VE">
		<!--xsl:for-each select="//*[@lib:LayerID=$layerID]"-->
		<xsl:for-each select="//*[(starts-with(local-name(), 'ENSN')) and (contains(local-name(), 'Layer'))]">
			<xsl:if test="position()=$positionsnummer">
				<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
					<tr>
						<td/>
					</tr>
					<tr>
						<td>
							<div id="Nummer" align="right">Verantwortliche Erkl&#228;rung (1)</div>
							<table id="tabelle_nicht_unten" width="100%">
								<xsl:call-template name="ESNKopfNummern"/>
								<tr>
									<td>
										<font id="Nummer">
											Verantwortliche Erkl&#228;rung
										</font>
										<font id="Ueberschrift2">
											(<xsl:value-of select="concat(local-name(),': ',@lib:LayerID)"/>)								
										</font>
									</td>
								</tr>
							</table>
							<table width="100%" id="tabelle_nicht_unten">
								<colgroup>
									<col width="91%"/>
									<col width="9%"/>
								</colgroup>
								<tr>
									<td>
										<table width="100%">
											<tr>
												<td id="Ueberschrift2" width="5">1</td>
												<td id="Ueberschrift2" width="98%">
                                                        Abfallherkunft (nicht ausf&#252;llen bei Sammelentsorgung)                                                      
                                                         </td>
											</tr>
											<tr height="2%">
												<td width="5"/>
												<td width="98%"/>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="30%">Erzeugernummer</td>
															<td id="titel" width="70%">Arbeitsstättennummer</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">1.1</td>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="30%">
																<!-- Erzeugernummer -->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Erzeugernummer/lib:BehoerdlicheNr'"/>
																</xsl:call-template>
																&#160;
																 <!-- Prüfziffer-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Erzeugernummer/lib:Pruefziffer'"/>
																</xsl:call-template>
															</td>
															<td width="70%">
																<!-- Arbeitsstättennummer -->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Arbeitsstaettennummer'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">Betriebsst&#228;tte, sonstige ortsfeste Einrichtung, bauliche Anlage, Grundst&#252;ck oder davon betrieblich unabh&#228;ngige ortsver&#228;nderliche technische Einrichtung</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">1.2</td>
												<td width="98%">
													<!-- Betriebsstätte 1-->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Betriebsstaette/lib:Name/lib:Name1'"/>
													</xsl:call-template>
													&#173;
													 <!-- Betriebsstätte 2-->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Betriebsstaette/lib:Name/lib:Name2'"/>
													</xsl:call-template>
													&#173;
													 <!-- Betriebsstätte 3-->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Betriebsstaette/lib:Name/lib:Name3'"/>
													</xsl:call-template>
													&#173;
													 <!-- Betriebsstätte 4-->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Betriebsstaette/lib:Name/lib:Name4'"/>
													</xsl:call-template>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="88%">Straße oder Koordinaten</td>
															<td id="titel" width="10%">Hausnummer</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">1.3</td>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="88%">
																<!--  Strasse 1-->
																<xsl:call-template name="getTextValuePostfach">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Betriebsstaette/lib:Adresse/lib:Strasse_1'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Betriebsstaette/lib:Postfach/lib:Postfach'"/>
																</xsl:call-template>
																			 &#173;
																<!-- Erzeuger - Strasse 2-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Betriebsstaette/lib:Adresse/lib:Strasse_2'"/>
																</xsl:call-template>
																&#160;
																<xsl:if test="count(en:VE/en:Abfallherkunft/en:Erzeuger/en:Koordinaten) > 0 or count(descendant::en:VE/en:Abfallherkunft/en:Erzeuger/en:Koordinaten) > 0">
																	<font id="titel">Koordinaten: </font>
																</xsl:if>
																&#160;
																<!-- Koordinaten Hochwert-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Koordinaten/lib:Hochwert'"/>
																</xsl:call-template>
																&#160;
																<!-- Koordinaten Rechtswert-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Koordinaten/lib:Rechtswert'"/>
																</xsl:call-template>
																&#160;
																<!-- Koordinaten NummerTopoKarte-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Koordinaten/lib:NummerTopoKarte'"/>
																</xsl:call-template>
															</td>
															<td width="10%">
																<!-- Beförderer- Hausnummer-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Betriebsstaette/lib:Adresse/lib:Hausnummer'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">1.4</td>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="30%">
																<!-- Erzeuger Postleitzahl -->
																<xsl:call-template name="getTextValuePostfach">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Betriebsstaette/lib:Adresse/lib:Postleitzahl'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Betriebsstaette/lib:Postfach/lib:Postleitzahl'"/>
																</xsl:call-template>
															</td>
															<td width="70%">
																<!-- Erzeuger Ort1-->
																<xsl:call-template name="getTextValuePostfach">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Betriebsstaette/lib:Adresse/lib:Ort_1'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Betriebsstaette/lib:Postfach/lib:Ort_1'"/>
																</xsl:call-template>					 
																&#173;
																<!-- Erzeuger Ort2-->
																<xsl:call-template name="getTextValuePostfach">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Betriebsstaette/lib:Adresse/lib:Ort_2'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Betriebsstaette/lib:Postfach/lib:Postfach/lib:Ort_2'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">Ansprechpartner</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">1.5</td>
												<td width="98%">
													<!--  Ansprechpartner - Name-->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Ansprechpartner/lib:Name'"/>
													</xsl:call-template>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="30%">Telefon</td>
															<td id="titel" width="70%">Telefax</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">1.6</td>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="30%">
																<!-- Erzeuger Ansprechpartner - Telefon-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Ansprechpartner/lib:Telefon'"/>
																</xsl:call-template>
															</td>
															<td width="70%">
																<!-- Erzeuger Ansprechpartner - Telefax-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Ansprechpartner/lib:Telefax'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">E-Mail-Adresse</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">1.7</td>
												<td width="98%">
													<!-- Erzeuger Ansprechpartner - E-Mail-->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Ansprechpartner/lib:EMail'"/>
													</xsl:call-template>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">Bezeichnung der Anfallstelle</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">1.8</td>
												<td width="98%">
													<!--  Bezeichnung der Anfallstelle 1-->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Anfallstelle/en:Bezeichnung1'"/>
													</xsl:call-template>
													&#173;
													 <!--  Bezeichnung der Anfallstelle 2-->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:Anfallstelle/en:Bezeichnung2'"/>
													</xsl:call-template>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%"/>
											</tr>
											<tr>
												<td valign="top" id="Ueberschrift2" width="5">1.9</td>
												<td width="98%">
													<!--BlmSchG-->
													<table width="100%">
														<tr>
															<td>
																<table id="Tabelle_unten" width="80%">
																	<tr>
																		<td id="Ueberschrift2" width="10%"> Index 	</td>
																		<td id="Ueberschrift2" width="45%"> Anlage ist nach BlmSchG, Nr. 	</td>
																		<td id="Ueberschrift2" width="45%"> des Anhangs zur 4. BlmSchV, 	genehmigt.</td>
																	</tr>
																</table>
																 <!--  BlmSchG-->
																<xsl:call-template name="getBImSchV">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Erzeuger/en:BImSchG'"/>
																</xsl:call-template>
															</td>
														</tr>
														<tr height="20">
															<th/>
														</tr>
													</table>
													<!--Ende BlmSchG-->
												</td>
											</tr>
										</table>
									</td>
									<td height="100%" id="tabelle_links">
										<table height="100%" width="100%">
											<tr height="3%">
												<td id="Ueberschrift2"> F&#252;r interne Vermerke der Behörde   </td>
											</tr>
											<tr height="97%">
												<td/>
											</tr>
										</table>
									</td>
								</tr>
							</table>
							<table width="100%" id="tabelle">
								<colgroup>
									<col width="91%"/>
									<col width="9%"/>
								</colgroup>
								<tr>
									<td>
										<table width="100%">
											<tr>
												<td id="Ueberschrift2" width="5">2</td>
												<td id="Ueberschrift2" width="98%">Abfallherkunft (nur ausf&#252;llen bei Sammelentsorgung)</td>
											</tr>
											<tr height="5">
												<td width="5"/>
												<td width="98%"/>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">Bundesland / Bundesl&#228;nder in dem / denen der Abfall eingesammelt wird</td>
											</tr>
											<tr>
												<td valign="top" id="Ueberschrift2" width="5">2.1</td>
												<td width="98%">
													<!-- Bundesland -->
													<table width="100%">
														<tr>
															<td>
																<table id="Tabelle_unten" width="90%">
																	<tr>
																		<td id="Ueberschrift2" width="10%">Index</td>
																		<td id="Ueberschrift2" width="15%">Bundesland</td>
																		<td id="Ueberschrift2" width="25%">Kreiskennung</td>
																		<td id="Ueberschrift2" width="50%">Kreis</td>
																	</tr>
																</table>
																<xsl:call-template name="Bundeslaender">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Sammelgebiet/en:Bundesland'"/>
																</xsl:call-template>
															</td>
														</tr>
														<tr height="20">
															<th/>
														</tr>
													</table>
													<!--Ende Bundesland-->
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="30%">Beförderernummer</td>
															<td id="titel" width="70%">Arbeitsstättennummer</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">2.2</td>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="30%">
																<!-- Beförderer Beförderernummer -->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Befoerderernummer/lib:BehoerdlicheNr'"/>
																</xsl:call-template>
																&#160;
																 <!-- Prüfziffer-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Befoerderernummer/lib:Pruefziffer'"/>
																</xsl:call-template>
															</td>
															<td width="70%">
																<!-- Arbeitsstättennummer -->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Arbeitsstaettennummer'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">Name</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">2.3</td>
												<td width="98%">
													<!-- Beförderer Betriebsstätte 1-->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Betriebsstaette/lib:Name/lib:Name1'"/>
													</xsl:call-template>
													&#173;
													 <!-- Beförderer Betriebsstätte 2-->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Betriebsstaette/lib:Name/lib:Name2'"/>
													</xsl:call-template>
													&#173;
													 <!-- Beförderer Betriebsstätte 3-->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Betriebsstaette/lib:Name/lib:Name3'"/>
													</xsl:call-template>
													&#173;
													 <!-- Beförderer Betriebsstätte 4-->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Betriebsstaette/lib:Name/lib:Name4'"/>
													</xsl:call-template>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="88%">Straße oder Koordinaten</td>
															<td id="titel" width="10%">Hausnummer</td>
														</tr>
													</table>
												</td>
												<!--td id="titel" width="98%">Straße oder Koordinaten</td-->
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">2.4</td>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="88%">
																<!--  Beförderer Strasse 1-->
																<xsl:call-template name="getTextValuePostfach">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Betriebsstaette/lib:Adresse/lib:Strasse_1'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Betriebsstaette/lib:Postfach/lib:Postfach'"/>
																</xsl:call-template>
																			 &#173;
																<!-- Beförderer- Strasse 2-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Betriebsstaette/lib:Adresse/lib:Strasse_2'"/>
																</xsl:call-template>
																&#160;
																<xsl:if test="count(en:VE/en:Abfallherkunft/en:Sammler/en:Koordinaten) > 0 or count(descendant::en:VE/en:Abfallherkunft/en:Sammler/en:Koordinaten) > 0">
																	<font id="titel">Koordinaten: </font>
																</xsl:if>
																&#160;
																<!-- Koordinaten Hochwert-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Koordinaten/lib:Hochwert'"/>
																</xsl:call-template>
																&#160;
																<!-- Koordinaten Rechtswert-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Koordinaten/lib:Rechtswert'"/>
																</xsl:call-template>
																&#160;
																<!-- Koordinaten NummerTopoKarte-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Koordinaten/lib:NummerTopoKarte'"/>
																</xsl:call-template>
															</td>
															<td width="10%">
																<!-- Beförderer- Hausnummer-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Betriebsstaette/lib:Adresse/lib:Hausnummer'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="30%">Postleitzahl</td>
															<td id="titel" width="70%">Ort</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">2.5</td>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="30%">
																<!-- BefördererPostleitzahl -->
																<xsl:call-template name="getTextValuePostfach">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Betriebsstaette/lib:Adresse/lib:Postleitzahl'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Betriebsstaette/lib:Postfach/lib:Postleitzahl'"/>
																</xsl:call-template>
															</td>
															<td width="70%">
																<!-- BefördererOrt1-->
																<xsl:call-template name="getTextValuePostfach">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Betriebsstaette/lib:Adresse/lib:Ort_1'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Betriebsstaette/lib:Postfach/lib:Ort_1'"/>
																</xsl:call-template>					 
																&#173;
																<!-- BefördererOrt2-->
																<xsl:call-template name="getTextValuePostfach">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Betriebsstaette/lib:Adresse/lib:Ort_2'"/>
																	<xsl:with-param name="TagNamePostfach" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Betriebsstaette/lib:Postfach/lib:Postfach/lib:Ort_2'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">Ansprechpartner</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">2.6</td>
												<td width="98%">
													<!--  Beförderer Ansprechpartner - Name-->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Ansprechpartner/lib:Name'"/>
													</xsl:call-template>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td width="98%">
													<table width="100%">
														<tr>
															<td id="titel" width="30%">Telefon</td>
															<td id="titel" width="70%">Telefax</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">2.7</td>
												<td width="98%">
													<table width="100%">
														<tr>
															<td width="30%">
																<!-- Beförderer Ansprechpartner - Telefon-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Ansprechpartner/lib:Telefon'"/>
																</xsl:call-template>
															</td>
															<td width="70%">
																<!-- Beförderer Ansprechpartner - Telefax-->
																<xsl:call-template name="getTextValue">
																	<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Ansprechpartner/lib:Telefax'"/>
																</xsl:call-template>
															</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td width="5"/>
												<td id="titel" width="98%">E-Mail-Adresse</td>
											</tr>
											<tr>
												<td id="Ueberschrift2" width="5">2.8</td>
												<td width="98%">
													<!--  Beförderer - EMail-->
													<xsl:call-template name="getTextValue">
														<xsl:with-param name="TagName" select="'en:VE/en:Abfallherkunft/en:Sammler/en:Ansprechpartner/lib:EMail'"/>
													</xsl:call-template>
												</td>
											</tr>
										</table>
									</td>
									<td height="100%" id="tabelle_links">
										<table height="100%" width="100%">
											<tr height="3%">
												<td id="Ueberschrift2"> </td>
											</tr>
											<tr height="97%">
												<td/>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="getBImSchV">
		<xsl:param name="TagName"/>

		<xsl:variable name="sortedBIMSCHV">
			<xsl:for-each select="descendant::en:BImSchG">
				<xsl:sort select="@lib:Index" data-type="number" order="ascending"/>
				<xsl:copy-of select="."/>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="source" select="."/>
		<xsl:for-each select="xalan:nodeset($sortedBIMSCHV)/*">
			<xsl:message>Index:<xsl:value-of select="@lib:Index"/>, preceding Index:<xsl:value-of select="preceding-sibling::en:BImSchG[1]/@lib:Index"/>, position <xsl:value-of select="position()"/></xsl:message>
			<xsl:if test="position()=1 or not(@lib:Index=preceding-sibling::en:BImSchG[1]/@lib:Index)">
				<xsl:variable name="index" select="@lib:Index"/>
				<xsl:for-each select="$source">
					<xsl:call-template name="BIMSCHV">
						<xsl:with-param name="index" select="$index"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:if>
		</xsl:for-each>

		<!--xsl:message>
			Max Index <xsl:value-of select="math:max(//en:BImSchG/@lib:Index)">
			</xsl:value-of>
		</xsl:message-->
		<!--xsl:choose>
			<xsl:when test="boolean(dyn:evaluate($TagName))">
				<xsl:for-each select="dyn:evaluate($TagName)">
					<table id="Tabelle_unten" width="50%">
						<tr>
							<td id="Aktuell" valign="top" width="45%">
								<xsl:value-of select="en:Nummer4BImSchV"/>
							</td>
							<td width="2%"/>
							<td id="Aktuell" valign="top" width="45%">
								<xsl:value-of select="en:Spalte4BImSchV"/>
							</td>
							<td width="9%"/>
						</tr>
					</table>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="boolean(dyn:evaluate(concat('descendant::', $TagName)))">
				<xsl:for-each select="dyn:evaluate(concat('descendant::', $TagName))">
					<table id="Tabelle_unten" width="50%">
						<tr>
							<td id="Text" valign="top" width="45%">
								<xsl:value-of select="en:Nummer4BImSchV"/>
							</td>
							<td width="2%"/>
							<td id="Text" valign="top" width="45%">
								<xsl:value-of select="en:Spalte4BImSchV"/>
							</td>
							<td width="9%"/>
						</tr>
					</table>
				</xsl:for-each>
			</xsl:when>
		</xsl:choose-->
	</xsl:template>

	<xsl:template name="BIMSCHV">
		<xsl:param name="index"/>
		<xsl:choose>
			<xsl:when test="boolean(en:VE/en:Abfallherkunft/en:Erzeuger/en:BImSchG[@lib:Index=$index])">
				<xsl:for-each select="en:VE/en:Abfallherkunft/en:Erzeuger/en:BImSchG[@lib:Index=$index]">
					<table id="Tabelle_unten" width="80%">
						<tr>
							<td id="Aktuell" valign="top" width="10%">
								<xsl:value-of select="@lib:Index"/>
							</td>
							<td id="Aktuell" valign="top" width="45%">
								<xsl:value-of select="en:Nummer4BImSchV"/>
							</td>
							<td width="2%"/>
							<td id="Aktuell" valign="top" width="45%">
								<xsl:value-of select="en:Spalte4BImSchV"/>
							</td>
						</tr>
					</table>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="boolean(descendant::en:VE/en:Abfallherkunft/en:Erzeuger/en:BImSchG[@lib:Index=$index])">
				<xsl:for-each select="descendant::en:BImSchG[@lib:Index=$index][last()]">
					<table id="Tabelle_unten" width="80%">
						<tr>
							<td id="Text" valign="top" width="10%">
								<xsl:value-of select="@lib:Index"/>
							</td>
							<td id="Text" valign="top" width="45%">
								<xsl:value-of select="en:Nummer4BImSchV"/>
							</td>
							<td width="2%"/>
							<td id="Text" valign="top" width="45%">
								<xsl:value-of select="en:Spalte4BImSchV"/>
							</td>
						</tr>
					</table>
				</xsl:for-each>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	
	<xsl:template name="Kreis">
		<xsl:param name="blindex"/>
		<xsl:param name="index"/>
		<xsl:choose>
			<xsl:when test="boolean(en:VE/en:Abfallherkunft/en:Sammler/en:Sammelgebiet/en:Bundesland[@lib:Index=$blindex]/en:Kreis[@lib:Index=$index])">
				<xsl:for-each select="en:VE/en:Abfallherkunft/en:Sammler/en:Sammelgebiet/en:Bundesland[@lib:Index=$blindex]/en:Kreis[@lib:Index=$index]">
					<table width="100%">
						<tr>
							<td id="Aktuell" valign="top" width="10%">
								<xsl:value-of select="@lib:Index"/>
							</td>
							<td id="Aktuell" valign="top" width="90%">
								<xsl:value-of select="."/>
							</td>
						</tr>
					</table>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="boolean(descendant::en:VE/en:Abfallherkunft/en:Sammler/en:Sammelgebiet/en:Bundesland[@lib:Index=$blindex]/en:Kreis[@lib:Index=$index])">
				<xsl:for-each select="descendant::en:Kreis[@lib:Index=$index][parent::en:Bundesland[@lib:Index=$blindex]][last()]">
					<table width="100%">
						<tr>
							<td id="Text" valign="top" width="10%">
								<xsl:value-of select="@lib:Index"/>
							</td>
							<td id="Text" valign="top" width="90%">
								<xsl:value-of select="."/>
							</td>
						</tr>
					</table>
				</xsl:for-each>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="Kreise">
		<xsl:param name="blindex"/>
		<xsl:param name="source"/>
		<xsl:for-each select="$source">
			<!--xsl:message>Source<xsl:value-of select="$source"/></xsl:message-->

			<xsl:variable name="sortedKreis">
				<xsl:for-each select="descendant::en:Kreis[parent::en:Bundesland[@lib:Index=$blindex]]">
					<xsl:sort select="@lib:Index" data-type="number" order="ascending"/>
					<xsl:copy-of select="."/>
				</xsl:for-each>
			</xsl:variable>
			<xsl:for-each select="xalan:nodeset($sortedKreis)/*">
				<!--xsl:message>Index:<xsl:value-of select="@lib:Index"/>, preceding Index:<xsl:value-of select="preceding-sibling::bgs:UNSNummer[1]/@lib:Index"/></xsl:message-->
				<xsl:if test="position()=1 or not(@lib:Index=preceding-sibling::en:Kreis[1]/@lib:Index)">
					<xsl:variable name="index" select="@lib:Index"/>
					<xsl:for-each select="$source">
						<xsl:call-template name="Kreis">
							<xsl:with-param name="index" select="$index"/>
							<xsl:with-param name="blindex" select="$blindex"/>
						</xsl:call-template>
					</xsl:for-each>
				</xsl:if>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="Bundesland">
		<xsl:param name="index"/>
		<!--xsl:message>layer merken</xsl:message-->
		<xsl:variable name="source" select="."/>
		<xsl:choose>
			<xsl:when test="boolean(en:VE/en:Abfallherkunft/en:Sammler/en:Sammelgebiet/en:Bundesland[@lib:Index=$index])">
				<xsl:for-each select="en:VE/en:Abfallherkunft/en:Sammler/en:Sammelgebiet/en:Bundesland[@lib:Index=$index]">
					<table id="Tabelle_unten" width="90%">
						<tr>
							<td id="Aktuell" valign="top" width="10%">
								<xsl:value-of select="@lib:Index"/>
							</td>
							<td id="Aktuell" valign="top" width="15%">
								<xsl:value-of select="en:Name"/>
							</td>
							<!--td id="Aktuell" valign="top" width="25%">
								<xsl:for-each select="en:Kreiskennung">
									<xsl:value-of select="."/>
									<xsl:if test="position() != last()"> / </xsl:if>
								</xsl:for-each>
							</td-->
							<td id="Aktuell" valign="top" width="25%">
								<xsl:for-each select="$source">
									<xsl:variable name="maxKennungen">
										<xsl:for-each select="descendant::en:Bundesland[parent::en:Sammelgebiet][@lib:Index=$index]">
											<xsl:sort order="descending" data-type="number" select="count(en:Kreiskennung)"/>
											<xsl:if test="position()=1">
												<xsl:value-of select="count(en:Kreiskennung)"/>
											</xsl:if>
										</xsl:for-each>
									</xsl:variable>
									<!--xsl:message>maxKennungen: <xsl:value-of select="$maxKennungen"/></xsl:message-->
									<xsl:if test="not($maxKennungen=0)">
										<xsl:call-template name="Kreiskennungen">
											<xsl:with-param name="blindex" select="$index"/>
											<xsl:with-param name="maxIndex" select="$maxKennungen"/>
											<xsl:with-param name="pos" select="1"/>
										</xsl:call-template>
									</xsl:if>
								</xsl:for-each>
							</td>
							<td id="Text" valign="top" width="50%">
								<xsl:call-template name="Kreise">
									<xsl:with-param name="blindex" select="$index"/>
									<xsl:with-param name="source" select="$source"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="boolean(descendant::en:VE/en:Abfallherkunft/en:Sammler/en:Sammelgebiet/en:Bundesland[@lib:Index=$index])">
				<xsl:for-each select="descendant::en:Bundesland[parent::en:Sammelgebiet][@lib:Index=$index][last()]">
					<table id="Tabelle_unten" width="90%">
						<tr>
							<td id="Text" valign="top" width="10%">
								<xsl:value-of select="@lib:Index"/>
							</td>
							<td id="Text" valign="top" width="15%">
								<xsl:value-of select="en:Name"/>
							</td>
							<!--td id="Text" valign="top" width="25%">
								<xsl:for-each select="en:Kreiskennung">
									<xsl:value-of select="."/>
									<xsl:if test="position() != last()"> / </xsl:if>
								</xsl:for-each>
							</td-->
							<td id="Text" valign="top" width="25%">
								<xsl:for-each select="$source">
									<xsl:variable name="maxKennungen">
										<xsl:for-each select="descendant::en:Bundesland[parent::en:Sammelgebiet][@lib:Index=$index]">
											<xsl:sort order="descending" data-type="number" select="count(en:Kreiskennung)"/>
											<xsl:if test="position()=1">
												<xsl:value-of select="count(en:Kreiskennung)"/>
											</xsl:if>
										</xsl:for-each>
									</xsl:variable>
									<!--xsl:message>maxKennungen: <xsl:value-of select="$maxKennungen"/></xsl:message-->
									<xsl:if test="not($maxKennungen=0)">
										<xsl:call-template name="Kreiskennungen">
											<xsl:with-param name="blindex" select="$index"/>
											<xsl:with-param name="maxIndex" select="$maxKennungen"/>
											<xsl:with-param name="pos" select="1"/>
										</xsl:call-template>
									</xsl:if>
								</xsl:for-each>
							</td>
							<td id="Text" valign="top" width="50%">
								<xsl:call-template name="Kreise">
									<xsl:with-param name="blindex" select="$index"/>
									<xsl:with-param name="source" select="$source"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</xsl:for-each>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="Kreiskennungen">
		<!--xsl:param name="source"/-->
		<xsl:param name="blindex"/>
		<xsl:param name="pos"/>
		<xsl:param name="maxIndex"/>
		<xsl:choose>
			<xsl:when test="boolean(en:VE/en:Abfallherkunft/en:Sammler/en:Sammelgebiet/en:Bundesland[@lib:Index=$blindex]/en:Kreiskennung[$pos])">
				<xsl:for-each select="en:VE/en:Abfallherkunft/en:Sammler/en:Sammelgebiet/en:Bundesland[@lib:Index=$blindex]/en:Kreiskennung[$pos]">
					<table width="100%">
						<tr>
							<td id="Aktuell" valign="top" width="10%">
								<xsl:value-of select="$pos"/>
							</td>
							<td id="Aktuell" valign="top" width="90%">
								<xsl:value-of select="."/>
							</td>
						</tr>
					</table>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="boolean(descendant::en:VE/en:Abfallherkunft/en:Sammler/en:Sammelgebiet/en:Bundesland[@lib:Index=$blindex]/en:Kreiskennung[$pos])">
				<xsl:for-each select="descendant::en:VE/en:Abfallherkunft/en:Sammler/en:Sammelgebiet/en:Bundesland[@lib:Index=$blindex]/en:Kreiskennung[$pos]">
					<xsl:if test="position()=last()">
						<table width="100%">
							<tr>
								<td id="Text" valign="top" width="10%">
									<xsl:value-of select="$pos"/>
								</td>
								<td id="Text" valign="top" width="90%">
									<xsl:value-of select="."/>
								</td>
							</tr>
						</table>
					</xsl:if>
				</xsl:for-each>
			</xsl:when>
		</xsl:choose>
		<xsl:if test="not($pos=$maxIndex)">
			<xsl:call-template name="Kreiskennungen">
				<xsl:with-param name="blindex" select="$blindex"/>
				<xsl:with-param name="maxIndex" select="$maxIndex"/>
				<xsl:with-param name="pos" select="$pos + 1"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="Bundeslaender">
		<xsl:param name="TagName"/>
		<!--xsl:message>
			Sammelgebiete <xsl:value-of select="dyn:evaluate($TagName)">
			</xsl:value-of>en:VE/en:Abfallherkunft/en:Sammler/en:Sammelgebiet/en:Bundesland
		</xsl:message-->
		<xsl:variable name="sortedBL">
			<xsl:for-each select="descendant::en:Bundesland[parent::en:Sammelgebiet]">
				<xsl:sort select="@lib:Index" data-type="number" order="ascending"/>
				<xsl:copy-of select="."/>
			</xsl:for-each>
		</xsl:variable>

		<xsl:variable name="source" select="."/>
		<xsl:for-each select="xalan:nodeset($sortedBL)/*">
			<!--xsl:message>Index:<xsl:value-of select="@lib:Index"/>, preceding Index:<xsl:value-of select="preceding-sibling::bgs:UNSNummer[1]/@lib:Index"/></xsl:message-->
			<xsl:if test="position()=1 or not(@lib:Index=preceding-sibling::en:Bundesland[1]/@lib:Index)">
				<xsl:variable name="index" select="@lib:Index"/>
				<xsl:for-each select="$source">
					<xsl:call-template name="Bundesland">
						<xsl:with-param name="index" select="$index"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
