/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.config.schema.fxs;

import de.consist.bmu.rule.RuleFactory;
import de.consist.bmu.rule.config.schema.fxs.FXSSCHEMATYPE;
import de.consist.bmu.rule.schema.LSInputImpl;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class FXSSchemaResourceResolver
implements LSResourceResolver {
    private static final Log LOGGER = LogFactory.getLog(FXSSchemaResourceResolver.class);
    private List<FXSSCHEMATYPE> _fxsSchemaList;

    public FXSSchemaResourceResolver(List<FXSSCHEMATYPE> fxsSchemaList) {
        this._fxsSchemaList = fxsSchemaList;
    }

    public final LSInput resolveResource(String publicId, String systemId, String baseURI) {
        return this.resolveResource(null, null, publicId, systemId, baseURI);
    }

    @Override
    public final LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        LOGGER.debug((Object)("trying to resolve: type=" + type + ", publicId=" + publicId + ", systemId=" + systemId + ", baseURI=" + baseURI + ", namespaceUR\u00cc=" + namespaceURI));
        LSInputImpl lsInput = new LSInputImpl();
        URL url = null;
        try {
            if (systemId != null) {
                if ("http://www.w3.org/2001/XMLSchema.dtd".equals(systemId)) {
                    url = this.getClass().getResource("/de/consist/bmu/schema-1.04a/2001/XMLSchema.dtd");
                } else {
                    try {
                        url = new URL(systemId);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
            if (url == null) {
                for (FXSSCHEMATYPE fxsschematype : this._fxsSchemaList) {
                    String nsURI = fxsschematype.getNSUri();
                    if (!nsURI.equals(systemId) && !nsURI.equals(publicId) && !nsURI.equals(namespaceURI)) continue;
                    File schemaFile = new File(fxsschematype.getLocation());
                    if (!schemaFile.exists() && !schemaFile.isAbsolute()) {
                        schemaFile = new File(RuleFactory.getInstance().getFxsSchemaBaseDir(), fxsschematype.getLocation());
                    }
                    if (!schemaFile.exists()) break;
                    url = schemaFile.toURI().toURL();
                    break;
                }
            }
            if (url == null && systemId != null) {
                url = new File(RuleFactory.getInstance().getFxsSchemaBaseDir(), systemId).toURI().toURL();
            }
            if (url == null) {
                LOGGER.error((Object)("unable to resolve: systemId=" + systemId + ", pubicId=" + publicId + ", namespaceURI=" + namespaceURI));
            } else {
                LOGGER.debug((Object)("resolved: " + url.toExternalForm()));
                lsInput.setByteStream(url.openStream());
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error resolving resource: " + (url != null ? url.getPath() : "null")), (Throwable)e);
        }
        return lsInput;
    }
}

