/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.schema.Namespace;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class RuleImplUNSBefLfdNr
extends RuleImpl {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(RuleImplUNSBefLfdNr.class);
    private static final String[] XPATH_UNS_BEFLFDNR = new String[]{"/descendant::bgs:UNSBasisLayer[@lib:ATBRolle='BEF']", "/descendant::bgs:UNSErgaenzungsLayer[@lib:ATBRolle='BEF']"};

    public RuleImplUNSBefLfdNr(RuleDef ruleDef) {
        super(ruleDef);
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        int index = 1;
        for (String xPath : XPATH_UNS_BEFLFDNR) {
            NodeList nl;
            try {
                nl = XPathFassade.getInstance().evaluateNodeList(bmuDok.getDocument(), xPath);
            }
            catch (XPathExpressionException e) {
                throw new BMUException("Fehler beim Pr\u00fcfen", e);
            }
            for (int i = 0; i < nl.getLength(); ++i) {
                Element layer = (Element)nl.item(i);
                String layerID = layer.getAttributeNS(Namespace.TypenBibliothek.getUri(), "LayerID");
                String atbBefLfdNr = layer.getAttributeNS(Namespace.TypenBibliothek.getUri(), "ATBBefLfdNummer");
                if (atbBefLfdNr != null && atbBefLfdNr.length() > 0) {
                    int lfdNr = Integer.parseInt(atbBefLfdNr);
                    if (lfdNr == 1) continue;
                    ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, layerID));
                    continue;
                }
                LOGGER.warn((Object)"Attribut 'ATBBEfLfdNummer' fehlt.");
            }
        }
        return ruleResultList;
    }

    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        builder.append("XPathes f\u00fcr die Ermittlung der Layer: ");
        builder.append(Arrays.deepToString(XPATH_UNS_BEFLFDNR));
        return builder.toString();
    }
}

