/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.util;

import de.consist.bmu.rule.util.XmlUtils;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class DIN_SPEC_91379 {
    private static final Log LOGGER = LogFactory.getLog(DIN_SPEC_91379.class);
    private static final int MAX_STRING_LENGTH = 100;
    private static String datatypeC = null;
    private static Pattern pattern = null;

    private static void init() {
        if (datatypeC == null) {
            try {
                Document doc = XmlUtils.readFromResource("/de/consist/bmu/schema-dt/din-91379-datatypes.xsd", "UTF-8");
                XPathFassade xpf = XPathFassade.getInstance();
                datatypeC = xpf.evaluate(doc, "/xs:schema/xs:simpleType[@name='datatypeC']/xs:restriction/xs:pattern/@value");
                pattern = Pattern.compile(datatypeC, 384);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Fehler bei der Initialisierung", (Throwable)e);
            }
        }
    }

    private static int _matches(String text) {
        int end;
        Matcher matcher;
        int retVal = -1;
        if (pattern != null && (matcher = pattern.matcher(text)).find() && (end = matcher.end()) < text.length()) {
            retVal = end;
        }
        return retVal;
    }

    public static int matches(String text) {
        int retVal = -1;
        DIN_SPEC_91379.init();
        String rest = text;
        int pos = 0;
        while (rest != null) {
            int len = rest.length();
            String text1 = rest.substring(0, Math.min(len, 100));
            retVal = DIN_SPEC_91379._matches(text1);
            if (retVal >= 0) {
                return pos + retVal;
            }
            rest = len > 100 ? rest.substring(100) : null;
            pos += 100;
        }
        return retVal;
    }

    public static String replace(String text, char replacementChar) {
        DIN_SPEC_91379.init();
        StringBuffer buf = new StringBuffer();
        if (pattern != null) {
            Matcher matcher = pattern.matcher(text);
            LOGGER.debug((Object)("text: " + text + ", length: " + text.length()));
            while (matcher.find()) {
                int start = matcher.start();
                int end = matcher.end();
                String group = matcher.group();
                boolean hitEnd = matcher.hitEnd();
                LOGGER.debug((Object)("start: " + start + ", end: " + end + ", group: " + group + ", hitEnd: " + hitEnd));
                if (!group.isEmpty()) {
                    buf.append(group);
                    continue;
                }
                if (hitEnd && end >= text.length()) continue;
                buf.append(replacementChar);
            }
        }
        String retVal = text;
        if (buf.length() > 0) {
            retVal = buf.toString();
        }
        LOGGER.debug((Object)("result: " + retVal + ", length: " + retVal.length()));
        return retVal;
    }

    public static void main(String[] args) {
        String test = "ABCDEFGHIJKLMNOPQRSTUVW1234567890";
        System.out.println(DIN_SPEC_91379.matches(test));
        test = "ABCDEFGHIJKL\u30abMNOPQRSTUVW1234567890ABCDEFGHIJKL\ue053MNOPQRSTUVW1234567890";
        System.out.println(DIN_SPEC_91379.matches(test));
        System.out.println(DIN_SPEC_91379.replace(test, '_'));
        test = "1\u0084\u0084\u0084\u00841";
        System.out.println(DIN_SPEC_91379.matches(test));
        System.out.println(DIN_SPEC_91379.replace(test, '_'));
        test = "\ue053";
        System.out.println(DIN_SPEC_91379.matches(test));
        System.out.println(DIN_SPEC_91379.replace(test, '_'));
    }
}

