/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DateUtils {
    private static final Log LOGGER = LogFactory.getLog(DateUtils.class);
    public static final Date DATE_20150101 = new GregorianCalendar(2015, 0, 1).getTime();
    private static final String DATE_PATTERN = "dd.MM.yyyy";
    private static final String DATE_TIME_PATTERN = "dd.MM.yyyy HH:mm:ss";
    private static final String DATE_TIME_PATTERN_WITH_MILLIS = "dd.MM.yyyy HH:mm:ss.SSS";
    private static final String TIME_PATTERN = "HH:mm:ss";
    private static final String TIME_PATTERN_WITHOUT_SECONDS = "HH:mm";

    private DateUtils() {
    }

    public static String toDateTimeString(Date datum) {
        return DateUtils.toDateTimeString(datum, false);
    }

    public static String toDateTimeString(Date datum, boolean withMillis) {
        return new SimpleDateFormat(withMillis ? DATE_TIME_PATTERN_WITH_MILLIS : DATE_TIME_PATTERN).format(datum);
    }

    public static String toDateString(Date datum) {
        return new SimpleDateFormat(DATE_PATTERN).format(datum);
    }

    public static String toTimeString(Date datum) {
        return DateUtils.toTimeString(datum, true);
    }

    public static String toTimeString(Date datum, boolean withSeconds) {
        if (withSeconds) {
            return new SimpleDateFormat(TIME_PATTERN).format(datum);
        }
        return new SimpleDateFormat(TIME_PATTERN_WITHOUT_SECONDS).format(datum);
    }

    public static Date getDate(String dateString, String pattern) {
        Date date = new Date(0L);
        try {
            date = new SimpleDateFormat(pattern).parse(dateString);
        }
        catch (ParseException e) {
            LOGGER.warn((Object)("Fehler beim parsen: " + dateString + ", pattern=" + pattern), (Throwable)e);
        }
        return date;
    }

    public static Date getDateWithoutTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }
}

