/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2024-02-07 12:06:34 +0000 (Wed, 07 Feb 2024) $ $Rev: 1793 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule;

import java.util.List;

import de.consist.bmu.rule.error.BMUException;

/**
 * Interface fuer eine ausfhrbare Regelmenge.
 * 
 * Sie wird aus einem RuleSetDef erzeugt. Sie ist beliebig oft nutzbar.
 * 
 * @see RuleSetDef
 */
public interface RuleSet {
    /**
     * Fhrt alle aktiven Prfungen auf dem Dokument aus.
     * 
     * Das Dokument wird whrend der Prfung synchronisiert.
     * 
     * @param bmuDok
     *            Das zu pruefende Document
     * @return List Die Liste der Pruefergebnisse
     * @throws BMUException
     *             BMUException
     */
    RuleSetResult execute(BMUDokument bmuDok) throws BMUException;

    /**
     * Fhrt alle aktiven Prfungen auf dem Dokument aus.
     * 
     * Das Dokument wird whrend der Prfung synchronisiert.
     * 
     * @param bmuDok
     *            Das zu pruefende Document
     * @param pruefeNachricht
     *            true, wenn auf 'msg:Nachricht' geprueft werden soll 
     * @return List Die Liste der Pruefergebnisse
     * @throws BMUException
     *             BMUException
     */
    RuleSetResult execute(BMUDokument bmuDok, boolean pruefeNachricht) throws BMUException;

    /**
     * Die Reihenfolge der Regeln in der Liste ist implementierungsabhngig.
     * 
     * @return List Die Liste der Regeln
     */
    List<Rule> getRuleList();
    
    /**
     * Liefert die Regel mit dem angegebenen Namen.
     *  
     * @param name Der Regelname
     * @return Die Regel
     * @deprecated
     */
    @Deprecated
    Rule getRuleByName(String name);
    
    /**
     * @return Die Regeldefinition mit der Bezugsmeldung im Fehlerfall
     */
    RuleDef getRuleDefBezugError();
    
    /**
     * @return Die Regeldefinition mit der Bezugsmeldung im OK-Fall
     */
    RuleDef getRuleDefBezugNoError();

    /**
     * Liefert die Regel mit der angegebenen ID.
     *  
     * @param id Die Id der Regel
     * @return Die Regel
     */
    Rule getRuleById(String id);
}
