/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2024-02-06 14:29:28 +0000 (Tue, 06 Feb 2024) $ $Rev: 1787 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.def;

import java.util.Collections;
import java.util.List;

import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import de.consist.bmu.rule.BMUVersion;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleSetDef;

/**
 * Klasse fuer eine Liste von Regeldefinitionen. Wird mit jaxb als xml
 * serialisiert. Die Regeldefinitionen werden nach folgendem Schema sortiert:
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "rulesetdef", propOrder = { "_version", "_id", "_name",
        "_ruleDefRefOK", "_ruleDefRefError", "_ruleDefList" })
@XmlRootElement(name = "Regelmenge")
public class RuleSetDefImpl implements RuleSetDef {

    private static final Log LOGGER = LogFactory.getLog(RuleSetDefImpl.class);
    /** */
    private static final long serialVersionUID = 1L;

    @XmlElement(name = "Version")
    @XmlJavaTypeAdapter(XmlBMUVersionAdapter.class)
    private BMUVersion _version;
    @XmlElement(name = "Id")
    private String _id;
    @XmlElement(name = "Name")
    private String _name;
    @XmlElement(name = "Bezug_OK", type = RuleDefImpl.class)
    private RuleDef _ruleDefRefOK;
    @XmlElement(name = "Bezug_Fehler", type = RuleDefImpl.class)
    private RuleDef _ruleDefRefError;
    @XmlElement(name = "Regel")
    private List<RuleDef> _ruleDefList;

    /**
     * Konstruktor.
     */
    public RuleSetDefImpl() {
    }

    /**
     * @param id
     *            int
     * @param name
     *            String
     * @param ruleDefRefOK
     *            RuleDef
     * @param ruleDefRefError
     *            RuleDef
     * @param ruleDefList
     *            List
     */
    public RuleSetDefImpl(String id, String name, RuleDef ruleDefRefOK,
            RuleDef ruleDefRefError, List<RuleDef> ruleDefList) {
        this._id = id;
        this._name = name;
        // this._ruleDefList = ruleDefList;
        // Collections.sort(_ruleDefList, new RuleDefImpl.RuleDefComparator());
        setRuleList(ruleDefList);
        this._ruleDefRefOK = ruleDefRefOK;
        this._ruleDefRefError = ruleDefRefError;
        this._version = BMUVersion.V104;
    }

    /**
     * {@inheritDoc}
     */
    public final String getId() {
        return _id;
    }

    /**
     * {@inheritDoc}
     */
    public final void setId(String id) {
        this._id = id;
    }

    /**
     * {@inheritDoc}
     */
    public final String getName() {
        return _name;
    }

    /**
     * {@inheritDoc}
     */
    public final void setName(String name) {
        this._name = name;
    }

    /**
     * {@inheritDoc}
     */
    public final RuleDef getRuleDefRefOK() {
        return _ruleDefRefOK;
    }

    /**
     * {@inheritDoc}
     */
    public final void setRuleDefRefOK(RuleDef ruleDefRefOK) {
        this._ruleDefRefOK = ruleDefRefOK;
    }

    /**
     * {@inheritDoc}
     */
    public final RuleDef getRuleDefRefError() {
        return _ruleDefRefError;
    }

    /**
     * {@inheritDoc}
     */
    public final void setRuleDefRefError(RuleDef ruleDefRefError) {
        this._ruleDefRefError = ruleDefRefError;
    }

    /**
     * {@inheritDoc}
     */
    public final List<RuleDef> getRuleList() {
        return _ruleDefList;
    }

    /**
     * {@inheritDoc}
     */
    public final void setRuleList(List<RuleDef> ruleDefList) {
        this._ruleDefList = ruleDefList;
        Collections.sort(_ruleDefList, new RuleDefImpl.RuleDefComparator());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Rulelist sortiert");
            for (RuleDef rule : _ruleDefList) {
                LOGGER.debug(rule.getName());
            }
        }
    }

    /**
     * {@inheritDoc}
     */
    public final BMUVersion getVersion() {
        return _version;
    }

    /**
     * 
     * {@inheritDoc}
     */
    @Override
    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Version=" + _version);
        builder.append(", Id=" + _id);
        builder.append(", Name=" + _name);
        builder.append(", RuleList=[");
        boolean first = true;
        for (RuleDef ruleDef : _ruleDefList) {
            if (!first) {
                builder.append(",");
            }
            builder.append("{" + ruleDef + "}");
            first = false;
        }
        builder.append("]");
        return builder.toString();
    }

    /**
     * Wird von JAXB nach dem unmarshall aufgerufen..
     * 
     * @param um Der Unmarshaller
     * @param parent Der Parent
     */
    final void afterUnmarshal(Unmarshaller um, Object parent) {
        LOGGER.debug("afterUnmarshall called..");
        Collections.sort(_ruleDefList, new RuleDefImpl.RuleDefComparator());
    }
}
