/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2013-06-28 08:24:11 +0000 (Fri, 28 Jun 2013) $ $Rev: 1091 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.List;

import javax.xml.xpath.XPathExpressionException;

import org.w3c.dom.NodeList;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.xpath.XPathFassade;

/**
 * @author srossbroich
 * 
 */
public final class RuleImplLayerIDSequence extends RuleImpl {

    private static final long serialVersionUID = 1L;

    private static final int LAYERID_SEQUENCE_ENDPOS = 6;
    private static final int LAYERID_SEQUENCE_STARTPOS = 4;

    private static final String XPATH_LAYER = "/descendant::*/@lib:LayerID";
    /**
     * @param ruleDef RuleDef
     */
    public RuleImplLayerIDSequence(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        NodeList nl;
        try {
            nl = XPathFassade.getInstance().evaluateNodeList(bmuDok.getDocument(),
                    XPATH_LAYER);
        } catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Prfen", e);
        }
        int layerIdIndex = 1;
        int index = 1;
        for (int i = nl.getLength() - 1; i >= 0; i--) {
            String layerId = nl.item(i).getTextContent();
            String layerIdSequencePart = layerId.substring(
                    LAYERID_SEQUENCE_STARTPOS, LAYERID_SEQUENCE_ENDPOS);
            int layerIdSequence = Integer.parseInt(layerIdSequencePart);
            if (layerIdSequence != layerIdIndex) {
                ruleResultList.add(new RuleResultImpl(getRuleDef(), index++, layerId));
            }
            layerIdIndex++;
        }
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        return "XPath fr die Ermittlung der LayerID: " + XPATH_LAYER;
    }

}
