/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2013-01-19 01:50:18 +0100 (Sa, 19 Jan 2013) $ $Rev: 978 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.List;

import javax.xml.xpath.XPathExpressionException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.util.XmlUtils;
import de.consist.bmu.rule.xpath.XPathFassade;

/**
 * @author candersen
 * 
 */
public final class RuleImplSchemaNoPrefix extends RuleImpl {

    private static final long serialVersionUID = 1L;

    private static final Log LOGGER = LogFactory.getLog(RuleImplSchemaNoPrefix.class);

    /**
     * XPath fuer Elemente ohne Prfix.
     */
    private static final String XPATH_NO_PREFIX= "//*[namespace-uri()='']";

    /**
     * @param ruleDef
     *            RuleDef
     */
    public RuleImplSchemaNoPrefix(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        NodeList nodeList;
        XPathFassade xpf = XPathFassade.getInstance();
        try {
            nodeList = xpf.evaluateNodeList(
                    bmuDok.getDocument(), XPATH_NO_PREFIX);
            int index = 1;
            for (int i = 0; i<nodeList.getLength();i++) {
                Node node = nodeList.item(i);
                String path = XmlUtils.getNodePathShort(node);                
                ruleResultList.add(new RuleResultImpl(getRuleDef(), index++, path));
                LOGGER.debug("Element ohne Prfix gefunden: " + path);
            }
        } catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Prfen", e);
        }
        return ruleResultList;
    }
    
    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        builder.append("XPath fr die Ermittlung der zu prfenden Inhalte: ");
        builder.append(XPATH_NO_PREFIX);
        return builder.toString();
    }

}
