/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2012-12-10 17:22:57 +0100 (Mo, 10 Dez 2012) $ $Rev: 965 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.List;

import javax.xml.xpath.XPathExpressionException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.SignatureVerificationResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.xmlsec.XmlSecFassade;
import de.consist.bmu.rule.xpath.XPathFassade;

/**
 * @author srossbroich
 * 
 */
public final class RuleImplSignatureKeyInfo extends RuleImpl {

    private static final long serialVersionUID = 1L;

    private static final Log LOGGER = LogFactory
            .getLog(RuleImplSignatureKeyInfo.class);

    private static final String TECHDOC = "Prft den Inhalt von KeyInfo "
            + "(ds:Signature/ds:KeyInfo) in allen Signaturen "
            + "im Dokument auf die Eintraege 'X509Certificate' und 'X509SubjectName', "
            + " diese muessen jeweils genau einmal pro Signatur vorhanden sein und "
            + "das Zertifikat muss zu dem ffentlichen Schlssel im KeyValue passen.";
    /**
     * XPath fuer ds:Signature.
     */
    private static final String XPATH_SIGNATURE = "/descendant::ds:Signature[@Id]";

    /**
     * @param ruleDef
     *            RuleDef
     */
    public RuleImplSignatureKeyInfo(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        XPathFassade xpf = XPathFassade.getInstance();
        NodeList nl;
        try {
            nl = xpf.evaluateNodeList(bmuDok.getDocument(),
                    XPATH_SIGNATURE);
        } catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Prfen", e);
        }
        int index = 1;
        for (int i = 0; i < nl.getLength(); i++) {
            Node sigNode = nl.item(i);
            if (sigNode instanceof Element) {
                Element sigElem = (Element) sigNode;
                String sigID = sigElem.getAttribute("Id");
                SignatureVerificationResult svr = bmuDok.getMessageType()
                        .getSignatureVerificationResult(sigID);
                if (svr.isEnabled(getRuleDef()) && !svr.isEIDAS()) {
	                LOGGER.debug("Prfe X509Certificate in Signatur mit der ID: " + sigID);
	                if (!XmlSecFassade.getInstance().validateX509Certificate(sigElem)) {
	                    String msg = "X509Certificate passt nicht zur Signatur mit der ID: "
	                            + sigID;
	                    LOGGER.debug(msg);
	                    ruleResultList
	                            .add(new RuleResultImpl(this
	                                    .getRuleDef(), index++,
	                                    sigID));
	                }
                }
            }
        }
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        return TECHDOC;
    }

}
