/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2013-06-28 08:24:11 +0000 (Fri, 28 Jun 2013) $ $Rev: 1091 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.BMUMessageType;
import de.consist.bmu.rule.BMUMessageTypeEnum;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.SignatureVerificationResult;
import de.consist.bmu.rule.SignatureVerificationResult.VerificationStatus;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.xmlsec.XmlSecFassade;

/**
 * Pruefregel fuer die Signaturpruefung.
 * 
 * @author srossbroich
 * 
 */
public final class RuleImplSignatureVerification extends RuleImpl {

    private static final long serialVersionUID = 1L;

    private static final Log LOGGER = LogFactory
            .getLog(RuleImplSignatureVerification.class);

    /**
     * @param ruleDef
     *            RuleDef
     */
    public RuleImplSignatureVerification(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        int index = 1;
        BMUMessageType msgType = bmuDok.getMessageType(); 
        if (!BMUMessageTypeEnum.RegisterAuszug.equals(msgType.getEnumType())) {
            for (SignatureVerificationResult svr : bmuDok.getMessageType()
                    .getSignatureVerificationResultList()) {
                try {
                    boolean valid = XmlSecFassade.getInstance()
                            .verifySignature(bmuDok.getDocument(),
                                    svr.getSignatureID());
                    if (valid) {
                        svr.setVerificationStatus(VerificationStatus.VALID);
                    } else {
                        svr.setVerificationStatus(VerificationStatus.INVALID);
                        ruleResultList.add(new RuleResultImpl(
                                this.getRuleDef(), index++, svr
                                        .getSignatureID()));
                    }
                } catch (Exception e) {
                    LOGGER.error("Fehler bei der Prfung der Signatur mit der ID " + svr.getSignatureID(), e);
                    svr.setVerificationStatus(VerificationStatus.INVALID);
                    ruleResultList.add(new RuleResultImpl(this.getRuleDef(),
                            index++, svr.getSignatureID()));
                }
                // List<String> invalidSigIdList = XmlSecFassade.getInstance()
                // .verifySignatures(bmuDok.getDocument());
                // for (String sigId : invalidSigIdList) {
                // ruleResultList.add(new RuleResultImpl(this.getRuleDef(),
                // index++, sigId));
                // }
            }
        }
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        return "Die Signaturen werden mit der xmlsec-Implementierung von apache auf mathematische Unversehrtheit geprft.";
    }

}
