/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2024-02-06 14:29:28 +0000 (Tue, 06 Feb 2024) $ $Rev: 1787 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.io.Serializable;
import java.util.Date;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.SignatureVerificationResult;

/**
 * 
 */
public class SignatureVerificationResultImpl implements
        SignatureVerificationResult, Serializable {

    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(SignatureVerificationResultImpl.class);
    
    private String _signatureID;
    private VerificationStatus _verificationStatus;
    private String _subjectDN;
    private Date _signingTime;
    private boolean _eIDAS;

    /**
     * Default Konstruktor fuer JAXB. 
     */
    public SignatureVerificationResultImpl() {
    }

    /**
     * Adapter fuer JAXB.
     */
    public static class Adapter extends XmlAdapter<SignatureVerificationResultImpl, SignatureVerificationResult> {
        /**
         * {@inheritDoc}
         */
        @Override
        public final SignatureVerificationResult unmarshal(SignatureVerificationResultImpl resultImpl) {
            return resultImpl;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final SignatureVerificationResultImpl marshal(SignatureVerificationResult result) {
            return (SignatureVerificationResultImpl) result;
        }
    }

    /**
     * @param signatureID
     *            Die Signature-ID
     * @param subjectDN
     *            Der Name des Unterzeichners
     * @param signingTime
     *            Der Signaturzeitpunkt
     */
    public SignatureVerificationResultImpl(String signatureID,
            String subjectDN, Date signingTime, boolean eIDAS) {
        _signatureID = signatureID;
        _verificationStatus = VerificationStatus.UNCHECKED;
        _subjectDN = subjectDN;
        _signingTime = signingTime;
        _eIDAS = eIDAS;
    }

    /**
     * {@inheritDoc}
     */
    public final String getSignatureID() {
        return _signatureID;
    }

    /**
     * {@inheritDoc}
     */
    public final VerificationStatus getVerificationStatus() {
        return _verificationStatus;
    }

    /**
     * {@inheritDoc}
     */
    public final void setVerificationStatus(VerificationStatus status) {
        _verificationStatus = status;
    }

    /**
     * {@inheritDoc}
     */
    public final String getSubjectDN() {
        return _subjectDN;
    }

    /**
     * {@inheritDoc}
     */
    public final Date getSigningTime() {
        return _signingTime;
    }
    
    /**
     * {@inheritDoc}
     */
    public final boolean isEIDAS() {
        return _eIDAS;
    }

    /**
     * {@inheritDoc}
     */
    public final boolean isEnabled(RuleDef ruleDef) {
    	boolean retVal = true;
    	LOGGER.trace("<isEnabled> signatureID: " + _signatureID + ", rule: " + ruleDef.getName());
    	if (_verificationStatus == VerificationStatus.UNCHECKED) {
    		LOGGER.trace("Signature was not yet verified !");
    		retVal = false;
    	} else if (ruleDef.getUseSignatureDate()) {
    		if (ruleDef.getKeyDate().after(_signingTime)) {
    			LOGGER.trace("Signing time is before 'valid from'");
    			retVal = false;
    		} else if (ruleDef.getKeyToDate().before(_signingTime)) {
    			LOGGER.trace("Signing time is after 'valid to'");
    			retVal = false;
    		}
    	}
    	LOGGER.trace("<isEnabled> returns " + retVal);
    	return retVal;
    }
}
