package de.consist.bmu.rule.util;

public class XmlElementInfo {

    private String _uri;
    private String _localName;
    
    public XmlElementInfo(String uri, String localName) {
        _uri = uri;
        _localName = localName;
    }
    
    public String get_uri() {
        return _uri;
    }
    
    public String get_localName() {
        return _localName;
    }

    @Override
    public String toString() {
        return "XmlElementInfo [_uri=" + _uri + ", _localName=" + _localName
                + "]";
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result
                + ((_localName == null) ? 0 : _localName.hashCode());
        result = prime * result + ((_uri == null) ? 0 : _uri.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        XmlElementInfo other = (XmlElementInfo) obj;
        if (_localName == null) {
            if (other._localName != null)
                return false;
        } else if (!_localName.equals(other._localName))
            return false;
        if (_uri == null) {
            if (other._uri != null)
                return false;
        } else if (!_uri.equals(other._uri))
            return false;
        return true;
    }
    
}
