/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2013-06-28 08:24:11 +0000 (Fri, 28 Jun 2013) $ $Rev: 1091 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.xpath;

import java.util.Iterator;
import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import java.util.ArrayList;
import java.util.List;

import javax.xml.XMLConstants;
import javax.xml.namespace.NamespaceContext;

/**
 * Generischer NamespaceContext. Vorlage:
 * http://www.oreillynet.com/cs/user/view/cs_msg/55906
 * 
 * @author jannighoefer
 */
public class GenericNamespaceContext implements NamespaceContext {

    private Map<String, String> _map;

    /**
     * Konstruktor.
     */
    public GenericNamespaceContext() {
        _map = new HashMap<String, String>();
    }

    /**
     * @param prefix String
     * @param namespaceURI String
     */
    public final void setNamespace(String prefix, String namespaceURI) {
        _map.put(prefix, namespaceURI);
    }

    /**
     * {@inheritDoc}
     */
    public final String getNamespaceURI(String prefix) {
        Object value = _map.get(prefix);
        if (value == null) {
            return XMLConstants.NULL_NS_URI;
        }
        return (String) value;
    }

    /**
     * {@inheritDoc}
     */
    public final String getPrefix(String namespaceURI) {
        Set<String> keys = _map.keySet();
        for (Iterator<String> iterator = keys.iterator(); iterator.hasNext();) {
            String prefix = (String) iterator.next();
            String uri = (String) _map.get(prefix);
            if (uri.equals(namespaceURI)) {
                return prefix;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    public final Iterator<String> getPrefixes(String namespaceURI) {
        List<String> prefixes = new ArrayList<String>();
        Set<String> keys = _map.keySet();
        for (Iterator<String> iterator = keys.iterator(); iterator.hasNext();) {
            String prefix = (String) iterator.next();
            String uri = (String) _map.get(prefix);
            if (uri.equals(namespaceURI)) {
                prefixes.add(prefix);
            }
        }
        return prefixes.iterator();
    }
}
