<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    exclude-result-prefixes="xs xsi xsl">
    <xsl:output method="xml" encoding="UTF-8" indent="yes"/>
    <xsl:param name="SRC_PATH" select="'c:/Users/srossbroich/workspace/BMUPruefBibliothek/src/main/resources/de/consist/bmu/config/BMU_Rule_Config_ASYS.xml'"/>
    <xsl:variable name="EXT_DOC" select="document($SRC_PATH)"/>
    <!--xsl:template match="/">
        <xsl:apply-templates/>
    </xsl:template-->
    <!--xsl:template match="@*|node()">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:template-->

    <xsl:template match="Regelmenge">
        <xsl:variable name="ExtRegelmenge" select="$EXT_DOC/Regelmenge"/>
        <Regelmenge>
            <Version><xsl:value-of select="$ExtRegelmenge/Version"/></Version>
            <Id><xsl:value-of select="$ExtRegelmenge/Id"/></Id>
            <Name><xsl:value-of select="$ExtRegelmenge/Name"/></Name>
            <xsl:for-each select="Bezug_OK">
                <xsl:call-template name="Bezug_OK"/>
            </xsl:for-each>
            <xsl:for-each select="Bezug_Fehler">
                <xsl:call-template name="Bezug_Fehler"/>
            </xsl:for-each>
            <xsl:for-each select="Regel">
                <xsl:call-template name="Regel"/>
            </xsl:for-each>
        </Regelmenge>
    </xsl:template>

    <!-- Regel -->
    <xsl:template name="Regel">
        <xsl:variable name="Id" select="Id"/>
        <xsl:variable name="ExtRegel" select="document($SRC_PATH)/Regelmenge/Regel[Id=$Id]"/>
        <Regel>
            <xsl:choose>
                <xsl:when test="$ExtRegel">
                    <xsl:call-template name="ExtRegel">
                        <xsl:with-param name="ExtRegel" select="$ExtRegel"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:copy-of select="*"/>
                </xsl:otherwise>
            </xsl:choose>
        </Regel>
    </xsl:template>
    
    <!-- Regel -->
    <xsl:template name="Bezug_OK">
        <xsl:variable name="ExtRegel" select="document($SRC_PATH)/Regelmenge/Bezug_OK"/>
        <Bezug_OK>
            <xsl:choose>
                <xsl:when test="$ExtRegel">
                    <xsl:call-template name="ExtRegel">
                        <xsl:with-param name="ExtRegel" select="$ExtRegel"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:copy-of select="*"/>
                </xsl:otherwise>
            </xsl:choose>
        </Bezug_OK>
    </xsl:template>
    
    <!-- Regel -->
    <xsl:template name="Bezug_Fehler">
        <xsl:variable name="ExtRegel" select="document($SRC_PATH)/Regelmenge/Bezug_Fehler"/>
        <Bezug_Fehler>
            <xsl:choose>
                <xsl:when test="$ExtRegel">
                    <xsl:call-template name="ExtRegel">
                        <xsl:with-param name="ExtRegel" select="$ExtRegel"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:copy-of select="*"/>
                </xsl:otherwise>
            </xsl:choose>
        </Bezug_Fehler>
    </xsl:template>
    
    <xsl:template name="ExtRegel">
        <xsl:param name="ExtRegel"/>
        <xsl:choose>
            <xsl:when test="$ExtRegel/Version">
                <Version><xsl:value-of select="$ExtRegel/Version"/></Version>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy-of select="Version"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:copy-of select="Id"/>
        <xsl:choose>
            <xsl:when test="$ExtRegel/Name">
                <Name><xsl:value-of select="$ExtRegel/Name"/></Name>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy-of select="Name"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
            <xsl:when test="$ExtRegel/Dokumententypen">
                <xsl:for-each select="$ExtRegel/Dokumententypen">
                    <Dokumententypen><xsl:value-of select="."/></Dokumententypen>
                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy-of select="Dokumententypen"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
            <xsl:when test="$ExtRegel/Aktiviert">
                <Aktiviert><xsl:value-of select="$ExtRegel/Aktiviert"/></Aktiviert>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy-of select="Aktiviert"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
            <xsl:when test="$ExtRegel/Stichtag">
                <Stichtag><xsl:value-of select="$ExtRegel/Stichtag"/></Stichtag>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy-of select="Stichtag"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
            <xsl:when test="$ExtRegel/Abbruch">
                <Abbruch><xsl:value-of select="$ExtRegel/Abbruch"/></Abbruch>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy-of select="Abbruch"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
            <xsl:when test="$ExtRegel/Meldung">
                <Meldung>
                    <xsl:choose>
                        <xsl:when test="$ExtRegel/Meldung/Klasse">
                            <Klasse><xsl:value-of select="$ExtRegel/Meldung/Klasse"/></Klasse>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:copy-of select="Meldung/Klasse"/>
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:choose>
                        <xsl:when test="$ExtRegel/Meldung/Stufe">
                            <Stufe><xsl:value-of select="$ExtRegel/Meldung/Stufe"/></Stufe>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:copy-of select="Meldung/Stufe"/>
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:choose>
                        <xsl:when test="$ExtRegel/Meldung/Beschreibung">
                            <Beschreibung><xsl:value-of select="$ExtRegel/Meldung/Beschreibung"/></Beschreibung>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:copy-of select="Meldung/Beschreibung"/>
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:choose>
                        <xsl:when test="$ExtRegel/Meldung/Code">
                            <Code><xsl:value-of select="$ExtRegel/Meldung/Code"/></Code>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:copy-of select="Meldung/Code"/>
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:choose>
                        <xsl:when test="$ExtRegel/Meldung/Abhilfe">
                            <Abhilfe><xsl:value-of select="$ExtRegel/Meldung/Abhilfe"/></Abhilfe>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:copy-of select="Meldung/Abhilfe"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </Meldung>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy-of select="Meldung"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
            <xsl:when test="$ExtRegel/Info">
                <Info><xsl:value-of select="$ExtRegel/Info"/></Info>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy-of select="Info"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
            <xsl:when test="$ExtRegel/StichtagBis">
                <StichtagBis><xsl:value-of select="$ExtRegel/StichtagBis"/></StichtagBis>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy-of select="StichtagBis"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
            <xsl:when test="$ExtRegel/VerwendeSignaturDatum">
                <VerwendeSignaturDatum><xsl:value-of select="$ExtRegel/VerwendeSignaturDatum"/></VerwendeSignaturDatum>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy-of select="VerwendeSignaturDatum"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>