/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.distributed;

import com.jamonapi.FactoryEnabled;
import com.jamonapi.JAMonBufferListener;
import com.jamonapi.JAMonListenerFactory;
import com.jamonapi.JamonPropertiesLoader;
import com.jamonapi.MonKey;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorComposite;
import com.jamonapi.MonitorCompositeIterator;
import com.jamonapi.MonitorFactory;
import com.jamonapi.distributed.DistributedUtils;
import com.jamonapi.distributed.JamonDataPersister;
import com.jamonapi.utils.BufferList;
import com.jamonapi.utils.Misc;
import com.jamonapi.utils.SerializationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class MonitorCompositeCombiner {
    private JamonDataPersister persister;
    static final String SUMMARY_LISTENER = "FIFOBufferInstanceSummary";
    static final String AGGREGATED_INSTANCENAME = "aggregated";
    static final String AGGREGATED_MONITOR_LABEL = "com.jamonapi.distributed.aggregated";
    static final String FIFO_BUFFER = "FIFOBuffer";
    static final int SUMMARY_FIFO_BUFFER_SIZE = Integer.valueOf(JamonPropertiesLoader.PROPS.getProperty("monitorCompositeCombiner.summaryFifoBufferSize", "100"));

    public MonitorCompositeCombiner(JamonDataPersister persister) {
        this.persister = persister;
    }

    public MonitorComposite get(String ... instanceKeys) {
        return this.append(this.getMonitorComposites(instanceKeys));
    }

    public MonitorComposite aggregate(String ... instanceKeys) {
        FactoryEnabled factory = new FactoryEnabled(false);
        String[] stringArray = instanceKeys;
        int n = instanceKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String instanceKey = stringArray[n2];
            Monitor mon = this.startInstanceMonitor();
            MonitorComposite monitorComposite = this.persister.get(instanceKey).copy();
            mon.getMonKey().setDetails(monitorComposite.getInstanceName());
            this.aggregate(factory, monitorComposite, instanceKeys.length);
            mon.stop();
            ++n2;
        }
        MonitorComposite aggregated = factory.getRootMonitor();
        aggregated.setInstanceName(AGGREGATED_INSTANCENAME);
        return aggregated;
    }

    public MonitorComposite append(Collection<MonitorComposite> monitorCompositeList) {
        MonitorComposite mc;
        Date previousDate = null;
        Date finalDate = null;
        Iterator<MonitorComposite> iter = monitorCompositeList.iterator();
        ArrayList<MonitorComposite> monitorCompositeResultsList = new ArrayList<MonitorComposite>();
        ArrayList<String> instanceNameList = new ArrayList<String>();
        while (iter.hasNext()) {
            mc = iter.next();
            instanceNameList.add(mc.getInstanceName());
            monitorCompositeResultsList.add(mc);
            if (previousDate == null || mc.getDateCreated().after(previousDate)) {
                finalDate = mc.getDateCreated();
            }
            previousDate = mc.getDateCreated();
        }
        mc = new MonitorCompositeIterator(monitorCompositeResultsList).toMonitorComposite().setDateCreated(finalDate);
        return mc.setInstanceName(Misc.getAsString(instanceNameList));
    }

    private void aggregate(FactoryEnabled factory, MonitorComposite monitorComposite, int numInstances) {
        Monitor[] monitors;
        Monitor[] monitorArray = monitors = monitorComposite.getMonitors();
        int n = monitors.length;
        int n2 = 0;
        while (n2 < n) {
            Monitor monitor = monitorArray[n2];
            MonKey key = (MonKey)SerializationUtils.deepCopy(monitor.getMonKey());
            key.setInstanceName(AGGREGATED_INSTANCENAME);
            Monitor summaryMonitor = factory.getMonitor(key);
            this.merge(monitor, summaryMonitor);
            this.createSummaryFifoBufferIfAbsent(summaryMonitor);
            this.addMonitorDataToSummaryFifoBuffer(monitor, summaryMonitor);
            DistributedUtils.copyJamonBufferListenerData(monitor, summaryMonitor, numInstances);
            ++n2;
        }
    }

    private Monitor startInstanceMonitor() {
        Monitor mon = MonitorFactory.start(AGGREGATED_MONITOR_LABEL);
        if (!mon.hasListeners()) {
            mon.addListener("value", JAMonListenerFactory.get(FIFO_BUFFER));
        }
        return mon;
    }

    private List<MonitorComposite> getMonitorComposites(String[] instanceKeys) {
        ArrayList<MonitorComposite> monitorCompositeList = new ArrayList<MonitorComposite>();
        String[] stringArray = instanceKeys;
        int n = instanceKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String instanceKey = stringArray[n2];
            MonitorComposite monitorComposite = this.persister.get(instanceKey);
            if (monitorComposite != null) {
                monitorCompositeList.add(monitorComposite);
            }
            ++n2;
        }
        return monitorCompositeList;
    }

    private void createSummaryFifoBufferIfAbsent(Monitor summaryMonitor) {
        if (!summaryMonitor.hasListener("value", SUMMARY_LISTENER)) {
            summaryMonitor.addListener("value", this.getSummaryFIFOBufferListener(summaryMonitor));
        }
    }

    private void addMonitorDataToSummaryFifoBuffer(Monitor monitor, Monitor summaryMonitor) {
        JAMonBufferListener jaMonBufferListener = (JAMonBufferListener)summaryMonitor.getListenerType("value").getListener(SUMMARY_LISTENER);
        jaMonBufferListener.addRow(this.getRowData(monitor).toArray());
    }

    private JAMonBufferListener getSummaryFIFOBufferListener(Monitor mon) {
        BufferList bufferList = new BufferList(this.getHeader(mon).toArray(new String[0]), SUMMARY_FIFO_BUFFER_SIZE);
        return new JAMonBufferListener(SUMMARY_LISTENER, bufferList);
    }

    private List<String> getHeader(Monitor mon) {
        ArrayList<String> header = new ArrayList<String>();
        mon.getMonKey().getHeader(header);
        header.add("Hits");
        header.add("Avg");
        header.add("Total");
        header.add("StdDev");
        header.add("LastValue");
        header.add("Min");
        header.add("Max");
        header.add("Active");
        header.add("AvgActive");
        header.add("MaxActive");
        header.add("FirstAccess");
        header.add("LastAccess");
        header.add("Enabled");
        header.add("Primary");
        header.add("HasListeners");
        return header;
    }

    private List getRowData(Monitor mon) {
        ArrayList<Comparable<Double>> rowData = new ArrayList<Comparable<Double>>();
        mon.getMonKey().getRowData(rowData);
        rowData.add(Double.valueOf(mon.getHits()));
        rowData.add(Double.valueOf(mon.getAvg()));
        rowData.add(Double.valueOf(mon.getTotal()));
        rowData.add(Double.valueOf(mon.getStdDev()));
        rowData.add(Double.valueOf(mon.getLastValue()));
        rowData.add(Double.valueOf(mon.getMin()));
        rowData.add(Double.valueOf(mon.getMax()));
        rowData.add(Double.valueOf(mon.getActive()));
        rowData.add(Double.valueOf(mon.getAvgActive()));
        rowData.add(Double.valueOf(mon.getMaxActive()));
        rowData.add(mon.getFirstAccess());
        rowData.add(mon.getLastAccess());
        rowData.add(Boolean.valueOf(mon.isEnabled()));
        rowData.add(Boolean.valueOf(mon.isPrimary()));
        rowData.add(Boolean.valueOf(mon.hasListeners()));
        return rowData;
    }

    public void remove(String ... instanceKeys) {
        String[] stringArray = instanceKeys;
        int n = instanceKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String instanceKey = stringArray[n2];
            this.persister.remove(instanceKey);
            ++n2;
        }
    }

    Monitor merge(Monitor from, Monitor to) {
        to.setTotalActive(to.getAvgActive() * to.getHits() + from.getAvgActive() * from.getHits());
        to.setHits(to.getHits() + from.getHits());
        to.setTotal(to.getTotal() + from.getTotal());
        to.setMin(Math.min(to.getMin(), from.getMin()));
        to.setMax(Math.max(to.getMax(), from.getMax()));
        to.setMaxActive(Math.max(to.getMaxActive(), from.getMaxActive()));
        to.setActive(to.getActive() + from.getActive());
        to.setFirstAccess(Misc.min(to.getFirstAccess(), from.getFirstAccess()));
        Date lastAccess = Misc.max(to.getLastAccess(), from.getLastAccess());
        to.setLastAccess(lastAccess);
        if (lastAccess != null && lastAccess.equals(from.getLastAccess())) {
            to.setLastValue(from.getLastValue());
        }
        to.setPrimary(to.isPrimary() || from.isPrimary());
        return to;
    }
}

