/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.http;

import com.jamonapi.http.HttpMon;
import com.jamonapi.http.HttpMonItem;
import com.jamonapi.http.HttpMonManage;
import com.jamonapi.http.HttpMonNull;
import com.jamonapi.http.HttpMonRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class HttpMonFactory
implements HttpMonManage,
Serializable {
    private static final String DEFAULT_SUMMARY = "request.getRequestURI().ms as allPages, request.getRequestURI().value.ms as page";
    private static final long serialVersionUID = 278L;
    private static final HttpMon NULL_HTTP_MON = new HttpMonNull();
    private String jamonSummaryLabels = "default";
    private Collection httpMonItemsHolder = new ArrayList();
    private boolean ignoreHttpParams = true;
    private String labelPrefix;
    private boolean enabled = true;
    private int numTimeMons = 0;
    private int size = 5000;

    public HttpMonFactory(String labelPrefix) {
        this.labelPrefix = labelPrefix;
    }

    @Override
    public void setSummaryLabels(String jamonSummaryLabels) {
        this.jamonSummaryLabels = "";
        this.httpMonItemsHolder = new ArrayList();
        this.numTimeMons = 0;
        if (jamonSummaryLabels == null) {
            return;
        }
        jamonSummaryLabels = jamonSummaryLabels.replaceAll("(?i)demo", HttpMonFactory.getDemoLabels());
        jamonSummaryLabels = HttpMonFactory.replaceDefault(jamonSummaryLabels, DEFAULT_SUMMARY);
        String[] summaryLabelsArr = this.split(jamonSummaryLabels);
        int i = 0;
        while (i < summaryLabelsArr.length) {
            this.addSummaryLabel(summaryLabelsArr[i]);
            ++i;
        }
    }

    public static String getDemoLabels() {
        Object demoStr = "";
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("response.getBufferSize()", "bytes");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("response.getCharacterEncoding()", "charEncoding");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("response.getContentCount()", "bytes");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("response.getContentType()", "contentType");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("response.getLocale()", "locale");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("request.getAuthType()", "authType");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("request.getCharacterEncoding()", "charEncoding");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("request.getContentLength()", "bytes");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("request.getContentType()", "contentType");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("request.getContextPath()", "path");
        demoStr = (String)demoStr + "request.getContextPath().value.ms, ";
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("request.getLocalAddr()", "ip");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("request.getLocale()", "locale");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("request.getLocalName()", "localName");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("request.getLocalPort()", "port");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("request.getMethod()", "httpMethod");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("request.getPathInfo()", "path");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("request.getPathTranslated()", "path");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("request.getProtocol()", "protocol");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("request.getQueryString()", "queryStr");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("request.getRemoteAddr()", "ip");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("request.getRemoteHost()", "ip");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("request.getRemotePort()", "port");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("request.getRemoteUser()", "user");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("request.getRequestedSessionId()", "sessionid");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("request.getRequestURI()", "ms");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("request.getRequestURL()", "ms");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("request.getScheme()", "scheme");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("request.getServerName()", "serverName");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("request.getServerPort()", "port");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("request.getServletPath()", "path");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("request.getUserPrincipal()", "user");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("request.isRequestedSessionIdFromCookie()", "sessionCookie");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("request.isRequestedSessionIdValid()", "sessionValid");
        demoStr = (String)demoStr + HttpMonFactory.getDemoLabel("request.isSecure()", "secure");
        demoStr = (String)demoStr + "request.getScheme().ms as schemeAlias";
        return demoStr;
    }

    private static String getDemoLabel(String label, String units) {
        String str = label + "." + units;
        str = str + ", " + label + ".value." + units;
        str = str + ", " + label + ".contextpath.value." + units;
        str = str + ", " + label + ".value.contextpath." + units;
        str = str + ", " + label + ".value.url." + units + ",";
        return str;
    }

    public void setSummaryLabels(String summaryLabel, String defaultString) {
        summaryLabel = HttpMonFactory.replaceDefault(summaryLabel, defaultString);
        this.setSummaryLabels(summaryLabel);
    }

    static String replaceDefault(String summaryLabel, String defaultString) {
        return summaryLabel.replaceAll("(?i)default", defaultString);
    }

    @Override
    public void addSummaryLabel(String jamonSummaryLabel) {
        if (this.httpMonItemsHolder != null) {
            HttpMonItem monItem = this.createHttpMonItem(jamonSummaryLabel.trim());
            this.httpMonItemsHolder.add(monItem);
            if (!"".equals(this.jamonSummaryLabels)) {
                this.jamonSummaryLabels = String.valueOf(this.jamonSummaryLabels) + ", ";
            }
            this.jamonSummaryLabels = String.valueOf(this.jamonSummaryLabels) + jamonSummaryLabel;
            if (monItem.isTimeMon()) {
                ++this.numTimeMons;
            }
        }
    }

    int getNumRows() {
        return this.httpMonItemsHolder.size();
    }

    int getNumTimeMons() {
        return this.numTimeMons;
    }

    Iterator iter() {
        return this.httpMonItemsHolder.iterator();
    }

    @Override
    public String getSummaryLabels() {
        return this.jamonSummaryLabels;
    }

    @Override
    public boolean getIgnoreHttpParams() {
        return this.ignoreHttpParams;
    }

    @Override
    public void setIgnoreHttpParams(boolean ignoreHttpParams) {
        this.ignoreHttpParams = ignoreHttpParams;
    }

    @Override
    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    public String getLabelPrefix() {
        return this.labelPrefix;
    }

    private String[] split(String str) {
        return str == null ? null : str.split(",");
    }

    public HttpMon getMon(Object request, Object response) {
        if (!this.enabled || this.jamonSummaryLabels == null) {
            return NULL_HTTP_MON;
        }
        return new HttpMonRequest(request, response, this);
    }

    public HttpMon start(Object request, Object response) {
        return this.getMon(request, response).start();
    }

    HttpMonItem createHttpMonItem(String label) {
        return new HttpMonItem(label, this);
    }
}

