/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.http;

import com.jamonapi.MonKey;
import com.jamonapi.MonKeyImp;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import com.jamonapi.NullMonitor;
import com.jamonapi.http.HttpMonFactory;
import com.jamonapi.http.HttpMonRequest;
import com.jamonapi.utils.Misc;
import java.lang.reflect.Method;

class HttpMonItem {
    private boolean isTimeMon;
    private String units = "noUnitsProvided";
    private String label;
    private String methodName;
    private String additionToLabel = "";
    private boolean isResponse = true;
    private Method method;
    private boolean removeHttpParams = false;
    private static final Monitor NULL_MON = new NullMonitor();

    HttpMonItem() {
    }

    HttpMonItem(String label, HttpMonFactory httpMonFactory) {
        this.parseLabel(label, httpMonFactory);
    }

    private void parseLabel(String localLabel, HttpMonFactory httpMonFactory) {
        String colAlias = HttpMonItem.colAlias(localLabel);
        String nonAlias = HttpMonItem.nonAlias(localLabel);
        String[] parsedLabel = nonAlias.split("[.]");
        this.label = httpMonFactory.getLabelPrefix() + ".response.";
        int i = 0;
        while (i < parsedLabel.length) {
            String token = parsedLabel[i].trim();
            if ("request".equalsIgnoreCase(token)) {
                this.label = httpMonFactory.getLabelPrefix() + ".request.";
                this.isResponse = false;
            } else if ("response".equalsIgnoreCase(token)) {
                this.label = httpMonFactory.getLabelPrefix() + ".response.";
                this.isResponse = true;
            } else if (token.indexOf("()") != -1) {
                this.label = String.valueOf(this.label) + (colAlias == null ? token : colAlias);
                this.methodName = token.replaceFirst("[(][)]", "");
            } else if ("value".equalsIgnoreCase(token)) {
                this.additionToLabel = String.valueOf(this.additionToLabel) + "v";
            } else if ("summary".equalsIgnoreCase(token)) {
                this.label = "com.jamonapi.http.response.getStatus()";
                this.additionToLabel = String.valueOf(this.additionToLabel) + "s";
            } else if ("url".equalsIgnoreCase(token)) {
                this.additionToLabel = String.valueOf(this.additionToLabel) + "u";
            } else if ("contextpath".equalsIgnoreCase(token)) {
                this.additionToLabel = String.valueOf(this.additionToLabel) + "p";
            } else if ("ms".equalsIgnoreCase(token)) {
                this.units = "ms.";
                this.isTimeMon = true;
            } else {
                this.units = token;
                this.isTimeMon = false;
            }
            ++i;
        }
        if (httpMonFactory.getIgnoreHttpParams() && ("getRequestURI".equals(this.methodName) || "getRequestURL".equals(this.methodName))) {
            this.removeHttpParams = true;
        }
    }

    String getUnits() {
        return this.units;
    }

    boolean isResponse() {
        return this.isResponse;
    }

    boolean isTimeMon() {
        return this.isTimeMon;
    }

    void start(HttpMonRequest httpMonBase) {
        if (this.isTimeMon) {
            Monitor timeMon = null;
            if (this.sizeThresholdExceeded(httpMonBase)) {
                this.createSizeThresholdExceededMon(httpMonBase);
                timeMon = NULL_MON;
            }
            if (timeMon == null) {
                timeMon = this.startTimeMon(httpMonBase);
            }
            httpMonBase.setTimeMon(timeMon);
        }
    }

    void stop(HttpMonRequest httpMonBase) {
        if (this.isTimeMon) {
            this.stopTimeMon(httpMonBase);
        } else if (this.sizeThresholdExceeded(httpMonBase)) {
            this.createSizeThresholdExceededMon(httpMonBase);
        } else {
            MonitorFactory.add(this.getMonKey(httpMonBase), this.getValueToAdd(httpMonBase));
        }
    }

    Monitor startTimeMon(HttpMonRequest httpMonBase) {
        return MonitorFactory.start(this.getMonKey(httpMonBase));
    }

    void stopTimeMon(HttpMonRequest httpMonBase) {
        httpMonBase.stopTimeMon();
    }

    private boolean sizeThresholdExceeded(HttpMonRequest httpMonBase) {
        return MonitorFactory.getNumRows() > httpMonBase.getSize() && httpMonBase.getSize() > 0 && !MonitorFactory.exists(this.getMonKey(httpMonBase));
    }

    private void createSizeThresholdExceededMon(HttpMonRequest httpMonBase) {
        String label = new StringBuffer(httpMonBase.getLabelPrefix()).append(".HttpMonFactory.sizeExceeded.").append(httpMonBase.getSize()).toString();
        String detailLabel = new StringBuffer(this.getLabel(httpMonBase)).append(", ").append(httpMonBase.getRequestURI()).append(", ").append(this.getUnits()).toString();
        MonitorFactory.add(new MonKeyImp(label, detailLabel, "Count"), httpMonBase.getSize());
    }

    MonKey getMonKey(HttpMonRequest httpMonBase) {
        return new MonKeyImp(this.getLabel(httpMonBase), httpMonBase.getDetailLabel(), this.getUnits());
    }

    String getLabel(HttpMonRequest httpMonBase) {
        if ("".equals(this.additionToLabel)) {
            return this.label;
        }
        return this.appendToLabel(httpMonBase);
    }

    private String appendToLabel(HttpMonRequest httpMonBase) {
        StringBuffer sb = new StringBuffer(this.label);
        if (this.label.charAt(this.label.length() - 1) != '.') {
            sb.append(".");
        }
        int i = 0;
        while (i < this.additionToLabel.length()) {
            if (i >= 1) {
                sb.append(", ");
            }
            if (this.additionToLabel.charAt(i) == 'v') {
                sb.append("value: ").append(this.getValueLabel(httpMonBase));
            } else if (this.additionToLabel.charAt(i) == 's') {
                sb.append("summary: ").append(this.getHttpStatusSummaryLabel(httpMonBase));
            } else if (this.additionToLabel.charAt(i) == 'u') {
                sb.append("url: ").append(httpMonBase.getKeyReadyURI());
            } else if (this.additionToLabel.charAt(i) == 'p') {
                sb.append("contextpath: ").append(httpMonBase.getContextPath());
            }
            ++i;
        }
        return sb.toString();
    }

    Object getValueLabel(HttpMonRequest httpMonBase) {
        Object valLabel = this.executeMethod(httpMonBase);
        if (this.removeHttpParams) {
            valLabel = HttpMonItem.removeHttpParams(valLabel);
        }
        return valLabel;
    }

    String getHttpStatusSummaryLabel(HttpMonRequest httpMonBase) {
        Object status = this.executeMethod(httpMonBase);
        if (status instanceof Number) {
            int httpStatusCode = ((Number)status).intValue();
            int httpStatusSummary = httpStatusCode / 100;
            return String.valueOf(httpStatusSummary) + "xx";
        }
        return "";
    }

    double getValueToAdd(HttpMonRequest httpMonBase) {
        Object obj = this.executeMethod(httpMonBase);
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        return 1.0;
    }

    private Object executeMethod(HttpMonRequest httpMonBase) {
        Object retValue = null;
        try {
            retValue = this.getMethod(httpMonBase).invoke(this.getObjectToExecute(httpMonBase), null);
        }
        catch (Throwable e) {
            MonitorFactory.add(new MonKeyImp(httpMonBase.getLabelPrefix() + ".monError", new Object[]{this, Misc.getExceptionTrace(e)}, "Exception"), 1.0);
        }
        return retValue;
    }

    Method getMethod(HttpMonRequest httpMonBase) {
        try {
            if (this.method == null) {
                this.method = this.getObjectToExecute(httpMonBase).getClass().getMethod(this.methodName, null);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return this.method;
    }

    Object getObjectToExecute(HttpMonRequest httpMonBase) {
        if (this.isResponse()) {
            return httpMonBase.getResponse();
        }
        return httpMonBase.getRequest();
    }

    public String toString() {
        return new StringBuffer("label=").append(this.label).append(", units=").append(this.units).append(", methodName=").append(this.methodName).toString();
    }

    protected static String colAlias(String str) {
        if (str == null) {
            return null;
        }
        String[] arr = str.split(" [aA][sS] ");
        if (arr.length == 2) {
            return arr[1].trim();
        }
        return null;
    }

    protected static String nonAlias(String str) {
        if (str == null) {
            return null;
        }
        String[] arr = str.split(" [aA][sS] ");
        return arr[0].trim();
    }

    protected static String removeHttpParams(Object url) {
        if (url == null) {
            return null;
        }
        String urlStr = url.toString();
        int paramIndex = urlStr.indexOf(";");
        if (paramIndex == -1) {
            return urlStr;
        }
        return urlStr.substring(0, paramIndex);
    }
}

