/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.jmx;

import java.io.File;

class FreeDiskSpace {
    static final double GB = 1.0E9;
    private File dir;

    public FreeDiskSpace() {
        this(new File(File.separator));
    }

    public FreeDiskSpace(File dir) {
        this.dir = dir;
    }

    public double getFreeSpace() {
        return (double)this.dir.getFreeSpace() / 1.0E9;
    }

    public double getFreeSpacePercent() {
        return this.getFreeSpace() / this.getTotalSpace();
    }

    public double getTotalSpace() {
        return (double)this.dir.getTotalSpace() / 1.0E9;
    }

    public String getAbsolutePath() {
        return this.dir.getAbsolutePath();
    }

    public String toString() {
        return "path=" + this.getAbsolutePath() + ", freeSpace=" + this.getFreeSpace() + " GB, totalSpace=" + this.getTotalSpace() + " GB, freeSpacePercent=" + this.getFreeSpacePercent();
    }
}

