/*
 * Decompiled with CFR 0.152.
 */
package de.itu.bmu;

import de.consist.bmu.rule.BMUDokument;
import de.itu.xml.XPathFacade;
import de.itu.xml.XmlException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BMUKopfdaten {
    private static final Logger _logger = LogManager.getLogger(BMUKopfdaten.class);
    private static final String XPATH_ABSENDER = "/msg:Nachricht/msg:Kopfdaten/msg:Absender";
    private static final String XPATH_EMPFAENGER = "/msg:Nachricht/msg:Kopfdaten/msg:Empfaenger";
    private static final String XPATH_ANTWORT = "/msg:Nachricht/msg:Kopfdaten/msg:Antwort";
    private static final String XPATH_ZUGANGSTYP = "/@lib:Zugangstyp";
    private static final String XPATH_TEXT = "/lib:Text";
    private static final String XPATH_STRUKTUR = "/lib:Struktur";
    private static final String XPATH_BETRIEB = "/lib:BehoerdlicheNummer";
    private static final String XPATH_PROV = "/lib:Provider";
    private static final String XPATH_ZUSATZ = "/lib:Zusatzangaben";
    private static final String XPATH_BEHNR = "/lib:BehoerdlicheNr";
    private static final String XPATH_PRZ = "/lib:Pruefziffer";
    private static final String XPATH_ROLLE = "/@lib:ATBRolle";
    public static final String PARAM_ABS_BEHNR = "ABS_BEHNR";
    public static final String PARAM_ABS_PRZ = "ABS_PRZ";
    public static final String PARAM_EMPF_BEHNR = "EMPF_BEHNR";
    public static final String PARAM_EMPF_PRZ = "EMPF_PRZ";
    public static final String PARAM_EMPF_ROLLE = "EMPF_ROLLE";
    public static final String PARAM_EMPF_PROV_BEHNR = "EMPF_PROV_BEHNR";
    public static final String PARAM_EMPF_PROV_PRZ = "EMPF_PROV_PRZ";
    public static final String PARAM_EMPF_PROV_ROLLE = "EMPF_PROV_ROLLE";
    public static final String PARAM_EMPF_ZUSATZ = "EMPF_ZUSATZ";
    public static final String PARAM_SPEZ_VER = "SPEZ_VER";
    public static final String PARAM_MSG_UUID = "MSG_UUID";
    public static final String PARAM_MSG_STATUS = "MSG_STATUS";
    public static final String PARAM_BEZUG_MSG_UUID = "BEZUG_MSG_UUID";
    private BMUAdresse _absender;
    private BMUAdresse _empfaenger;
    private BMUAdresse _antwort;

    private BehoerdlicheNummer getBehoerdlicheNummer(Document doc, String xPath) {
        BehoerdlicheNummer behNummer = null;
        XPathFacade xf = XPathFacade.getInstance();
        Element root = doc.getDocumentElement();
        try {
            if (xf.evalBool(root, "count(" + xPath + ") > 0")) {
                String behNr = xf.evaluate(doc, xPath + XPATH_BEHNR);
                String prz = xf.evaluate(doc, xPath + XPATH_PRZ);
                String r = xf.evaluate(doc, xPath + XPATH_ROLLE);
                Rolle rolle = Rolle.valueOf(r.trim());
                behNummer = new BehoerdlicheNummer(behNr, prz, rolle);
            }
        }
        catch (XmlException e) {
            _logger.error("Fehler", (Throwable)e);
        }
        return behNummer;
    }

    private BMUAdresse getAdresse(Document doc, String xPath) {
        BMUAdresse adr;
        block6: {
            adr = null;
            XPathFacade xf = XPathFacade.getInstance();
            Element root = doc.getDocumentElement();
            try {
                if (!xf.evalBool(root, "count(" + xPath + ") > 0")) break block6;
                String typ = xf.evaluate(doc, xPath + XPATH_ZUGANGSTYP);
                Zugangstyp zt = Zugangstyp.OSCI;
                try {
                    zt = Zugangstyp.valueOf(typ.trim());
                }
                catch (IllegalArgumentException iae) {
                    _logger.info("Unbekannter Zugangstyp: " + typ);
                }
                if (xf.evalBool(root, "count(" + xPath + "/lib:Text) > 0")) {
                    String text = xf.evaluate(doc, xPath + XPATH_TEXT);
                    adr = new BMUAdresseText(zt, text);
                } else {
                    BehoerdlicheNummer btr = this.getBehoerdlicheNummer(doc, xPath + "/lib:Struktur/lib:BehoerdlicheNummer");
                    BehoerdlicheNummer prov = this.getBehoerdlicheNummer(doc, xPath + "/lib:Struktur/lib:Provider");
                    String zusatz = xf.evaluate(doc, xPath + "/lib:Struktur/lib:Zusatzangaben");
                    adr = new BMUAdresseStruktur(zt, btr, prov, zusatz);
                }
            }
            catch (XmlException e) {
                _logger.error("Fehler", (Throwable)e);
            }
        }
        return adr;
    }

    private void init(BMUDokument doc) {
        this._absender = this.getAdresse(doc.getDocument(), XPATH_ABSENDER);
        this._empfaenger = this.getAdresse(doc.getDocument(), XPATH_EMPFAENGER);
        this._antwort = this.getAdresse(doc.getDocument(), XPATH_ANTWORT);
    }

    public BMUAdresse getAbsender() {
        return this._absender;
    }

    public BMUAdresse getEmpfaenger() {
        return this._empfaenger;
    }

    public BMUAdresse getAntwort() {
        return this._antwort;
    }

    public static BMUKopfdaten getKopfdaten(BMUDokument doc) {
        BMUKopfdaten kp = new BMUKopfdaten();
        kp.init(doc);
        return kp;
    }

    public int fillParams(Map<String, Object> params, boolean reverse) {
        int result = 0;
        if (this._absender == null) {
            _logger.error("Keine Absenderinformationen gefunden");
        } else {
            result += this._absender.fillParams(params, reverse ? "EMPF_" : "ABS_");
            if (!reverse) {
                if (this._empfaenger != null) {
                    result += this._empfaenger.fillParams(params, reverse ? "ABS_" : "EMPF_");
                }
                result += this._antwort.fillParams(params, "ANTW_");
            }
        }
        return result;
    }

    public static enum Rolle {
        ERZ,
        BEF,
        ENT,
        ZWL,
        BEH,
        MAK,
        BEVERZ,
        PROV,
        SONST;

    }

    public class BehoerdlicheNummer {
        private String _behNr;
        private String _pZ;
        private Rolle _rolle;

        public BehoerdlicheNummer(String behNr, String pz, Rolle rolle) {
            this._behNr = behNr;
            this._pZ = pz;
            this._rolle = rolle;
        }

        public String getBehNr() {
            return this._behNr;
        }

        public String getPZ() {
            return this._pZ;
        }

        public Rolle getRolle() {
            return this._rolle;
        }

        public int fillParams(Map<String, Object> params, String prefix) {
            int result = 0;
            if (this._behNr != null) {
                params.put(prefix + "BEHNR", this._behNr);
                ++result;
            }
            if (this._pZ != null) {
                params.put(prefix + "PRZ", this._pZ);
                ++result;
            }
            if (this._rolle != null) {
                params.put(prefix + "ROLLE", (Object)this._rolle);
                ++result;
            }
            return result;
        }
    }

    public static enum Zugangstyp {
        OSCI,
        EMAIL,
        SONST,
        ZKS,
        RGA;

    }

    public class BMUAdresseText
    extends BMUAdresse {
        private String _text;

        BMUAdresseText(Zugangstyp typ, String text) {
            super(typ);
            this._text = text;
        }

        public String getText() {
            return this._text;
        }

        @Override
        public int fillParams(Map<String, Object> params, String prefix) {
            int result = super.fillParams(params, prefix);
            if (this._text != null) {
                params.put(prefix + "TEXT", this._text);
                ++result;
            }
            return result;
        }
    }

    public class BMUAdresseStruktur
    extends BMUAdresse {
        private BehoerdlicheNummer _behNummer;
        private BehoerdlicheNummer _provider;
        private String _zusatzAngaben;

        BMUAdresseStruktur(Zugangstyp typ, BehoerdlicheNummer btr, BehoerdlicheNummer prov, String zusatz) {
            super(typ);
            this._behNummer = btr;
            this._provider = prov;
            this._zusatzAngaben = zusatz;
        }

        public BehoerdlicheNummer getBehNummer() {
            return this._behNummer;
        }

        public BehoerdlicheNummer getProvider() {
            return this._provider;
        }

        public String getZusatzangaben() {
            return this._zusatzAngaben;
        }

        @Override
        public int fillParams(Map<String, Object> params, String prefix) {
            int result = super.fillParams(params, prefix);
            if (this._behNummer != null) {
                result += this._behNummer.fillParams(params, prefix);
            }
            if (this._provider != null) {
                result += this._provider.fillParams(params, prefix + "PROV_");
            }
            if (this._zusatzAngaben != null) {
                params.put(prefix + "ZUSATZ", this._zusatzAngaben);
                ++result;
            }
            return result;
        }
    }

    public abstract class BMUAdresse {
        private Zugangstyp _zugangsTyp;

        BMUAdresse(Zugangstyp typ) {
            this._zugangsTyp = typ;
        }

        public Zugangstyp getZugangstyp() {
            return this._zugangsTyp;
        }

        public int fillParams(Map<String, Object> params, String prefix) {
            int result = 0;
            return result;
        }
    }
}

