/*
 * Decompiled with CFR 0.152.
 */
package de.itu.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Helper {
    private static final Logger _logger = LogManager.getLogger(Helper.class);

    public static X509Certificate readCert(InputStream is) throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(is);
        return x509Cert;
    }

    public static X509Certificate readCert(File file) throws Exception {
        return Helper.readCert(new FileInputStream(file));
    }

    public static X509Certificate readCert(String path) throws Exception {
        return Helper.readCert(Helper.class.getResourceAsStream(path));
    }

    public static byte[] readByteArray(InputStream is) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] data = new byte[32];
        int len = 0;
        while ((len = is.read(data)) != -1) {
            bos.write(data, 0, len);
        }
        is.close();
        return bos.toByteArray();
    }

    public static byte[] readByteArray(File file) throws Exception {
        return Helper.readByteArray(new FileInputStream(file));
    }

    public static byte[] readByteArray(String path) throws Exception {
        return Helper.readByteArray(Helper.class.getResourceAsStream(path));
    }

    public static String createSubject(String empfaenger, String nummer, String sender, String filename) {
        StringBuffer buf = new StringBuffer();
        buf.append(empfaenger);
        while (buf.length() < 16) {
            buf.append(' ');
        }
        buf.append(sender);
        while (buf.length() < 32) {
            buf.append(' ');
        }
        buf.append("ASY");
        buf.append(nummer);
        if (filename != null) {
            while (buf.length() < 60) {
                buf.append(' ');
            }
            buf.append(filename);
        }
        return buf.toString();
    }

    public static String getFileName(String subject) {
        StringBuffer fileNameBuf = new StringBuffer();
        String asysFileName = SubjectEntry.AsysFileName.getEntry(subject);
        if (asysFileName != null) {
            fileNameBuf.append(asysFileName);
        } else {
            fileNameBuf.append(SubjectEntry.DokTyp.getEntry(subject));
            fileNameBuf.append("_");
            fileNameBuf.append(SubjectEntry.Absender.getEntry(subject));
            fileNameBuf.append("_");
            fileNameBuf.append(SubjectEntry.AbsRolle.getEntry(subject));
            fileNameBuf.append("_");
            fileNameBuf.append(SubjectEntry.Empfaenger.getEntry(subject));
            fileNameBuf.append("_");
            fileNameBuf.append(SubjectEntry.EmpfRolle.getEntry(subject));
            fileNameBuf.append("_");
            fileNameBuf.append(SubjectEntry.DokNummer.getEntry(subject));
        }
        fileNameBuf.append("_");
        fileNameBuf.append(new Date().getTime());
        return fileNameBuf.toString();
    }

    public static enum SubjectEntry {
        Empfaenger(0, 10),
        EmpfRolle(10, 6),
        Absender(16, 10),
        AbsRolle(26, 6),
        DokTyp(32, 3),
        DokNummer(35, 15),
        KFZ(50, 10),
        AsysFileName(60, 70);

        private final int _startPos;
        private final int _length;

        private SubjectEntry(int startPos, int length) {
            this._startPos = startPos;
            this._length = length;
        }

        public String getEntry(String subject) {
            String entry = null;
            if (subject != null && subject.length() > this._startPos) {
                entry = subject.substring(this._startPos, Math.min(this._startPos + this._length, subject.length())).trim();
            }
            _logger.debug("<getEntry> " + this.toString() + ": subject=" + subject + ", entry=" + entry + ", start=" + this._startPos + ", length=" + this._length);
            return entry;
        }
    }
}

