/*
 * Decompiled with CFR 0.152.
 */
package de.itu.xmlsec;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.util.CertUtils;
import de.consist.bmu.rule.xmlsec.XmlSecFassade;
import de.itu.util.MD5Helper;
import de.itu.xml.XPathFacade;
import jakarta.xml.bind.DatatypeConverter;
import java.io.File;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FileSignInfo {
    private static final Logger _logger = LogManager.getLogger(FileSignInfo.class);
    private static final String CHECKSUM_METHOD = "MD5";
    private String _sigID;
    private String _sigValue;
    private String _sigSubjectName;
    private String _fileName;
    private String _filePath;
    private long _fileSize;
    private String _checksum;
    private boolean _sigValid;
    private String _sigNodeName;
    private String _signingTime;
    private Date _signDate;
    private boolean _timeStamp;
    private boolean _timeStampValid;
    private FileType _fileType;

    public FileSignInfo(FileType fileType, String fileName, String filePath, long fileSize, String checksum) {
        this._fileType = fileType;
        this._fileName = fileName;
        this._filePath = filePath;
        this._fileSize = fileSize;
        this._checksum = checksum;
        this._sigValid = false;
        this._timeStamp = false;
        this._timeStampValid = false;
    }

    public FileSignInfo(File xmlFile, BMUDokument doc, Element sigElem, String sigNodeName) {
        this._fileType = FileType.XML;
        if (xmlFile.exists()) {
            this._fileName = xmlFile.getName();
            this._filePath = xmlFile.getAbsolutePath();
            this._fileSize = xmlFile.length();
            this._sigNodeName = sigNodeName;
            this._sigID = sigElem.getAttribute("Id");
            this._sigValue = sigElem.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignatureValue").item(0).getTextContent();
            String x509Cert = sigElem.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509Certificate").item(0).getTextContent();
            try {
                String sts = XPathFacade.getInstance().evaluate(sigElem, "ds:Object/xades:QualifyingProperties/xades:SignedProperties/xades:SignedSignatureProperties/xades:SigningTime");
                if (sts != null) {
                    Calendar cal = DatatypeConverter.parseDateTime((String)sts);
                    SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                    this._signingTime = sdf.format(cal.getTime());
                    this._signDate = cal.getTime();
                }
                this._sigSubjectName = CertUtils.getSubjectCN((X509Certificate)CertUtils.getX509CertificateFromBase64((String)x509Cert));
                this._checksum = MD5Helper.getMD5FromFile(xmlFile.getAbsolutePath());
                this._sigValid = XmlSecFassade.getInstance().verifySignatureApache(sigElem);
            }
            catch (Exception e) {
                _logger.error("Fehler beim Verarbeiten der Signatur: " + this._sigID, (Throwable)e);
            }
        } else {
            _logger.error("Datei exisitiert nicht: " + xmlFile.getAbsolutePath());
        }
    }

    public FileSignInfo(String sigID, String sigValue, String sigSubjectName, File signedFile, Document doc) {
        this._fileType = FileType.XML;
        this._sigID = sigID;
        this._sigValue = sigValue;
        this._sigSubjectName = sigSubjectName;
        if (signedFile.exists()) {
            this._fileName = signedFile.getName();
            this._filePath = signedFile.getAbsolutePath();
            this._fileSize = signedFile.length();
            try {
                this._checksum = MD5Helper.getMD5FromFile(signedFile.getAbsolutePath());
                if (this._sigID != null) {
                    this._sigValid = XmlSecFassade.getInstance().verifySignature(doc, this._sigID);
                }
                SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                this._signingTime = sdf.format(new Date());
                this._signDate = new Date();
            }
            catch (Exception ex) {
                _logger.error("Fehler beim Verarbeiten der Signatur: " + this._sigID, (Throwable)ex);
            }
        } else {
            _logger.error("Datei exisitiert nicht: " + signedFile.getAbsolutePath());
        }
    }

    public FileSignInfo(String sigID, boolean sigValid, String sigSubjectName, File signedFile, Date signDate) {
        this._fileType = FileType.PDF;
        this._sigID = sigID;
        this._sigSubjectName = sigSubjectName;
        this._sigValid = sigValid;
        this._sigValue = null;
        this._sigNodeName = null;
        if (signedFile.exists()) {
            this._fileName = signedFile.getName();
            this._filePath = signedFile.getAbsolutePath();
            this._fileSize = signedFile.length();
            try {
                this._checksum = MD5Helper.getMD5FromFile(signedFile.getAbsolutePath());
                SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                this._signingTime = sdf.format(signDate);
                this._signDate = signDate;
            }
            catch (Exception ex) {
                _logger.error("Fehler beim Verarbeiten der Signatur: " + this._sigID, (Throwable)ex);
            }
        } else {
            _logger.error("Datei exisitiert nicht: " + signedFile.getAbsolutePath());
        }
    }

    public String getType() {
        return this._fileType.toString();
    }

    public void setType(FileType type) {
        this._fileType = type;
    }

    public String getSigID() {
        return this._sigID;
    }

    public void setSigID(String sigID) {
        this._sigID = sigID;
    }

    public String getSigValue() {
        return this._sigValue;
    }

    public void setSigValue(String sigValue) {
        this._sigValue = sigValue;
    }

    public String getSigSubjectName() {
        return this._sigSubjectName;
    }

    public void setSigSubjectName(String sigSubjectName) {
        this._sigSubjectName = sigSubjectName;
    }

    public String getFileName() {
        return this._fileName;
    }

    public void setFileName(String fileName) {
        this._fileName = fileName;
    }

    public String getFilePath() {
        return this._filePath;
    }

    public void setFilePath(String filePath) {
        this._filePath = filePath;
    }

    public long getFileSize() {
        return this._fileSize;
    }

    public void setFileSize(long fileSize) {
        this._fileSize = fileSize;
    }

    public String getChecksum() {
        return this._checksum;
    }

    public void setChecksum(String checksum) {
        this._checksum = checksum;
    }

    public String getChecksumMethod() {
        return CHECKSUM_METHOD;
    }

    public boolean getSigValid() {
        return this._sigValid;
    }

    public void setSigValid(boolean sigValid) {
        this._sigValid = sigValid;
    }

    public String getSigNodeName() {
        return this._sigNodeName;
    }

    public void setSigNodeName(String sigNodeName) {
        this._sigNodeName = sigNodeName;
    }

    public String getSigningTime() {
        return this._signingTime;
    }

    public void setSigningTime(String signingTime) {
        this._signingTime = signingTime;
    }

    public Date getSignDate() {
        return this._signDate;
    }

    public void setSignDate(Date signDate) {
        this._signDate = signDate;
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        this._signingTime = sdf.format(signDate);
    }

    public boolean getIsTimeStamped() {
        return this._timeStamp;
    }

    public void setIsTimeStamped(boolean timeStamp) {
        this._timeStamp = timeStamp;
    }

    public boolean getIsTimeStampValid() {
        return this._timeStampValid;
    }

    public void setIsTimeStampValid(boolean timeStampValid) {
        this._timeStampValid = timeStampValid;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("\n<FileSignInfo>");
        buf.append("\nDocument-Typ: ");
        buf.append((Object)this._fileType);
        buf.append("\nSignature-ID: ");
        buf.append(this._sigID);
        if (this._sigValue != null) {
            buf.append("\nSignature-Value: \n");
            buf.append(this._sigValue);
        }
        buf.append("\nFile-Name: ");
        buf.append(this._fileName);
        buf.append("\nFile-Path: ");
        buf.append(this._filePath);
        buf.append("\nFile-Size: ");
        buf.append(this._fileSize);
        buf.append("\nPr\u00fcfsumme (MD5): ");
        buf.append(this._checksum);
        buf.append("\nSignatur ist g\u00fcltig: ");
        buf.append(this._sigValid);
        buf.append("\nSignaturzeitpunkt: ");
        buf.append(this._signingTime);
        buf.append("\nName des Unterzeichners: ");
        buf.append(this._sigSubjectName);
        buf.append("\nZeitstempel: ");
        buf.append(this._timeStamp);
        buf.append("\nZeitstempel g\u00fcltig: ");
        buf.append(this._timeStampValid);
        return buf.toString();
    }

    public static enum FileType {
        XML,
        PDF;

    }
}

