<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:dyn="http://exslt.org/dynamic" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#"
	xmlns:zks="uri:BMU_Waste_Interface/ZKS"
	xmlns:wsr="uri:BMU_Waste_Interface/DiWaSS"
	xmlns:sepa="uri:BMU_Waste_Interface/SEPA" 
	xmlns:kop="uri:AnzeigeErlaubnis/Kopie_TypBibliothek"
	xmlns:abf="uri:AnzeigeErlaubnis/AbfAEV" 
	extension-element-prefixes="dyn"
	exclude-result-prefixes="xsl dyn lib ds zks wsr sepa">
	<xsl:import href="ZKS-Library.xsl"/>
	<xsl:output method="html"/>
	<!-- bei neuladen übergebene Parameter -->
	<xsl:param name="positionsnummer" select="1"/>

	<xsl:variable name="MAX_ZEICHEN_MEMO" select="2400"/>

	<xsl:template match="/">
		<xsl:for-each select="//zks:DiWaSSRegAntwort">
			<xsl:if test="position()=$positionsnummer">
				<html>
					<head>
						<title>DIWASS-Registrierungsquittung</title>
						<!-- CSS - Datei -->
						<xsl:call-template name="Style"/>
					</head>
					<body>
						<xsl:call-template name="Kopf"/>
						<xsl:call-template name="Reg"/>
						<xsl:call-template name="Dateianhang"/>
						<!--xsl:call-template name="showSigLayer"/-->
					</body>
				</html>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="Reg">
		<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
			<tr>
				<td/>
			</tr>
			<tr>
				<td>
					<div id="Nummer">DIWASS-Registrierungsquittung</div>
				</td>
			</tr>
			<tr>
				<td>
					<xsl:call-template name="DQT"/>
					<!--xsl:call-template name="Zeile1"/>
					<xsl:call-template name="Zeile2"/>
					<xsl:call-template name="Zeile3"/>
					<xsl:call-template name="Zeile4"/-->
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="DQT">
		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td id="Titel">Quittung für</td>
			</tr>
			<tr>
				<td>
					<table id="tabelle_ohne" width="100%">
						<colgroup>
							<col width="20%"/>
							<col width="20%"/>
							<col width="30%"/>
							<col width="30%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">Benutzerautorisierung</td>
							<td id="Titel_klein">Standortregistrierung</td>
							<td id="Titel_klein">Antrag UUID</td>
							<td id="Titel_klein">Standort UUID</td>
						</tr>
						<tr>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:if test="wsr:ReplyOnUserAuthorisation='true' or wsr:ReplyOnUserAuthorisation='1'">
												<td id="Aktuell">
													<xsl:value-of select="'X'"/>
												</td>
											</xsl:if>
										</td>
									</tr>
								</table>
							</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:if test="wsr:ReplyOnUserAuthorisation='false' or wsr:ReplyOnUserAuthorisation='0'">
												<td id="Aktuell">
													<xsl:value-of select="'X'"/>
												</td>
											</xsl:if>
										</td>
									</tr>
								</table>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="wsr:RequestUUID"/>
							</td>
								<td id="Aktuell">
									<xsl:value-of select="wsr:Site/wsr:SiteUUID"/>
								</td>
						</tr>
						<tr>
							<td colspan="4" id="Titel_klein">E-Mail für Benachrichtigung</td>
						</tr>
						<tr>
							<td colspan="4" id="Aktuell">
								<xsl:value-of select="wsr:ContactEMailURI"/>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>

		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td id="Titel">Stand der Bearbeitung</td>
			</tr>
			<tr>
				<td>
					<table id="tabelle_ohne" width="100%">
						<colgroup>
							<col width="20%"/>
							<col width="80%"/>
						</colgroup>
						<tr>
							<td colspan="2" id="Aktuell">
								<xsl:value-of select="wsr:RequestResult/wsr:ResultDescription"/>
							</td>
						</tr>
						<tr>
							<td id="Titel_klein">Ergebnis positiv</td>
							<td id="Titel_klein">Datum</td>
						</tr>
						<tr>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:if test="wsr:RequestResult/wsr:Status='true' or wsr:RequestResult/wsr:Status='1'">
												<td id="Aktuell">
													<xsl:value-of select="'X'"/>
												</td>
											</xsl:if>
										</td>
									</tr>
								</table>
							</td>
							<td id="Aktuell">
								<xsl:call-template name="formatDate">
									<xsl:with-param name="date" select="wsr:CompetentAuthority/wsr:DateOfDecision"/>
								</xsl:call-template>
							</td>
						</tr>
						<tr>
							<td colspan="2" id="Titel_klein">Hinweise und Begründungen zur Entscheidung</td>
						</tr>
						<tr>
							<td colspan="2" id="Aktuell">
								<xsl:value-of select="wsr:CompetentAuthority/wsr:Description"/>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		
		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td id="Titel">Zuständige Behörde</td>
			</tr>

			<xsl:for-each select="wsr:CompetentAuthority">
				<tr>
					<td>
						<table id="Tabelle_ohne" width="100%">
							<colgroup>
								<col width="10%"/>
								<col width="15%"/>
								<col width="75%"/>
							</colgroup>
							<tr>
								<td colspan="3" id="Titel_klein">Codenummer DIWASS</td>
							</tr>
							<tr>
								<td colspan="3" id="Aktuell">
									<xsl:value-of select="wsr:CodeNumber"/>
								</td>
							</tr>
							<tr>
								<td colspan="3" id="Titel_klein">Name</td>
							</tr>
							<tr>
								<td colspan="3" id="Aktuell">
									<xsl:value-of select="wsr:Name/lib:Name1"/>&#173; 
									<xsl:value-of select="wsr:Name/lib:Name2"/>&#173;
									<xsl:value-of select="wsr:Name/lib:Name3"/>&#173;
									<xsl:value-of select="wsr:Name/lib:Name4"/>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">Straße</td>
								<td/>
								<td/>
							</tr>
							<tr>
								<td colspan="3" id="Aktuell">
									<xsl:value-of select="wsr:Adresse/lib:Strasse_1"/>&#173; 
									<xsl:value-of select="wsr:Adresse/lib:Strasse_2"/>&#173;
									<xsl:value-of select="wsr:Adresse/lib:Hausnummer"/>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">Staat</td>
								<td id="Titel_klein">Postleitzahl</td>
								<td id="Titel_klein">Ort</td>
							</tr>
							<tr>
								<td id="Aktuell">
									<xsl:value-of select="wsr:Adresse/lib:Staat"/>
								</td>
								<td id="Aktuell">
									<xsl:value-of select="wsr:Adresse/lib:Postleitzahl"/>
								</td>
								<td id="Aktuell">
									<xsl:value-of select="wsr:Adresse/lib:Ort_1"/>&#173;
									<xsl:value-of select="wsr:Adresse/lib:Ort_2"/>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td>
						<table id="Tabelle_ohne" width="100%">
							<colgroup>
								<col width="50%"/>
								<col width="25%"/>
								<col width="25%"/>
							</colgroup>
							<tr>
								<td id="Titel_klein">Person</td>
								<td id="Titel_klein">Telefon</td>
								<td id="Titel_klein">Fax</td>
							</tr>
							<tr>
								<td id="Aktuell">
									<xsl:value-of select="wsr:Contact/wsr:Name"/>
								</td>
								<td id="Aktuell">
									<xsl:value-of select="wsr:Contact/wsr:TelephoneCompleteNumber"/>
								</td>
								<td id="Aktuell">
									<xsl:value-of select="wsr:Contact/wsr:FaxCompleteNumber"/>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td>
						<table id="Tabelle_ohne" width="100%">
							<tr>
								<td id="Titel_klein">EMail</td>
							</tr>
							<tr>
								<td id="Aktuell">
									<xsl:value-of select="wsr:Contact/wsr:EmailURI"/>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</xsl:for-each>
		</table>

		
		<table id="Tabelle" width="100%">
			<tr>
				<td id="Titel">Standort</td>
			</tr>
			<xsl:for-each select="wsr:Site">
				<tr>
					<td>
						<table id="Tabelle_ohne" width="100%">
							<colgroup>
								<col width="50%"/>
								<col width="50%"/>
							</colgroup>
							<tr>
								<td id="Titel_klein">Hauptidentifizierungsnummer Typ</td>
								<td id="Titel_klein">Hauptidentifizierungsnummer Wert</td>
							</tr>
							<tr>
								<td id="Aktuell">
									<xsl:value-of select="../wsr:MainIdentification/wsr:IdentifierValue/@wsr:IdentifierName"/>
								</td>
								<td id="Aktuell">
									<xsl:value-of select="../wsr:MainIdentification/wsr:IdentifierValue"/>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td>
						<table id="Tabelle_ohne" width="100%">
							<colgroup>
								<col width="10%"/>
								<col width="40%"/>
								<col width="50%"/>
							</colgroup>
							<tr>
								<td id="Titel_klein">Hauptstandort</td>
								<td id="Titel_klein">Technische Kennung</td>
								<td id="Titel_klein">Technische Kennung des Hauptstandortes</td>
							</tr>
							<tr>
								<td>
									<table id="Tabelle_indikator">
										<tr>
											<td>
												<xsl:if test="wsr:IndicatorMainSite='true' or wsr:IndicatorMainSite='1'">
													<td id="Aktuell">
														<xsl:value-of select="'X'"/>
													</td>
												</xsl:if>
											</td>
										</tr>
									</table>
								</td>
								<td id="AktuellBig">
									<xsl:value-of select="wsr:OperatorID"/>
								</td>
								<td id="AktuellBig">
									<xsl:value-of select="../wsr:LinkedOperatorID"/>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				
				<tr>
					<td>
						<table id="Tabelle_ohne" width="100%">
							<tr>
								<td id="Titel_klein">Name</td>
							</tr>
							<tr>
								<td id="Aktuell">
									<xsl:value-of select="wsr:SiteDetails/wsr:NameAndAddress/wsr:Name"/>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">Straße</td>
							</tr>
							<tr>
								<td id="Aktuell">
									<xsl:value-of select="wsr:SiteDetails/wsr:NameAndAddress/wsr:Address/wsr:AddressDetails"/>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td>
						<table id="Tabelle_ohne" width="100%">
							<colgroup>
								<col width="10%"/>
								<col width="15%"/>
								<col width="40%"/>
								<col width="20%"/>
								<col width="20%"/>
							</colgroup>
							<tr>
								<td/>
							</tr>
							<tr>
								<td id="Titel_klein">Staat</td>
								<td id="Titel_klein">Postleizahl</td>
								<td id="Titel_klein">Ort</td>
								<td id="Titel_klein">East-Wert</td>
								<td id="Titel_klein">North-Wert</td>
							</tr>
							<tr>
								<td id="Aktuell">
									<xsl:value-of select="wsr:SiteDetails/wsr:NameAndAddress/wsr:Address/wsr:CountryCode"/>
								</td>
								<td id="Aktuell">
									<xsl:value-of select="wsr:SiteDetails/wsr:NameAndAddress/wsr:Address/wsr:Postcode"/>
								</td>
								<td id="Aktuell">
									<xsl:value-of select="wsr:SiteDetails/wsr:NameAndAddress/wsr:Address/wsr:CityName"/>
								</td>
								<td id="Aktuell">
									<xsl:value-of select="wsr:SiteDetails/wsr:NameAndAddress/wsr:Address/wsr:Longitude"/>
								</td>
								<td id="Aktuell">
									<xsl:value-of select="wsr:SiteDetails/wsr:NameAndAddress/wsr:Address/wsr:Latitude"/>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td>
						<table id="Tabelle_ohne" width="100%">
							<colgroup>
								<col width="50%"/>
								<col width="25%"/>
								<col width="25%"/>
							</colgroup>
							<tr>
								<td id="Titel_klein">Person</td>
								<td id="Titel_klein">Telefon</td>
								<td id="Titel_klein">Fax</td>
							</tr>
							<tr>
								<td id="Aktuell">
									<xsl:value-of select="wsr:SiteDetails/wsr:Contact/wsr:Name"/>
								</td>
								<td id="Aktuell">
									<xsl:value-of select="wsr:SiteDetails/wsr:Contact/wsr:TelephoneCompleteNumber"/>
								</td>
								<td id="Aktuell">
									<xsl:value-of select="wsr:SiteDetails/wsr:Contact/wsr:FaxCompleteNumber"/>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td>
						<table id="Tabelle_ohne" width="100%">
							<colgroup>
								<col width="50%"/>
								<col width="50%"/>
							</colgroup>
							<tr>
								<td id="Titel_klein">EMail</td>
								<td id="Titel_klein">Homepage</td>
							</tr>
							<tr>
								<td id="Aktuell">
									<xsl:value-of select="wsr:SiteDetails/wsr:Contact/wsr:EmailURI"/>
								</td>
								<td id="Aktuell">
									<xsl:value-of select="wsr:SiteDetails/wsr:Contact/wsr:WebsiteURI"/>
								</td>
								<td/>
							</tr>
						</table>
					</td>
				</tr>
				<xsl:if test="count(wsr:RegistrationNumberList)>0">
					<tr>
						<td id="Titel">Registriernummern</td>
					</tr>
					<xsl:for-each select="wsr:RegistrationNumberList/wsr:RegistrationNumber">
						<tr>
							<td>
								<table id="Tabelle_ohne" width="100%">
									<colgroup>
										<col width="15%"/>
										<col width="5%"/>
									</colgroup>
									<xsl:if test="position()=1">
										<tr>
											<td id="Titel_klein">Behördliche Nummer</td>
											<td id="Titel_klein">Rolle</td>
										</tr>
									</xsl:if>
									<tr>
										<td id="Aktuell">
											<xsl:value-of select="lib:BehoerdlicheNr"/>
											<xsl:value-of select="lib:Pruefziffer"/>
										</td>
										<td id="Aktuell">
											<xsl:value-of select="@wsr:ATBRolle"/>
										</td>
										<td/>
									</tr>
								</table>
							</td>
						</tr>
					</xsl:for-each>
				</xsl:if>
				<xsl:if test="count(wsr:ThirdCountryIDList)>0">
					<tr>
						<td id="Titel">Registriernummern nicht EU</td>
					</tr>
					<xsl:for-each select="wsr:ThirdCountryIDList/wsr:ThirdCountryID">
						<tr>
							<td>
								<table id="Tabelle_ohne" width="100%">
									<colgroup>
										<col width="50%"/>
										<col width="50%"/>
									</colgroup>
									<xsl:if test="position()=1">
										<tr>
											<td id="Titel_klein">Typ</td>
											<td id="Titel_klein">Wert</td>
										</tr>
									</xsl:if>
									<tr>
										<td id="Aktuell">
											<xsl:value-of select="wsr:IdentifierValue/@wsr:IdentifierName"/>
										</td>
										<td id="Aktuell">
											<xsl:value-of select="wsr:IdentifierValue"/>
										</td>
										<td/>
									</tr>
								</table>
							</td>
						</tr>
					</xsl:for-each>
				</xsl:if>
				<xsl:if test="count(wsr:OtherIdentifierList)>0">
					<tr>
						<td id="Titel">Weitere Kennungen</td>
					</tr>
					<xsl:for-each select="wsr:OtherIdentifierList/wsr:OtherIdentifier">
						<tr>
							<td>
								<table id="Tabelle_ohne" width="100%">
									<colgroup>
										<col width="50%"/>
										<col width="50%"/>
									</colgroup>
									<xsl:if test="position()=1">
										<tr>
											<td id="Titel_klein">Typ</td>
											<td id="Titel_klein">Wert</td>
										</tr>
									</xsl:if>
									<tr>
										<td id="Aktuell">
											<xsl:value-of select="wsr:IdentifierValue/@wsr:IdentifierName"/>
										</td>
										<td id="Aktuell">
											<xsl:value-of select="wsr:IdentifierValue"/>
										</td>
										<td/>
									</tr>
								</table>
							</td>
						</tr>
					</xsl:for-each>
				</xsl:if>			
				<xsl:if test="count(wsr:UsersEULogin)>0">
					<tr>
						<td id="Titel">Autorisierte Person</td>
					</tr>
					<tr>
						<td>
							<table id="Tabelle_ohne" width="100%">
								<colgroup>
									<col width="50%"/>
									<col width="50%"/>
								</colgroup>
								<xsl:if test="position()=1">
									<tr>
										<td id="Titel_klein">EU-Login Benutzername</td>
										<td id="Titel_klein">E-Mail</td>
									</tr>
								</xsl:if>
								<tr>
									<td id="Aktuell">
										<xsl:value-of select="wsr:UsersEULogin"/>
									</td>
									<td id="Aktuell">
										<xsl:value-of select="wsr:UsersEMail"/>
									</td>
									<td/>
								</tr>
							</table>
						</td>
					</tr>
				</xsl:if>			
			</xsl:for-each>
		</table>
	</xsl:template>

	<xsl:template name="Dateianhang">
		<table width="100%" border="0">
			<tr align="left">
				<td id="Text_normal ">Dateianhang:</td>
			</tr>
		<xsl:if test="count(//wsr:Dateianhang) > 0">
			<table width="100%" border="0">
			<tr>
				<td>
					<br/>
					<ul>
						<xsl:for-each select="//wsr:Dateianhang">
							<font id="Aktuell">
								<li>
									<xsl:value-of select="@lib:dateiname"/>
								</li>
							</font>
						</xsl:for-each>
					</ul>
				</td>
			</tr>
			</table>
			<!--xsl:call-template name="ListAnhang"/-->
		</xsl:if>
		</table>

	</xsl:template>

</xsl:stylesheet>
