<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:dyn="http://exslt.org/dynamic" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#"
	xmlns:zks="uri:BMU_Waste_Interface/ZKS"
	xmlns:wsr="uri:BMU_Waste_Interface/DiWaSS"
	xmlns:sepa="uri:BMU_Waste_Interface/SEPA" 
	xmlns:kop="uri:AnzeigeErlaubnis/Kopie_TypBibliothek"
	xmlns:abf="uri:AnzeigeErlaubnis/AbfAEV" 
	extension-element-prefixes="dyn"
	exclude-result-prefixes="xsl dyn lib ds zks wsr sepa">
	<xsl:import href="ZKS-Library.xsl"/>
	<xsl:output method="html"/>
	<!-- bei neuladen übergebene Parameter -->
	<xsl:param name="positionsnummer" select="1"/>

	<xsl:variable name="MAX_ZEICHEN_MEMO" select="2400"/>

	<xsl:template match="/">
		<xsl:for-each select="//wsr:Request">
			<xsl:if test="position()=$positionsnummer">
				<html>
					<head>
						<title>Antrag auf Standortregistrierung im DIWASS und Erklärung zur Vertretungsberechtigung</title>
						<!-- CSS - Datei -->
						<xsl:call-template name="Style"/>
					</head>
					<body>
						<xsl:call-template name="Kopf"/>
						<xsl:call-template name="Reg"/>
						<xsl:call-template name="Dateianhang"/>
						<!--xsl:call-template name="showSigLayer"/-->
					</body>
				</html>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="Reg">
		<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
			<tr>
				<td/>
			</tr>
			<tr>
				<td>
					<div id="Nummer">Antrag auf Standortregistrierung im DIWASS und Erklärung zur Vertretungsberechtigung</div>
				</td>
			</tr>
			<tr>
				<td>
					<xsl:call-template name="DReg"/>
					<!--xsl:call-template name="Zeile1"/>
					<xsl:call-template name="Zeile2"/>
					<xsl:call-template name="Zeile3"/>
					<xsl:call-template name="Zeile4"/-->
				</td>
			</tr>
			<xsl:if test="count(//ds:Signature)>0">
				<tr>
					<td>
						<table width="100%">
							<tr width="100%">
								<td width="50%" id="Titel">Unterschrift (Signatur)</td>
								<td width="50%" id="Titel">2. Unterschrift (2. Signatur)</td>
							</tr>
							<tr width="100%">
								<td width="50%">
									<xsl:call-template name="Sig1NameNoLayer"/>
								</td>
								<td width="50%">
									<xsl:call-template name="Sig2NameNoLayer"/>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<xsl:template name="DReg">
		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td>
					<table id="tabelle_ohne" width="100%">
						<colgroup>
							<col width="20%"/>
							<col width="80%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">Antrag an Bundesland</td>
							<td id="Titel_klein">Antrag UUID</td>
						</tr>
						<tr>
							<td id="Aktuell">
								<xsl:value-of select="wsr:State"/>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="wsr:RequestUUID"/>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td>
					<table id="tabelle_ohne" width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="30%"/>
							<col width="3%"/>
							<col width="30%"/>
							<col width="3%"/>
							<col width="31%"/>
						</colgroup>
						<tr>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:if test="(wsr:ListOfSites/@wsr:SiteRegistration='true' or wsr:ListOfSites/@wsr:SiteRegistration='1') and count(wsr:MasterUserRegistration)>0">
												<td id="Aktuell">
													<xsl:value-of select="'X'"/>
												</td>
											</xsl:if>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">Antrag auf Standortregistrierung und Erklärung zur Vertretungsberechtigung</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:if test="(wsr:ListOfSites/@wsr:SiteRegistration='true' or wsr:ListOfSites/@wsr:SiteRegistration='1') and count(wsr:MasterUserRegistration)=0">
												<td id="Aktuell">
													<xsl:value-of select="'X'"/>
												</td>
											</xsl:if>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">nur Antrag auf Standortregistrierung</td>							
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:if test="wsr:ListOfSites/@wsr:SiteRegistration='false' or wsr:ListOfSites/@wsr:SiteRegistration='0'">
												<td id="Aktuell">
													<xsl:value-of select="'X'"/>
												</td>
											</xsl:if>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">nur Erklärung zur Vertretungsberechtigung</td>
						</tr>
					</table>
				</td>
			</tr>
			<xsl:if test="count(wsr:ListOfSites/@wsr:RequestOperation)>0">
				<tr>
					<td>
						<table id="tabelle_ohne" width="100%">
							<colgroup>
								<col width="3%"/>
								<col width="30%"/>
								<col width="3%"/>
								<col width="30%"/>
								<col width="34%"/>
							</colgroup>
							<tr>
								<td>
									<table id="Tabelle_indikator">
										<tr>
											<td>
												<xsl:if test="wsr:ListOfSites/@wsr:RequestOperation='new'">
													<td id="Aktuell">
														<xsl:value-of select="'X'"/>
													</td>
												</xsl:if>
											</td>
										</tr>
									</table>
								</td>
								<td id="Titel_klein">Erstmaliger Antrag</td>
								<td>
									<table id="Tabelle_indikator">
										<tr>
											<td>
												<xsl:if test="wsr:ListOfSites/@wsr:RequestOperation='update'">
													<td id="Aktuell">
														<xsl:value-of select="'X'"/>
													</td>
												</xsl:if>
											</td>
										</tr>
									</table>
								</td>
								<td id="Titel_klein">Änderungsantrag</td>	
								<td/>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td>
						<table id="tabelle_ohne" width="100%">
							<tr>
								<td id="Titel_klein">Änderungsgrund</td>
							</tr>
							<tr>
								<td id="Aktuell">
									<xsl:value-of select="wsr:ListOfSites/wsr:ReasonForUpdate"/>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</xsl:if>
		</table>
		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td id="Titel">Kontaktperson für den Antrag</td>
			</tr>
			<tr>
				<td>
					<table id="tabelle_ohne" width="100%">
						<colgroup>
							<col width="50%"/>
							<col width="50%"/>
						</colgroup>
						<tr>
							<td/>
						</tr>
						<tr>
							<td id="Titel_klein">Name</td>
							<td id="Titel_klein">Telefon</td>
						</tr>
						<tr>
							<td id="Aktuell">
								<xsl:value-of select="wsr:Contact/wsr:Name"/>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="wsr:Contact/wsr:TelephoneCompleteNumber"/>
							</td>
						</tr>
						<tr>
							<td id="Titel_klein">EMail</td>
							<td/>
						</tr>
						<tr>
							<td id="Aktuell">
								<xsl:value-of select="wsr:Contact/wsr:EmailURI"/>
							</td>
							<td/>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		<xsl:if test="count(wsr:Contact/wsr:NameAndAddress)>0">
			<xsl:for-each select="wsr:Contact/wsr:NameAndAddress">
				<table id="Tabelle_nicht_oben_unten" width="100%">
					<colgroup>
						<col width="10%"/>
						<col width="15%"/>
						<col width="75%"/>
					</colgroup>
					<tr>
						<td colspan="3" id="Titel">An der Verbringung beteiligter Erzeuger / beteiligte Entsorgungsanlage</td>
					</tr>
					<tr>
						<td id="Titel_klein">Name</td>
						<td/>
						<td/>
					</tr>
					<tr>
						<td colspan="3" id="Aktuell">
							<xsl:value-of select="wsr:Name/lib:Name1"/>&#173; 
							<xsl:value-of select="wsr:Name/lib:Name2"/>&#173;
							<xsl:value-of select="wsr:Name/lib:Name3"/>&#173;
							<xsl:value-of select="wsr:Name/lib:Name4"/>
						</td>
					</tr>
					<tr>
						<td id="Titel_klein">Straße</td>
						<td/>
						<td/>
					</tr>
					<tr>
						<td colspan="3" id="Aktuell">
							<xsl:value-of select="wsr:Adresse/lib:Strasse_1"/>&#173; 
							<xsl:value-of select="wsr:Adresse/lib:Strasse_2"/>&#173;
							<xsl:value-of select="wsr:Adresse/lib:Hausnummer"/>
						</td>
					</tr>
					<tr>
						<td id="Titel_klein">Staat</td>
						<td id="Titel_klein">Postleitzahl</td>
						<td id="Titel_klein">Ort</td>
					</tr>
					<tr>
						<td id="Aktuell">
							<xsl:value-of select="wsr:Adresse/lib:Staat"/>
						</td>
						<td id="Aktuell">
							<xsl:value-of select="wsr:Adresse/lib:Postleitzahl"/>
						</td>
						<td id="Aktuell">
							<xsl:value-of select="wsr:Adresse/lib:Ort_1"/>&#173;
							<xsl:value-of select="wsr:Adresse/lib:Ort_2"/>
						</td>
					</tr>
				</table>
				<table id="Tabelle_nicht_oben_unten" width="100%">
					<tr>
						<td>
							<table id="Tabelle_ohne" width="100%">
								<colgroup>
									<col width="15%"/>
									<col width="85%"/>
								</colgroup>
								<tr>
									<td id="Titel_klein">Gemeinde</td>
									<td id="Titel_klein"></td>
								</tr>
								<tr>
									<td id="Aktuell">
										<xsl:value-of select="wsr:Municipality/wsr:Code"/>
									</td>
									<td id="Aktuell">
										<xsl:value-of select="wsr:Municipality/wsr:Name"/>
									</td>
									<td/>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</xsl:for-each>
		</xsl:if>
		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td id="Titel" align="left">Betreiber - Nummern und Kenner</td>
			</tr>
			<tr>
				<td>
					<table id="tabelle_ohne" width="100%">
						<colgroup>
							<col width="40%"/>
							<col width="60%"/>
						</colgroup>
						<tr>
							<td/>
						</tr>
						<tr>
							<td id="Titel_klein">EORI-Nummer</td>
							<td id="Titel_klein">Wirtschaftsnummer</td>
						</tr>
						<tr>
							<td id="Aktuell">
								<xsl:value-of select="wsr:MainIdentification/wsr:EORINr"/>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="wsr:MainIdentification/wsr:BundeseinhWirtschaftsNr"/>
							</td>
						</tr>
						<tr>
							<td id="Titel_klein">Identifizierungsnummer Drittstaat: Typ</td>
							<td id="Titel_klein">Identifizierungsnummer Drittstaat: Wert</td>
						</tr>
						<tr>
							<td id="Aktuell">
								<xsl:value-of select="wsr:MainIdentification/wsr:ThirdCountryID/wsr:IdentifierValue/@wsr:IdentifierName"/>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="wsr:MainIdentification/wsr:ThirdCountryID/wsr:IdentifierValue"/>
							</td>
							<td/>
						</tr>
						<tr>
							<td id="Titel_klein">Hauptstandort in Bundesland</td>
							<td id="Titel_klein">Technische Kennung des Hauptstandortes</td>
						</tr>
						<tr>
							<td id="Aktuell">
								<xsl:value-of select="wsr:MainIdentification/wsr:MainIDRegisteredByState"/>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="wsr:LinkedOperatorID"/>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>

		<table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td id="Nummer2">Standorte</td>
			</tr>
			<xsl:variable name="SITES_COUNT" select="count(//wsr:Site)"/>
			<xsl:for-each select="wsr:ListOfSites/wsr:Site">
				<tr>
					<td>
						<table id="Tabelle_ohne" width="100%">
							<colgroup>
								<col width="5%"/>
								<col width="15%"/>
								<col width="40%"/>
								<col width="40%"/>
							</colgroup>
							<tr>
								<td/>
							</tr>
							<tr>
								<td id="Titel_klein">Nr.</td>
								<td id="Titel_klein">Hauptstandort</td>
								<td id="Titel_klein">Standort UUID</td>
								<td id="Titel_klein">Technische Kennung</td>
							</tr>
							<tr>
								<td>
									<xsl:value-of select="position()"/>
								</td>
								<td>
									<table id="Tabelle_indikator">
										<tr>
											<td>
												<xsl:if test="wsr:IndicatorMainSite='true' or wsr:IndicatorMainSite='1'">
													<td id="Aktuell">
														<xsl:value-of select="'X'"/>
													</td>
												</xsl:if>
											</td>
										</tr>
									</table>
								</td>
								<td id="Aktuell">
									<xsl:value-of select="wsr:SiteUUID"/>
								</td>
								<td id="Aktuell">
									<xsl:value-of select="wsr:OperatorID"/>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td>
						<table id="Tabelle_ohne" width="100%">
							<tr>
								<td id="Titel_klein">Name</td>
							</tr>
							<tr>
								<td id="Aktuell">
									<xsl:value-of select="wsr:SiteDetails/wsr:NameAndAddress/wsr:Name"/>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">Straße</td>
							</tr>
							<tr>
								<td id="Aktuell">
									<xsl:value-of select="wsr:SiteDetails/wsr:NameAndAddress/wsr:Address/wsr:AddressDetails"/>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td>
						<table id="Tabelle_ohne" width="100%">
							<colgroup>
								<col width="10%"/>
								<col width="15%"/>
								<col width="40%"/>
								<col width="20%"/>
								<col width="20%"/>
							</colgroup>
							<tr>
								<td/>
							</tr>
							<tr>
								<td id="Titel_klein">Staat</td>
								<td id="Titel_klein">Postleizahl</td>
								<td id="Titel_klein">Ort</td>
								<td id="Titel_klein">East-Wert</td>
								<td id="Titel_klein">North-Wert</td>
							</tr>
							<tr>
								<td id="Aktuell">
									<xsl:value-of select="wsr:SiteDetails/wsr:NameAndAddress/wsr:Address/wsr:CountryCode"/>
								</td>
								<td id="Aktuell">
									<xsl:value-of select="wsr:SiteDetails/wsr:NameAndAddress/wsr:Address/wsr:Postcode"/>
								</td>
								<td id="Aktuell">
									<xsl:value-of select="wsr:SiteDetails/wsr:NameAndAddress/wsr:Address/wsr:CityName"/>
								</td>
								<td id="Aktuell">
									<xsl:value-of select="wsr:SiteDetails/wsr:NameAndAddress/wsr:Address/wsr:Longitude"/>
								</td>
								<td id="Aktuell">
									<xsl:value-of select="wsr:SiteDetails/wsr:NameAndAddress/wsr:Address/wsr:Latitude"/>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td>
						<table id="Tabelle_ohne" width="100%">
							<colgroup>
								<col width="50%"/>
								<col width="25%"/>
								<col width="25%"/>
							</colgroup>
							<tr>
								<td id="Titel_klein">Person</td>
								<td id="Titel_klein">Telefon</td>
								<td id="Titel_klein">Fax</td>
							</tr>
							<tr>
								<td id="Aktuell">
									<xsl:value-of select="wsr:SiteDetails/wsr:Contact/wsr:Name"/>
								</td>
								<td id="Aktuell">
									<xsl:value-of select="wsr:SiteDetails/wsr:Contact/wsr:TelephoneCompleteNumber"/>
								</td>
								<td id="Aktuell">
									<xsl:value-of select="wsr:SiteDetails/wsr:Contact/wsr:FaxCompleteNumber"/>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td>
						<table id="Tabelle_ohne" width="100%">
							<colgroup>
								<col width="50%"/>
								<col width="50%"/>
							</colgroup>
							<tr>
								<td id="Titel_klein">EMail</td>
								<td id="Titel_klein">Homepage</td>
							</tr>
							<tr>
								<td id="Aktuell">
									<xsl:value-of select="wsr:SiteDetails/wsr:Contact/wsr:EmailURI"/>
								</td>
								<td id="Aktuell">
									<xsl:value-of select="wsr:SiteDetails/wsr:Contact/wsr:WebsiteURI"/>
								</td>
								<td/>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td>
						<table id="Tabelle_ohne" width="100%">
							<colgroup>
								<col width="15%"/>
								<col width="85%"/>
							</colgroup>
							<tr>
								<td id="Titel_klein">Gemeinde</td>
								<td id="Titel_klein"></td>
							</tr>
							<tr>
								<td id="Aktuell">
									<xsl:value-of select="wsr:SiteDetails/wsr:Municipality/wsr:Code"/>
								</td>
								<td id="Aktuell">
									<xsl:value-of select="wsr:SiteDetails/wsr:Municipality/wsr:Name"/>
								</td>
								<td/>
							</tr>
						</table>
					</td>
				</tr>
				<xsl:if test="count(wsr:RegistrationNumberList)>0">
					<tr>
						<td id="Titel">Registriernummern</td>
					</tr>
					<xsl:for-each select="wsr:RegistrationNumberList/wsr:RegistrationNumber">
						<tr>
							<td>
								<table id="Tabelle_ohne" width="100%">
									<colgroup>
										<col width="15%"/>
										<col width="5%"/>
									</colgroup>
									<xsl:if test="position()=1">
										<tr>
											<td id="Titel_klein">Behördliche Nummer</td>
											<td id="Titel_klein">Rolle</td>
										</tr>
									</xsl:if>
									<tr>
										<td id="Aktuell">
											<xsl:value-of select="lib:BehoerdlicheNr"/>
											<xsl:value-of select="lib:Pruefziffer"/>
										</td>
										<td id="Aktuell">
											<xsl:value-of select="@wsr:ATBRolle"/>
										</td>
										<td/>
									</tr>
								</table>
							</td>
						</tr>
					</xsl:for-each>
				</xsl:if>
				<xsl:if test="count(wsr:ThirdCountryIDList)>0">
					<tr>
						<td id="Titel">Registriernummern Drittstaat</td>
					</tr>
					<xsl:for-each select="wsr:ThirdCountryIDList/wsr:ThirdCountryID">
						<tr>
							<td>
								<table id="Tabelle_ohne" width="100%">
									<colgroup>
										<col width="50%"/>
										<col width="50%"/>
									</colgroup>
									<xsl:if test="position()=1">
										<tr>
											<td id="Titel_klein">Typ</td>
											<td id="Titel_klein">Wert</td>
										</tr>
									</xsl:if>
									<tr>
										<td id="Aktuell">
											<xsl:value-of select="wsr:IdentifierValue/@wsr:IdentifierName"/>
										</td>
										<td id="Aktuell">
											<xsl:value-of select="wsr:IdentifierValue"/>
										</td>
										<td/>
									</tr>
								</table>
							</td>
						</tr>
					</xsl:for-each>
				</xsl:if>
				<xsl:if test="count(wsr:OtherIdentifierList)>0">
					<tr>
						<td id="Titel">Weitere Kennungen</td>
					</tr>
					<xsl:for-each select="wsr:OtherIdentifierList/wsr:OtherIdentifier">
						<tr>
							<td>
								<table id="Tabelle_ohne" width="100%">
									<colgroup>
										<col width="50%"/>
										<col width="50%"/>
									</colgroup>
									<xsl:if test="position()=1">
										<tr>
											<td id="Titel_klein">Typ</td>
											<td id="Titel_klein">Wert</td>
										</tr>
									</xsl:if>
									<tr>
										<td id="Aktuell">
											<xsl:value-of select="wsr:IdentifierValue/@wsr:IdentifierName"/>
										</td>
										<td id="Aktuell">
											<xsl:value-of select="wsr:IdentifierValue"/>
										</td>
										<td/>
									</tr>
								</table>
							</td>
						</tr>
					</xsl:for-each>
				</xsl:if>				
				<xsl:choose>
					<xsl:when test="$SITES_COUNT=position()">
					</xsl:when>
					<xsl:otherwise>
						<tr>
							<td>
								<table id="Tabelle_oben" width="100%">
									<tr>
										<td/>
									</tr>
								</table>
							</td>
						</tr>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
		</table>
		<xsl:choose>
			<xsl:when test="count(//wsr:MasterUserRegistration)>0">
				<xsl:for-each select="//wsr:MasterUserRegistration">
					<table id="Tabelle_nicht_unten" width="100%">
						<tr>
							<td id="Nummer2">Autorisierte Person</td>
						</tr>
					</table>
					<table id="Tabelle_nicht_unten" width="100%">
						<colgroup>
							<col width="50%"/>
							<col width="25%"/>
							<col width="25%"/>
						</colgroup>
						<tr>
							<td id="Titel_klein">Name</td>
							<td id="Titel_klein">EU Login</td>
							<td id="Titel_klein">EMail-Adresse</td>
						</tr>
						<tr>
							<td id="Aktuell">
								<xsl:value-of select="wsr:Name"/>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="wsr:UsersEULogin"/>
							</td>
							<td id="Aktuell">
								<xsl:value-of select="wsr:UsersEMail"/>
							</td>
						</tr>
					</table>
					<xsl:if test="count(wsr:RequestingParty)>0">
						<xsl:for-each select="wsr:RequestingParty">
							<table id="Tabelle_nicht_unten" width="100%">
								<colgroup>
									<col width="10%"/>
									<col width="15%"/>
									<col width="75%"/>
								</colgroup>
								<tr>
									<td colspan="3" id="Titel">Firma (wenn als Bevollmächtigter handelnd)</td>
								</tr>
								<tr>
									<td id="Titel_klein">Name</td>
									<td/>
									<td/>
								</tr>
								<tr>
									<td colspan="3" id="Aktuell">
										<xsl:value-of select="wsr:Name/lib:Name1"/>&#173; 
										<xsl:value-of select="wsr:Name/lib:Name2"/>&#173;
										<xsl:value-of select="wsr:Name/lib:Name3"/>&#173;
										<xsl:value-of select="wsr:Name/lib:Name4"/>
									</td>
								</tr>
								<tr>
									<td id="Titel_klein">Straße</td>
									<td/>
									<td/>
								</tr>
								<tr>
									<td colspan="3" id="Aktuell">
										<xsl:value-of select="wsr:Adresse/lib:Strasse_1"/>&#173; 
										<xsl:value-of select="wsr:Adresse/lib:Strasse_2"/>&#173;
										<xsl:value-of select="wsr:Adresse/lib:Hausnummer"/>
									</td>
								</tr>
								<tr>
									<td id="Titel_klein">Staat</td>
									<td id="Titel_klein">Postleitzahl</td>
									<td id="Titel_klein">Ort</td>
								</tr>
								<tr>
									<td id="Aktuell">
										<xsl:value-of select="wsr:Adresse/lib:Staat"/>
									</td>
									<td id="Aktuell">
										<xsl:value-of select="wsr:Adresse/lib:Postleitzahl"/>
									</td>
									<td id="Aktuell">
										<xsl:value-of select="wsr:Adresse/lib:Ort_1"/>&#173;
										<xsl:value-of select="wsr:Adresse/lib:Ort_2"/>
									</td>
								</tr>
							</table>
						</xsl:for-each>
					</xsl:if>
					<table id="Tabelle_nicht_unten" width="100%">
						<tr>
							<td id="Titel">Erklärung zur Vetretungsberechtigung</td>
						</tr>
						<tr>
							<td id="Titel_klein">Erklärung</td>
						</tr>
						<tr>
							<td id="Aktuell">
								<xsl:value-of select="wsr:DeclarationText"/>
							</td>
						</tr>
						<xsl:if test="count(wsr:AdditionalDeclarationText)>0">
							<tr>
								<td id="Titel_klein">Erklärung Zusatz</td>
							</tr>
							<tr>
								<td id="Aktuell">
									<xsl:value-of select="wsr:AdditionalDeclarationText"/>
								</td>
							</tr>
						</xsl:if>
					</table>
					<xsl:if test="count(wsr:RequestAuthorisationByMail)>0">
						<table id="Tabelle_nicht_unten" width="100%">
							<colgroup>
								<col width="3%"/>
								<col width="97%"/>
							</colgroup>
							<tr>
								<td>
									<table id="Tabelle_indikator">
										<tr>
											<td>
												<xsl:if test="wsr:RequestAuthorisationByMail='true' or wsr:RequestAuthorisationByMail='1'">
													<td id="Aktuell">
														<xsl:value-of select="'X'"/>
													</td>
												</xsl:if>
											</td>
										</tr>
									</table>
								</td>
								<td id="Titel_klein">Erklärung wird postalisch übersandt</td>
							</tr>
							<tr>
							</tr>
						</table>
					</xsl:if>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="count(//wsr:InvoiceRecipient)>0">
					<table id="Tabelle_oben" width="100%">
						<tr>
							<td/>
						</tr>
					</table>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>		
		<xsl:choose>
			<xsl:when test="count(//wsr:InvoiceRecipient)>0">
				<xsl:for-each select="//wsr:InvoiceRecipient">
					<table id="Tabelle_nicht_unten" width="100%">
						<tr>
							<td id="Nummer2">Rechnungsempfänger</td>
						</tr>
					</table>
					<table id="Tabelle_nicht_unten" width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="37%"/>
							<col width="3%"/>
							<col width="57%"/>
						</colgroup>
						<tr>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:if test="wsr:MainSiteIsRecipient='true' or wsr:MainSiteIsRecipient='1'">
												<td id="Aktuell">
													<xsl:value-of select="'X'"/>
												</td>
											</xsl:if>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">Rechnungsempfänger Hauptsitz</td>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:if test="wsr:SitesAreRecipiens='true' or wsr:SitesAreRecipiens='1'">
												<td id="Aktuell">
													<xsl:value-of select="'X'"/>
												</td>
											</xsl:if>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">Rechnungsempfänger Standort</td>
						</tr>
					</table>
					<xsl:choose>
						<xsl:when test="count(wsr:NameAndAddress)>0">
							<xsl:for-each select="wsr:NameAndAddress">
								<table id="Tabelle_nicht_unten" width="100%">
									<colgroup>
										<col width="10%"/>
										<col width="15%"/>
										<col width="75%"/>
									</colgroup>
									<tr>
										<td colspan="3" id="Titel">Abweichender Rechnungsempfänger</td>
									</tr>
									<tr>
										<td id="Titel_klein">Name</td>
										<td/>
										<td/>
									</tr>
									<tr>
										<td colspan="3" id="Aktuell">
											<xsl:value-of select="wsr:Name/lib:Name1"/>&#173; 
											<xsl:value-of select="wsr:Name/lib:Name2"/>&#173;
											<xsl:value-of select="wsr:Name/lib:Name3"/>&#173;
											<xsl:value-of select="wsr:Name/lib:Name4"/>
										</td>
									</tr>
									<tr>
										<td id="Titel_klein">Straße</td>
										<td/>
										<td/>
									</tr>
									<tr>
										<td colspan="3" id="Aktuell">
											<xsl:value-of select="wsr:Adresse/lib:Strasse_1"/>&#173; 
											<xsl:value-of select="wsr:Adresse/lib:Strasse_2"/>&#173;
											<xsl:value-of select="wsr:Adresse/lib:Hausnummer"/>
										</td>
									</tr>
									<tr>
										<td id="Titel_klein">Staat</td>
										<td id="Titel_klein">Postleitzahl</td>
										<td id="Titel_klein">Ort</td>
									</tr>
									<tr>
										<td id="Aktuell">
											<xsl:value-of select="wsr:Adresse/lib:Staat"/>
										</td>
										<td id="Aktuell">
											<xsl:value-of select="wsr:Adresse/lib:Postleitzahl"/>
										</td>
										<td id="Aktuell">
											<xsl:value-of select="wsr:Adresse/lib:Ort_1"/>&#173;
											<xsl:value-of select="wsr:Adresse/lib:Ort_2"/>
										</td>
									</tr>
								</table>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<!--table id="Tabelle_oben" width="100%">
								<tr>
									<td/>
								</tr>
							</table-->
						</xsl:otherwise>
					</xsl:choose>
					<xsl:if test="count(//sepa:SEPAData)=0">
						<table id="Tabelle_oben" width="100%">
							<tr>
								<td/>
							</tr>
						</table>
					</xsl:if>
				</xsl:for-each>
				<xsl:if test="count(//sepa:SEPAData)>0">
					<xsl:for-each select="//sepa:SEPAData">
						<table id="Tabelle_nicht_unten" width="100%">
							<tr>
								<td id="Nummer2">SEPA Lastschriftmandat</td>
							</tr>
						</table>
						<table id="Tabelle" width="100%">
							<colgroup>
								<col width="40%"/>
								<col width="60%"/>
							</colgroup>
							<tr>
								<td id="Titel_klein">SEPA-Mandat erteilt</td>
								<td id="Titel_klein">Mandatsreferenznummer</td>
							</tr>
							<tr>
								<td>
									<table id="Tabelle_indikator">
										<tr>
											<td>
												<xsl:if test="sepa:ZustimmungZuLastschriftErteilt='true' or sepa:ZustimmungZuLastschriftErteilt='1'">
													<td id="Aktuell">
														<xsl:value-of select="'X'"/>
													</td>
												</xsl:if>
											</td>
										</tr>
									</table>
								</td>
								<td id="Aktuell">
									<xsl:value-of select="sepa:Mandatsreferenz"/>
								</td>
							</tr>
							<tr>
								<td colspan="2" id="Titel_klein">Kontoinhaber</td>
							</tr>
							<tr>
								<td colspan="2" id="Aktuell">
									<xsl:value-of select="sepa:Kontoinhaber"/>
								</td>
							</tr>
							<tr>
								<td id="Titel_klein">IBAN</td>
								<td id="Titel_klein">BIC</td>
							</tr>
							<tr>
								<td id="Aktuell">
									<xsl:value-of select="sepa:IBAN"/>
								</td>
								<td id="Aktuell">
									<xsl:value-of select="sepa:BIC"/>
								</td>
							</tr>
							<tr>
								<td colspan="2" id="Titel_klein">Kundennummer</td>
							</tr>
							<tr>
								<td colspan="2" id="Aktuell">
									<xsl:value-of select="sepa:Kundennummer"/>
								</td>
							</tr>
						</table>				
					</xsl:for-each>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<table id="Tabelle_oben" width="100%">
					<tr>
						<td/>
					</tr>
				</table>
			</xsl:otherwise>
		</xsl:choose>		

		<!--table id="Tabelle_nicht_unten" width="100%">
			<tr>
				<td>
					<font id="Nummer">
						Anzeige von Sammlern, Beförderern, Händlern und Maklern von Abfällen
					</font>
				</td>
			</tr>
		</table>
		<table id="Tabelle_nicht_oben_unten" width="100%">
			<tr>
				<td>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="3%"/>
							<col width="94%"/>
						</colgroup>
						<tr>
							<td/>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:IndicatorErstmaligeAnzeige'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">Erstmalige Anzeige</td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td>
					<table width="100%">
						<colgroup>
							<col width="3%"/>
							<col width="3%"/>
							<col width="34%"/>
							<col width="40%"/>
							<col width="20%"/>
						</colgroup>
						<tr>
							<td/>
							<td>
								<table id="Tabelle_indikator">
									<tr>
										<td>
											<xsl:call-template name="getBooleanValue">
												<xsl:with-param name="TagName" select="'abf:IndicatorAenderungsanzeige'"/>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
							<td id="Titel_klein">Änderungsanzeige</td>
							<td id="Titel_klein">Vorgangsnummer (sofern von der Behörde erteilt)</td>
							<td id="Aktuell">
								<xsl:value-of select="abf:Vorgangsnummer/abf:Vorgangsnummer"/>
								&#173;
								<xsl:value-of select="abf:Vorgangsnummer/abf:Pruefziffer"/>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table-->
	</xsl:template>

	<xsl:template name="Dateianhang">
		<table width="100%" border="0">
			<tr align="left">
				<td id="Text_normal ">Dateianhang:</td>
			</tr>
			<xsl:if test="count(//wsr:Dateianhang) > 0">
				<table width="100%" border="0">
				<tr>
					<td>
						<br/>
						<ul>
							<xsl:for-each select="//wsr:Dateianhang">
								<font id="Aktuell">
									<li>
										<xsl:value-of select="@lib:dateiname"/>
									</li>
								</font>
							</xsl:for-each>
						</ul>
					</td>
				</tr>
				</table>
				<!--xsl:call-template name="ListAnhang"/-->
			</xsl:if>
		</table>

	</xsl:template>

</xsl:stylesheet>
