<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema" 
	xmlns:bgs="uri:BMU_Waste_Interface/BGS" 
	xmlns:en="uri:BMU_Waste_Interface/EN" 
	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek" 
	xmlns:cat="uri:BMU_Waste_Interface/Kataloge" 
	xmlns:msg="uri:BMU_Waste_Interface/Message" 
    xmlns:abfaev="uri:AnzeigeErlaubnis/AbfAEV" 
    xmlns:aevlib="uri:AnzeigeErlaubnis/Kopie_TypBibliothek"
	xmlns:b64="xalan://de.itu.util.Base64"
	xmlns:dyn="http://exslt.org/dynamic"	
	xmlns:redirect="http://xml.apache.org/xalan/redirect"
	extension-element-prefixes="b64 dyn redirect"
	exclude-result-prefixes="ds xs bgs en lib cat b64 redirect">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:param name="DOCNAME" select="'test.xml'"/>
	<xsl:param name="DOCPATH" select="'c:/temp/leanv'"/>
	<!--xsl:param name="DOCXPATH" select="'//msg:Mitteilung/msg:Dateianhang/lib:Binaerdaten'"/-->
	<xsl:param name="DOCID" select="'nsuite_ae_7a76a716-31d8-449b-889a-6550a7cc434a'"/>
	<!--xsl:param name="DOCID" select="'ID_bd811a5f-8211-4f7a-899a-97433e24341f'"/-->
	<xsl:template match="/">
		<xsl:variable name="filename" select="concat($DOCPATH, '/', $DOCNAME)"/>
		<xsl:for-each select="descendant::*[@lib:id=$DOCID]">
			<xsl:choose>
				<xsl:when test="local-name()='FreieXMLStruktur'">
					<redirect:write select="$filename">
						<xsl:copy-of select="*"/>
					</redirect:write>
				</xsl:when>
				<xsl:when test="local-name()='Dateianhang'">
					<xsl:value-of select="b64:decodeStringToFile(lib:Binaerdaten, $filename)"/>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
        <xsl:for-each select="descendant::*[@aevlib:id=$DOCID]">
            <xsl:choose>
                <xsl:when test="local-name()='FreieXMLStruktur'">
                    <redirect:write select="$filename">
                        <xsl:copy-of select="*"/>
                    </redirect:write>
                </xsl:when>
                <xsl:when test="local-name()='Dateianhang'">
                    <xsl:value-of select="b64:decodeStringToFile(aevlib:Binaerdaten, $filename)"/>
                </xsl:when>
            </xsl:choose>
        </xsl:for-each>
		<!--xsl:variable name="bindata" select="dyn:evaluate($DOCXPATH)"/>
		<xsl:value-of select="b64:decodeStringToFile($bindata, $filename)"/-->
	</xsl:template>
</xsl:stylesheet>
