<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:html="http://www.w3c.org/TR/xhtml1/" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format" 
	xmlns:dyn="http://exslt.org/dynamic"
 	xmlns:lib="uri:BMU_Waste_Interface/Bibliothek"
 	xmlns:bgs="uri:BMU_Waste_Interface/BGS" 
 	xmlns:msg="uri:BMU_Waste_Interface/Message" 
	xmlns:zks="uri:BMU_Waste_Interface/ZKS"
 	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
 	xmlns:b64="xalan://de.itu.util.Base64" 
 	xmlns:crc32="xalan://de.itu.util.CRC32Helper" 
 	xmlns:x509="xalan://de.itu.util.X509CertHelper" 
 	extension-element-prefixes="dyn b64 crc32 x509" 
 	exclude-result-prefixes="dyn b64 crc32 x509 bgs ds lib xsl fo">
	<xsl:import href="ZKS-Library.xsl"/>
	<xsl:output method="html"/>
	<!-- bei neuladen übergebene Parameter -->
	<xsl:param name="positionsnummer" select="1"/>
	<xsl:param name="nameXML"/>
	<xsl:param name="layerName" select="'ENSNErzLayer'"/>
	<xsl:param name="layerID" select="'ERZ-01-e6f6d730-0dbe-45b7-857c-0b7474c9ee07'"/>
	<xsl:template match="/">
		<xsl:choose>
			<xsl:when test="msg:Nachricht">
				<xsl:for-each select="msg:Nachricht/msg:Nutzdaten">
					<xsl:apply-templates/>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="zks:Nachweisliste">
		<html>
			<head>
				<title>Nachweisliste</title>
				<!-- CSS - Datei   -->
				<xsl:call-template name="Style"/>
			</head>
			<body>
				<xsl:call-template name="Kopf"/>
				<table width="100%" id="Tabelle-Haupt" cellspacing="6" cellpadding="6">
					<tr>
						<th>
							<xsl:call-template name="Zeile0"/>
						</th>
					</tr>
					<tr>
						<th>
							<xsl:call-template name="Zeile1"/>
							<br/>
							<xsl:call-template name="Zeile2"/>
							<br/>
							<xsl:call-template name="Zeile3"/>
							<br/>
							<xsl:call-template name="Zeile4"/>
							<br/>
							<xsl:call-template name="Zeile5"/>
						</th>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="Zeile0">
		<!-- erste Zeile im Dokument -->
		<table width="100%" border="0">
			<colgroup>
				<col width="60%"/>
				<col width="10%"/>
				<col width="30%"/>
			</colgroup>
			<tr>
				<td>
					<table width="100%" border="0">
						<tr id="Nummer">
							<td>Nachweisliste</td>
						</tr>
						<tr id="Ueberschrift2">
							<td>Beleg zum Nachweis der Entsorgung von Abf&#228;llen 
							</td>
						</tr>
					</table>
				</td>
				<td> </td>
				<td id="Nummer"> 
					Nr: 
					<xsl:call-template name="getTextValue">
						<xsl:with-param name="TagName" select="'zks:Nachweislistennummer/lib:PaginierNr'"/>
					</xsl:call-template>
					&#173;
					<xsl:call-template name="getTextValue">
						<xsl:with-param name="TagName" select="'zks:Nachweislistennummer/lib:Pruefziffer'"/>
					</xsl:call-template>
				</td>
			</tr>
		</table>
		<font id="noprint">
			<br/>
		</font>
	</xsl:template>
	<xsl:template name="Zeile1">
		<!-- erste Zeile im Dokument -->
		<table width="100%" border="0">
			<colgroup>
				<col width="70%"/>
				<col width="15%"/>
				<col width="15%"/>
			</colgroup>
			<tr>
				<td id="Titel"> Abfallbezeichnung </td>
				<td id="Titel"> Laufzeit von </td>
				<td id="Titel"> bis </td>
			</tr>
			<tr>
				<td>
					<!-- Abfallbezeichnung -->
					<xsl:call-template name="getTextValue">
						<xsl:with-param name="TagName" select="'zks:Daten/zks:Abfallbezeichnung'"/>
					</xsl:call-template>
				</td>
				<td>
					<!-- lz von -->
					<xsl:call-template name="getDateValue">
						<xsl:with-param name="TagName" select="'zks:Laufzeit/zks:DatumVon'"/>
					</xsl:call-template>
				</td>
				<td>
					<!-- lz bis -->
					<xsl:call-template name="getDateValue">
						<xsl:with-param name="TagName" select="'zks:Laufzeit/zks:DatumBis'"/>
					</xsl:call-template>
				</td>
			</tr>
		</table>
		<font id="noprint">
			<br/>
		</font>
	</xsl:template>
	<xsl:template name="Zeile2">
		<!-- zweite Zeile im Dokument -->
		<table width="100%" border="0">
			<colgroup>
				<col width="33%"/>
				<col width="33%"/>
				<col width="13%"/>
				<col width="20%"/>
			</colgroup>
			<tr>
				<td id="Titel">Abfallschl&#252;ssel</td>
				<td id="Titel">Entsorgungsnachweis-Nummer</td>
				<td id="Titel">Menge in t</td>
				<td id="Titel">Volumen in cbm</td>
			</tr>
			<tr>
				<td>
					<!-- Abfallschluessel -->
					<xsl:call-template name="getTextValue">
						<xsl:with-param name="TagName" select="'zks:Daten/zks:Abfallschluessel'"/>
					</xsl:call-template>
				</td>
				<td>
					<!-- NachweisNr -->
					<xsl:call-template name="getTextValue">
						<xsl:with-param name="TagName" select="'zks:Daten/zks:Nachweisnummer/lib:NachweisNr'"/>
					</xsl:call-template>
					&#173;
					<!-- Pruefziffer -->
					<xsl:call-template name="getTextValue">
						<xsl:with-param name="TagName" select="'zks:Daten/zks:Nachweisnummer/lib:Pruefziffer'"/>
					</xsl:call-template>
				</td>
				<td>
					<!--Menge  	-->
					<xsl:call-template name="getDoubleValue">
						<xsl:with-param name="TagName" select="'zks:Daten/zks:Menge'"/>
					</xsl:call-template>
					&#173;
					<xsl:call-template name="getTextValue">
						<xsl:with-param name="TagName" select="'zks:Daten/zks:Menge'"/>
						<xsl:with-param name="TagAttr" select="'@lib:Einheit'"/>
					</xsl:call-template>
				</td>
				<td>
					<!-- Volumen  	-->
					<xsl:call-template name="getTextValue">
						<xsl:with-param name="TagName" select="'zks:Daten/zks:Volumen'"/>
					</xsl:call-template>
					&#173;
					<xsl:call-template name="getTextValue">
						<xsl:with-param name="TagName" select="'zks:Daten/zks:Volumen'"/>
						<xsl:with-param name="TagAttr" select="'@lib:Einheit'"/>
					</xsl:call-template>
				</td>
			</tr>
		</table>
		<font id="noprint">
			<br/>
		</font>
	</xsl:template>
	<xsl:template name="Zeile3">
		<!-- dritte Zeile im Dokument -->
		<table width="100%" border="0">
			<colgroup>
				<col width="33%"/>
				<col width="33%"/>
				<col width="33%"/>
			</colgroup>
			<td>
				<!-- Erzeuger -->
				<table width="100%" border="0" height="50">
					<tr>
						<td id="Titel">Erzeugernummer</td>
					</tr>
					<tr>
						<td>
							<!-- BehoerdlicheNummer	-->
							<xsl:call-template name="getTextValue">
								<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Erzeuger/bgs:Nummer/lib:BehoerdlicheNr'"/>
							</xsl:call-template>
							&#173;
							<xsl:call-template name="getTextValue">
								<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Erzeuger/bgs:Nummer/lib:Pruefziffer'"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>
				<table width="100%" border="0" height="50">
					<tr>
						<td id="Titel">Datum der &#220;bergabe</td>
					</tr>
					<tr>
						<td>
							<!-- Datum-->
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Erzeuger/bgs:Datum'"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>
				<table width="100%" border="0" height="130">
					<tr>
						<td id="Titel">Firmenname, Anschrift</td>
					</tr>
					<tr>
						<td>
							<table width="100%" border="0" height="130" id="Tabelle" cellspacing="1" cellpadding="1">
								<tr>
									<td>
										<!--  Namen	-->
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Erzeuger/bgs:NameUndAdresse/lib:Name/lib:Name1'"/>
										</xsl:call-template>
										&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Erzeuger/bgs:NameUndAdresse/lib:Name/lib:Name2'"/>
										</xsl:call-template>
										&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Erzeuger/bgs:NameUndAdresse/lib:Name/lib:Name3'"/>
										</xsl:call-template>
										&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Erzeuger/bgs:NameUndAdresse/lib:Name/lib:Name4'"/>
										</xsl:call-template>
										<br/>
										<!--  Strassen	-->
										<xsl:call-template name="getTextValuePostfach">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Erzeuger/bgs:NameUndAdresse/lib:Adresse/lib:Strasse_1'"/>
											<xsl:with-param name="TagNamePostfach" select="'zks:Daten/zks:ATBListeNWL/zks:Erzeuger/bgs:NameUndAdresse/lib:Postfach/lib:Postfach'"/>
										</xsl:call-template>
								 		&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Erzeuger/bgs:NameUndAdresse/lib:Adresse/lib:Strasse_2'"/>
										</xsl:call-template>
								 		&#173;
										<!-- Hausnummer	-->
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Erzeuger/bgs:NameUndAdresse/lib:Adresse/lib:Hausnummer'"/>
										</xsl:call-template>
										<br/>
										<!-- Postleitzahl	-->
										<xsl:call-template name="getTextValuePostfach">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Erzeuger/bgs:NameUndAdresse/lib:Adresse/lib:Postleitzahl'"/>
											<xsl:with-param name="TagNamePostfach" select="'zks:Daten/zks:ATBListeNWL/zks:Erzeuger/bgs:NameUndAdresse/lib:Postfach/lib:Postleitzahl'"/>
										</xsl:call-template>
										&#173;
										<!-- Orte	-->
										<xsl:call-template name="getTextValuePostfach">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Erzeuger/bgs:NameUndAdresse/lib:Adresse/lib:Ort_1'"/>
											<xsl:with-param name="TagNamePostfach" select="'zks:Daten/zks:ATBListeNWL/zks:Erzeuger/bgs:NameUndAdresse/lib:Postfach/lib:Ort_1'"/>
										</xsl:call-template>
										&#173;
										<xsl:call-template name="getTextValuePostfach">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Erzeuger/bgs:NameUndAdresse/lib:Adresse/lib:Ort_2'"/>
											<xsl:with-param name="TagNamePostfach" select="'zks:Daten/zks:ATBListeNWL/zks:Erzeuger/bgs:NameUndAdresse/lib:Postfach/lib:Ort_2'"/>
										</xsl:call-template>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
			<!-- Befoerderer 1-->
			<td id="Tabelle_links">
				<table width="100%" border="0" height="50">
					<tr>
						<td id="Titel">Bef&#246;rderernummer</td>
					</tr>
					<tr>
						<td>
							<!-- BehoerdlicheNummer	-->
							<xsl:call-template name="getTextValue">
								<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Befoerderer/bgs:Nummer/lib:BehoerdlicheNr'"/>
							</xsl:call-template>
							&#173;
							<xsl:call-template name="getTextValue">
								<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Befoerderer/bgs:Nummer/lib:Pruefziffer'"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>
				<table width="100%" border="0" height="50">
					<tr>
						<td id="Titel">Datum der &#220;bernahme</td>
					</tr>
					<tr>
						<td>
							<!-- Datum	-->
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Befoerderer/bgs:Datum'"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>
				<table width="100%" border="0" height="130">
					<tr>
						<td id="Titel">Firmenname, Anschrift</td>
					</tr>
					<tr>
						<td>
							<table width="100%" border="0" height="130" id="Tabelle" cellspacing="1" cellpadding="1">
								<tr>
									<td>
										<!--  Namen	-->
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Befoerderer/bgs:NameUndAdresse/lib:Name/lib:Name1'"/>
										</xsl:call-template>
										&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Befoerderer/bgs:NameUndAdresse/lib:Name/lib:Name2'"/>
										</xsl:call-template>
										&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Befoerderer/bgs:NameUndAdresse/lib:Name/lib:Name3'"/>
										</xsl:call-template>
										&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Befoerderer/bgs:NameUndAdresse/lib:Name/lib:Name4'"/>
										</xsl:call-template>
										<br/>
										<!--  Strassen	-->
										<xsl:call-template name="getTextValuePostfach">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Befoerderer/bgs:NameUndAdresse/lib:Adresse/lib:Strasse_1'"/>
											<xsl:with-param name="TagNamePostfach" select="'zks:Daten/zks:ATBListeNWL/zks:Befoerderer/bgs:NameUndAdresse/lib:Postfach/lib:Postfach'"/>
										</xsl:call-template>
								 		&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Befoerderer/bgs:NameUndAdresse/lib:Adresse/lib:Strasse_2'"/>
										</xsl:call-template>
								 		&#173;
										<!-- Hausnummer	-->
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Befoerderer/bgs:NameUndAdresse/lib:Adresse/lib:Hausnummer'"/>
										</xsl:call-template>
										<br/>
										<!-- Postleitzahl	-->
										<xsl:call-template name="getTextValuePostfach">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Befoerderer/bgs:NameUndAdresse/lib:Adresse/lib:Postleitzahl'"/>
											<xsl:with-param name="TagNamePostfach" select="'zks:Daten/zks:ATBListeNWL/zks:Befoerderer/bgs:NameUndAdresse/lib:Postfach/lib:Postleitzahl'"/>
										</xsl:call-template>
										&#173;
										<!-- Orte	-->
										<xsl:call-template name="getTextValuePostfach">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Befoerderer/bgs:NameUndAdresse/lib:Adresse/lib:Ort_1'"/>
											<xsl:with-param name="TagNamePostfach" select="'zks:Daten/zks:ATBListeNWL/zks:Befoerderer/bgs:NameUndAdresse/lib:Postfach/lib:Ort_1'"/>
										</xsl:call-template>
										&#173;
										<xsl:call-template name="getTextValuePostfach">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Befoerderer/bgs:NameUndAdresse/lib:Adresse/lib:Ort_2'"/>
											<xsl:with-param name="TagNamePostfach" select="'zks:Daten/zks:ATBListeNWL/zks:Befoerderer/bgs:NameUndAdresse/lib:Postfach/lib:Ort_2'"/>
										</xsl:call-template>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
			<td id="Tabelle_links">
				<!-- Entsorger -->
				<table width="100%" border="0" height="50">
					<tr>
						<td id="Titel">Entsorgernummer</td>
					</tr>
					<tr>
						<td>
							<!-- BehoerdlicheNummer	-->
							<xsl:call-template name="getTextValue">
								<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Entsorger/bgs:Nummer/lib:BehoerdlicheNr'"/>
							</xsl:call-template>
							&#173;
							<xsl:call-template name="getTextValue">
								<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Entsorger/bgs:Nummer/lib:Pruefziffer'"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>
				<table width="100%" border="0" height="50">
					<tr>
						<td id="Titel">Datum der Annahme</td>
					</tr>
					<tr>
						<td>
							<!-- Datum-->
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Entsorger/bgs:Datum'"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>
				<table width="100%" border="0" height="130">
					<tr>
						<td id="Titel">Firmenname, Anschrift</td>
					</tr>
					<tr>
						<td>
							<table width="100%" border="0" height="130" id="Tabelle" cellspacing="1" cellpadding="1">
								<tr>
									<td>
										<!--  Namen	-->
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Entsorger/bgs:NameUndAdresse/lib:Name/lib:Name1'"/>
										</xsl:call-template>
										&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Entsorger/bgs:NameUndAdresse/lib:Name/lib:Name2'"/>
										</xsl:call-template>
										&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Entsorger/bgs:NameUndAdresse/lib:Name/lib:Name3'"/>
										</xsl:call-template>
										&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Entsorger/bgs:NameUndAdresse/lib:Name/lib:Name4'"/>
										</xsl:call-template>
										<br/>
										<!--  Strassen	-->
										<xsl:call-template name="getTextValuePostfach">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Entsorger/bgs:NameUndAdresse/lib:Adresse/lib:Strasse_1'"/>
											<xsl:with-param name="TagNamePostfach" select="'zks:Daten/zks:ATBListeNWL/zks:Entsorger/bgs:NameUndAdresse/lib:Postfach/lib:Postfach'"/>
										</xsl:call-template>
								 		&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Entsorger/bgs:NameUndAdresse/lib:Adresse/lib:Strasse_2'"/>
										</xsl:call-template>
								 		&#173;
										<!-- Hausnummer	-->
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Entsorger/bgs:NameUndAdresse/lib:Adresse/lib:Hausnummer'"/>
										</xsl:call-template>
										<br/>
										<!-- Postleitzahl	-->
										<xsl:call-template name="getTextValuePostfach">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Entsorger/bgs:NameUndAdresse/lib:Adresse/lib:Postleitzahl'"/>
											<xsl:with-param name="TagNamePostfach" select="'zks:Daten/zks:ATBListeNWL/zks:Entsorger/bgs:NameUndAdresse/lib:Postfach/lib:Postleitzahl'"/>
										</xsl:call-template>
										&#173;
										<!-- Orte	-->
										<xsl:call-template name="getTextValuePostfach">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Entsorger/bgs:NameUndAdresse/lib:Adresse/lib:Ort_1'"/>
											<xsl:with-param name="TagNamePostfach" select="'zks:Daten/zks:ATBListeNWL/zks:Entsorger/bgs:NameUndAdresse/lib:Postfach/lib:Ort_1'"/>
										</xsl:call-template>
										&#173;
										<xsl:call-template name="getTextValuePostfach">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Entsorger/bgs:NameUndAdresse/lib:Adresse/lib:Ort_2'"/>
											<xsl:with-param name="TagNamePostfach" select="'zks:Daten/zks:ATBListeNWL/zks:Entsorger/bgs:NameUndAdresse/lib:Postfach/lib:Ort_2'"/>
										</xsl:call-template>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
		</table>
		<font id="noprint">
			<br/>
		</font>
	</xsl:template>
	<xsl:template name="Zeile4">
		<!-- vierte Zeile im Dokument -->
		<table width="100%" border="0">
			<colgroup>
				<col width="33%"/>
				<col width="33%"/>
				<col width="33%"/>
			</colgroup>
			<td>
				<!-- Ruecknehmer -->
				<table width="100%" border="0" height="50">
					<tr>
						<td id="Titel">Nummer freiw. Rücknehmer</td>
					</tr>
					<tr>
						<td>
							<!-- BehoerdlicheNummer	-->
							<xsl:call-template name="getTextValue">
								<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Ruecknehmer/bgs:Nummer/lib:BehoerdlicheNr'"/>
							</xsl:call-template>
							&#173;
							<xsl:call-template name="getTextValue">
								<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Ruecknehmer/bgs:Nummer/lib:Pruefziffer'"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>
				<table width="100%" border="0" height="50">
					<tr>
						<td id="Titel">Datum</td>
					</tr>
					<tr>
						<td>
							<!-- Datum-->
							<xsl:call-template name="getDateValue">
								<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Ruecknehmer/bgs:Datum'"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>
				<table width="100%" border="0" height="130">
					<tr>
						<td id="Titel">Firmenname, Anschrift</td>
					</tr>
					<tr>
						<td>
							<table width="100%" border="0" height="130" id="Tabelle" cellspacing="1" cellpadding="1">
								<tr>
									<td>
										<!--  Namen	-->
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Ruecknehmer/bgs:NameUndAdresse/lib:Name/lib:Name1'"/>
										</xsl:call-template>
										&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Ruecknehmer/bgs:NameUndAdresse/lib:Name/lib:Name2'"/>
										</xsl:call-template>
										&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Ruecknehmer/bgs:NameUndAdresse/lib:Name/lib:Name3'"/>
										</xsl:call-template>
										&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Ruecknehmer/bgs:NameUndAdresse/lib:Name/lib:Name4'"/>
										</xsl:call-template>
										<br/>
										<!--  Strassen	-->
										<xsl:call-template name="getTextValuePostfach">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Ruecknehmer/bgs:NameUndAdresse/lib:Adresse/lib:Strasse_1'"/>
											<xsl:with-param name="TagNamePostfach" select="'zks:Daten/zks:ATBListeNWL/zks:Ruecknehmer/bgs:NameUndAdresse/lib:Postfach/lib:Postfach'"/>
										</xsl:call-template>
								 		&#173;
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Ruecknehmer/bgs:NameUndAdresse/lib:Adresse/lib:Strasse_2'"/>
										</xsl:call-template>
								 		&#173;
										<!-- Hausnummer	-->
										<xsl:call-template name="getTextValue">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Ruecknehmer/bgs:NameUndAdresse/lib:Adresse/lib:Hausnummer'"/>
										</xsl:call-template>
										<br/>
										<!-- Postleitzahl	-->
										<xsl:call-template name="getTextValuePostfach">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Ruecknehmer/bgs:NameUndAdresse/lib:Adresse/lib:Postleitzahl'"/>
											<xsl:with-param name="TagNamePostfach" select="'zks:Daten/zks:ATBListeNWL/zks:Ruecknehmer/bgs:NameUndAdresse/lib:Postfach/lib:Postleitzahl'"/>
										</xsl:call-template>
										&#173;
										<!-- Orte	-->
										<xsl:call-template name="getTextValuePostfach">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Ruecknehmer/bgs:NameUndAdresse/lib:Adresse/lib:Ort_1'"/>
											<xsl:with-param name="TagNamePostfach" select="'zks:Daten/zks:ATBListeNWL/zks:Ruecknehmer/bgs:NameUndAdresse/lib:Postfach/lib:Ort_1'"/>
										</xsl:call-template>
										&#173;
										<xsl:call-template name="getTextValuePostfach">
											<xsl:with-param name="TagName" select="'zks:Daten/zks:ATBListeNWL/zks:Ruecknehmer/bgs:NameUndAdresse/lib:Adresse/lib:Ort_2'"/>
											<xsl:with-param name="TagNamePostfach" select="'zks:Daten/zks:ATBListeNWL/zks:Ruecknehmer/bgs:NameUndAdresse/lib:Postfach/lib:Ort_2'"/>
										</xsl:call-template>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
			<td id="Tabelle_links">
				<!-- dummy -->
			</td>
			<td id="Tabelle_links">
				<!-- dummy -->
			</td>
		</table>
	</xsl:template>
	<xsl:template name="Zeile5">
		<!-- fünfte Zeile im Dokument -->
		<table width="100%" border="0">
			<tr>
				<td id="Titel"> Frei für Vermerke </td>
			</tr>
			<tr>
				<td>
					<table width="100%" id="Tabelle" cellspacing="1" cellpadding="1">
						<tr>
							<td>
								<!--Vermerke 	-->
								<xsl:call-template name="getTextValue">
									<xsl:with-param name="TagName" select="'zks:Daten/zks:Vermerke'"/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
			<table width="100%">
				<tr width="100%">
					<td width="50%" id="Titel">Unterschrift (Signatur)</td>
					<td width="50%" id="Titel">2. Unterschrift (2. Signatur)</td>
				</tr>
				<tr width="100%">
					<td width="50%">
						<xsl:call-template name="Sig1NameNoLayer"/>
					</td>
					<td width="50%">
						<xsl:call-template name="Sig2NameNoLayer"/>
					</td>
				</tr>
			</table>

	</xsl:template>
</xsl:stylesheet>
