/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.SignatureVerificationResult;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SignatureVerificationResultImpl
implements SignatureVerificationResult,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(SignatureVerificationResultImpl.class);
    private String _signatureID;
    private SignatureVerificationResult.VerificationStatus _verificationStatus;
    private String _subjectDN;
    private Date _signingTime;
    private boolean _eIDAS;

    public SignatureVerificationResultImpl() {
    }

    public SignatureVerificationResultImpl(String signatureID, String subjectDN, Date signingTime, boolean eIDAS) {
        this._signatureID = signatureID;
        this._verificationStatus = SignatureVerificationResult.VerificationStatus.UNCHECKED;
        this._subjectDN = subjectDN;
        this._signingTime = signingTime;
        this._eIDAS = eIDAS;
    }

    @Override
    public final String getSignatureID() {
        return this._signatureID;
    }

    @Override
    public final SignatureVerificationResult.VerificationStatus getVerificationStatus() {
        return this._verificationStatus;
    }

    @Override
    public final void setVerificationStatus(SignatureVerificationResult.VerificationStatus status) {
        this._verificationStatus = status;
    }

    @Override
    public final String getSubjectDN() {
        return this._subjectDN;
    }

    @Override
    public final Date getSigningTime() {
        return this._signingTime;
    }

    @Override
    public final boolean isEIDAS() {
        return this._eIDAS;
    }

    @Override
    public final boolean isEnabled(RuleDef ruleDef) {
        boolean retVal = true;
        LOGGER.trace((Object)("<isEnabled> signatureID: " + this._signatureID + ", rule: " + ruleDef.getName()));
        if (this._verificationStatus == SignatureVerificationResult.VerificationStatus.UNCHECKED) {
            LOGGER.trace((Object)"Signature was not yet verified !");
            retVal = false;
        } else if (ruleDef.getUseSignatureDate()) {
            if (ruleDef.getKeyDate().after(this._signingTime)) {
                LOGGER.trace((Object)"Signing time is before 'valid from'");
                retVal = false;
            } else if (ruleDef.getKeyToDate().before(this._signingTime)) {
                LOGGER.trace((Object)"Signing time is after 'valid to'");
                retVal = false;
            }
        }
        LOGGER.trace((Object)("<isEnabled> returns " + retVal));
        return retVal;
    }

    public static class Adapter
    extends XmlAdapter<SignatureVerificationResultImpl, SignatureVerificationResult> {
        public final SignatureVerificationResult unmarshal(SignatureVerificationResultImpl resultImpl) {
            return resultImpl;
        }

        public final SignatureVerificationResultImpl marshal(SignatureVerificationResult result) {
            return (SignatureVerificationResultImpl)result;
        }
    }
}

